/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.core.JsonGenerator;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.core.JsonToken;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.core.type.WritableTypeId;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.JavaType;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.JsonMappingException;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.JsonNode;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.SerializerProvider;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.jsontype.TypeSerializer;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.node.ObjectNode;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        g2.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        g2.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

