/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.compression;

import java.io.IOException;
import java.io.Serializable;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.bits.BitVector;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.bits.LongArrayBitVector;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.compression.Decoder;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.booleans.BooleanIterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.InputBitStream;

public final class TreeDecoder
implements Decoder,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final boolean DEBUG = false;
    private final Node root;
    private final int n;

    public TreeDecoder(Node root, int n) {
        this.root = root;
        this.n = n;
    }

    public TreeDecoder(BitVector[] lexSortedCodeWord, int[] symbol) {
        this(TreeDecoder.buildTree(lexSortedCodeWord, symbol, 0, 0, lexSortedCodeWord.length), lexSortedCodeWord.length);
    }

    private static Node buildTree(BitVector[] lexSortedCodeWords, int[] symbol, int prefix, int offset, int length) {
        if (length == 1) {
            return new LeafNode(symbol[offset]);
        }
        int i = length - 1;
        while (i-- != 0) {
            if (lexSortedCodeWords[offset + i].getBoolean(prefix) == lexSortedCodeWords[offset + i + 1].getBoolean(prefix)) continue;
            Node node = new Node();
            node.left = TreeDecoder.buildTree(lexSortedCodeWords, symbol, prefix + 1, offset, i + 1);
            node.right = TreeDecoder.buildTree(lexSortedCodeWords, symbol, prefix + 1, offset + i + 1, length - i - 1);
            return node;
        }
        throw new IllegalStateException();
    }

    @Override
    public int decode(BooleanIterator iterator) {
        Node n = this.root;
        while (!(n instanceof LeafNode)) {
            n = iterator.nextBoolean() ? n.right : n.left;
        }
        return ((LeafNode)n).symbol;
    }

    @Override
    public int decode(InputBitStream ibs) throws IOException {
        Node n = this.root;
        while (!(n instanceof LeafNode)) {
            n = ibs.readBit() == 0 ? n.left : n.right;
        }
        return ((LeafNode)n).symbol;
    }

    private void buildCodes(BitVector[] codeWord, Node node, BitVector prefix) {
        if (node instanceof LeafNode) {
            codeWord[((LeafNode)node).symbol] = prefix;
            return;
        }
        BitVector bitVector = prefix.copy();
        bitVector.length(bitVector.length() + 1L);
        this.buildCodes(codeWord, node.left, bitVector);
        bitVector = prefix.copy();
        bitVector.length(bitVector.length() + 1L);
        bitVector.set(bitVector.length() - 1L);
        this.buildCodes(codeWord, node.right, bitVector);
    }

    public BitVector[] buildCodes() {
        BitVector[] codeWord = new BitVector[this.n];
        this.buildCodes(codeWord, this.root, LongArrayBitVector.getInstance());
        return codeWord;
    }

    private static void visit(Node node, LongArrayBitVector bitVector) {
        if (node instanceof LeafNode) {
            return;
        }
        do {
            bitVector.add(true);
            TreeDecoder.visit(node.left, bitVector);
            bitVector.add(false);
        } while (!((node = node.right) instanceof LeafNode));
    }

    public LongArrayBitVector succinctRepresentation() {
        LongArrayBitVector bitVector = LongArrayBitVector.getInstance();
        bitVector.add(true);
        if (this.root != null) {
            TreeDecoder.visit(this.root, bitVector);
        }
        bitVector.add(false);
        bitVector.trim();
        return bitVector;
    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Node left;
        public Node right;
    }

    public static class LeafNode
    extends Node {
        private static final long serialVersionUID = 1L;
        public final int symbol;

        public LeafNode(int symbol) {
            this.symbol = symbol;
        }
    }
}

