/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.io.MeasurableInputStream;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.io.RepositionableStream;

public class ByteBufferInputStream
extends MeasurableInputStream
implements RepositionableStream {
    private static int CHUNK_SHIFT = 30;
    public static final long CHUNK_SIZE = 1L << CHUNK_SHIFT;
    private final ByteBuffer[] byteBuffer;
    private final boolean[] readyToUse;
    private final int n;
    private int curr;
    private long mark;
    private final long size;
    private final int lastBufferCapacity;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this(new ByteBuffer[]{byteBuffer}, byteBuffer.capacity(), 0, new boolean[1]);
    }

    protected ByteBufferInputStream(ByteBuffer[] byteBuffer, long size, int curr, boolean[] readyToUse) {
        this.byteBuffer = byteBuffer;
        this.n = byteBuffer.length;
        this.curr = curr;
        this.size = size;
        this.readyToUse = readyToUse;
        this.mark = -1L;
        for (int i = 0; i < this.n; ++i) {
            if (i >= this.n - 1 || (long)byteBuffer[i].capacity() == CHUNK_SIZE) continue;
            throw new IllegalArgumentException();
        }
        this.lastBufferCapacity = byteBuffer[this.n - 1].capacity();
    }

    public static ByteBufferInputStream map(FileChannel fileChannel) throws IOException {
        return ByteBufferInputStream.map(fileChannel, FileChannel.MapMode.READ_ONLY);
    }

    public static ByteBufferInputStream map(FileChannel fileChannel, FileChannel.MapMode mapMode) throws IOException {
        long size = fileChannel.size();
        int chunks = (int)((size + (CHUNK_SIZE - 1L)) / CHUNK_SIZE);
        ByteBuffer[] byteBuffer = new ByteBuffer[chunks];
        for (int i = 0; i < chunks; ++i) {
            byteBuffer[i] = fileChannel.map(mapMode, (long)i * CHUNK_SIZE, Math.min(CHUNK_SIZE, size - (long)i * CHUNK_SIZE));
        }
        byteBuffer[0].position(0);
        boolean[] readyToUse = new boolean[chunks];
        Arrays.fill(readyToUse, true);
        return new ByteBufferInputStream(byteBuffer, size, 0, readyToUse);
    }

    private ByteBuffer byteBuffer(int n) {
        if (this.readyToUse[n]) {
            return this.byteBuffer[n];
        }
        this.readyToUse[n] = true;
        this.byteBuffer[n] = this.byteBuffer[n].duplicate();
        return this.byteBuffer[n];
    }

    private long remaining() {
        return this.curr == this.n - 1 ? (long)this.byteBuffer(this.curr).remaining() : (long)this.byteBuffer(this.curr).remaining() + ((long)(this.n - 2 - this.curr) << CHUNK_SHIFT) + (long)this.lastBufferCapacity;
    }

    public int available() {
        long available = this.remaining();
        return available <= Integer.MAX_VALUE ? (int)available : Integer.MAX_VALUE;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int unused) {
        this.mark = this.position();
    }

    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException();
        }
        this.position(this.mark);
    }

    public long skip(long n) throws IOException {
        long toSkip = Math.min(this.remaining(), n);
        this.position(this.position() + toSkip);
        return toSkip;
    }

    public int read() {
        if (!this.byteBuffer(this.curr).hasRemaining()) {
            if (this.curr < this.n - 1) {
                this.byteBuffer(++this.curr).position(0);
            } else {
                return -1;
            }
        }
        return this.byteBuffer[this.curr].get() & 0xFF;
    }

    public int read(byte[] b, int offset, int length) {
        int rem;
        if (length == 0) {
            return 0;
        }
        long remaining = this.remaining();
        if (remaining == 0L) {
            return -1;
        }
        int realLength = (int)Math.min(remaining, (long)length);
        for (int read = 0; read < realLength; read += Math.min(realLength - read, rem)) {
            rem = this.byteBuffer(this.curr).remaining();
            if (rem == 0) {
                this.byteBuffer(++this.curr).position(0);
                rem = this.byteBuffer(this.curr).remaining();
            }
            this.byteBuffer[this.curr].get(b, offset + read, Math.min(realLength - read, rem));
        }
        return realLength;
    }

    public long length() {
        return this.size;
    }

    public long position() {
        return ((long)this.curr << CHUNK_SHIFT) + (long)this.byteBuffer(this.curr).position();
    }

    public void position(long newPosition) {
        if ((newPosition = Math.min(newPosition, this.length())) == this.length()) {
            this.curr = this.n - 1;
            ByteBuffer buffer = this.byteBuffer(this.curr);
            buffer.position(buffer.capacity());
            return;
        }
        this.curr = (int)(newPosition >>> CHUNK_SHIFT);
        this.byteBuffer(this.curr).position((int)(newPosition - ((long)this.curr << CHUNK_SHIFT)));
    }

    public ByteBufferInputStream copy() {
        return new ByteBufferInputStream((ByteBuffer[])this.byteBuffer.clone(), this.size, this.curr, new boolean[this.n]);
    }
}

