/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.stat;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;

public class Jackknife {
    public static final MathContext DEFAULT_MATH_CONTEXT = new MathContext(100, RoundingMode.HALF_EVEN);
    public final BigDecimal[] bigEstimate;
    public final double[] estimate;
    public final double[] standardError;
    public static Statistic IDENTITY = (sample, unused) -> sample;

    public static double[] bigDecimalArray2DoubleArray(BigDecimal[] input) {
        double[] output = new double[input.length];
        int i = input.length;
        while (i-- != 0) {
            output[i] = input[i].doubleValue();
        }
        return output;
    }

    public static BigDecimal[] doubleArray2BigDecimalArray(double[] input) {
        BigDecimal[] output = new BigDecimal[input.length];
        int i = input.length;
        while (i-- != 0) {
            output[i] = BigDecimal.valueOf(input[i]);
        }
        return output;
    }

    private Jackknife(BigDecimal[] estimate, double[] standardError) {
        this.standardError = standardError;
        this.estimate = Jackknife.bigDecimalArray2DoubleArray(estimate);
        this.bigEstimate = estimate;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        int i = this.estimate.length;
        while (i++ != 0) {
            s2.append(this.estimate[i]).append('\t').append(this.standardError[i]).append(System.getProperty("\n"));
        }
        return s2.toString();
    }

    public static Jackknife compute(List<double[]> samples, Statistic f) {
        return Jackknife.compute(samples, f, DEFAULT_MATH_CONTEXT);
    }

    public static Jackknife compute(List<double[]> samples, Statistic f, MathContext mc) {
        int n = samples.size();
        BigDecimal big1OverN = BigDecimal.ONE.divide(BigDecimal.valueOf(n), mc);
        BigDecimal big1OverNMinus1 = BigDecimal.ONE.divide(BigDecimal.valueOf(n - 1), mc);
        BigDecimal bigNMinus1OverN = BigDecimal.valueOf(n - 1).divide(BigDecimal.valueOf(n), mc);
        int l = samples.get(0).length;
        BigDecimal[] sum = new BigDecimal[l];
        int p = l;
        while (p-- != 0) {
            sum[p] = BigDecimal.ZERO;
        }
        for (double[] sample : samples) {
            if (sample.length != l) {
                throw new IllegalArgumentException("Samples have different sizes: " + sample.length + " != " + l);
            }
            int p2 = l;
            while (p2-- != 0) {
                sum[p2] = sum[p2].add(BigDecimal.valueOf(sample[p2]), mc);
            }
        }
        BigDecimal[] averagedSample = new BigDecimal[l];
        int p3 = l;
        while (p3-- != 0) {
            averagedSample[p3] = sum[p3].multiply(big1OverN, mc);
        }
        BigDecimal[] naiveStatistics = f.compute(averagedSample, mc);
        int k = naiveStatistics.length;
        BigDecimal[][] leaveOneOutStatistic = new BigDecimal[n][];
        for (int s2 = 0; s2 < n; ++s2) {
            BigDecimal[] leaveOneOutSample = new BigDecimal[l];
            double[] t2 = samples.get(s2);
            int p4 = l;
            while (p4-- != 0) {
                leaveOneOutSample[p4] = sum[p4].subtract(BigDecimal.valueOf(t2[p4]), mc).multiply(big1OverNMinus1, mc);
            }
            leaveOneOutStatistic[s2] = f.compute(leaveOneOutSample, mc);
            if (leaveOneOutStatistic[s2].length == k) continue;
            throw new IllegalArgumentException("Statistics have different sizes: " + leaveOneOutStatistic[s2].length + " != " + k);
        }
        BigDecimal[] estimate = new BigDecimal[k];
        double[] standardError = new double[k];
        int i = k;
        while (i-- != 0) {
            BigDecimal e = BigDecimal.valueOf(n).multiply(naiveStatistics[i], mc);
            int s3 = n;
            while (s3-- != 0) {
                e = e.subtract(leaveOneOutStatistic[s3][i].multiply(bigNMinus1OverN, mc), mc);
            }
            estimate[i] = e;
            BigDecimal variance = BigDecimal.ZERO;
            int s4 = n;
            while (s4-- != 0) {
                BigDecimal t3 = naiveStatistics[i].subtract(leaveOneOutStatistic[s4][i], mc);
                variance = variance.add(t3.multiply(t3, mc), mc);
            }
            standardError[i] = Math.sqrt(variance.multiply(bigNMinus1OverN, mc).doubleValue());
        }
        return new Jackknife(estimate, standardError);
    }

    public static interface Statistic {
        public BigDecimal[] compute(BigDecimal[] var1, MathContext var2);
    }

    public static abstract class AbstractStatistic
    implements Statistic {
        public abstract double[] compute(double[] var1);

        @Override
        public BigDecimal[] compute(BigDecimal[] bigSample, MathContext unused) {
            return Jackknife.doubleArray2BigDecimalArray(this.compute(Jackknife.bigDecimalArray2DoubleArray(bigSample)));
        }
    }
}

