/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.util;

import com.google.common.base.Charsets;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import com.martiansoftware.jsap.stringparsers.IntSizeStringParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;
import java.util.zip.GZIPInputStream;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.bytes.ByteArrayFrontCodedList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.chars.CharArrayFrontCodedList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.io.BinIO;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.AbstractObjectList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.ObjectIterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.FastBufferedReader;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.LineIterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.lang.MutableString;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.logging.ProgressLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontCodedStringList
extends AbstractObjectList<MutableString>
implements RandomAccess,
Serializable {
    public static final long serialVersionUID = 1L;
    protected final ByteArrayFrontCodedList byteFrontCodedList;
    protected final CharArrayFrontCodedList charFrontCodedList;
    protected final boolean utf8;

    public FrontCodedStringList(final Iterator<? extends CharSequence> words, int ratio, boolean utf8) {
        this.utf8 = utf8;
        if (utf8) {
            this.byteFrontCodedList = new ByteArrayFrontCodedList((Iterator)new ObjectIterator<byte[]>(){

                @Override
                public boolean hasNext() {
                    return words.hasNext();
                }

                @Override
                public byte[] next() {
                    return ((CharSequence)words.next()).toString().getBytes(Charsets.UTF_8);
                }
            }, ratio);
            this.charFrontCodedList = null;
        } else {
            this.charFrontCodedList = new CharArrayFrontCodedList((Iterator)new ObjectIterator<char[]>(){

                @Override
                public boolean hasNext() {
                    return words.hasNext();
                }

                @Override
                public char[] next() {
                    CharSequence s2 = (CharSequence)words.next();
                    int i = s2.length();
                    char[] a = new char[i];
                    while (i-- != 0) {
                        a[i] = s2.charAt(i);
                    }
                    return a;
                }
            }, ratio);
            this.byteFrontCodedList = null;
        }
    }

    public FrontCodedStringList(Collection<? extends CharSequence> c, int ratio, boolean utf8) {
        this(c.iterator(), ratio, utf8);
    }

    public boolean utf8() {
        return this.utf8;
    }

    public int ratio() {
        return this.utf8 ? this.byteFrontCodedList.ratio() : this.charFrontCodedList.ratio();
    }

    @Override
    public MutableString get(int index) {
        return MutableString.wrap(this.utf8 ? FrontCodedStringList.byte2Char(this.byteFrontCodedList.getArray(index), null) : this.charFrontCodedList.getArray(index));
    }

    public void get(int index, MutableString s2) {
        if (this.utf8) {
            byte[] a = this.byteFrontCodedList.getArray(index);
            s2.length(FrontCodedStringList.countUTF8Chars(a));
            FrontCodedStringList.byte2Char(a, s2.array());
        } else {
            s2.length(s2.array().length);
            int res = this.charFrontCodedList.get(index, s2.array());
            if (res < 0) {
                s2.length(s2.array().length - res);
                res = this.charFrontCodedList.get(index, s2.array());
            } else {
                s2.length(res);
            }
        }
    }

    protected static int countUTF8Chars(byte[] a) {
        int length = a.length;
        int result = 0;
        for (int i = 0; i < length; ++i) {
            int b = (a[i] & 0xFF) >> 4;
            if (b < 8) {
                ++result;
                continue;
            }
            if (b < 14) {
                ++result;
                ++i;
                continue;
            }
            if (b < 15) {
                ++result;
                i += 2;
                continue;
            }
            result += 2;
            i += 4;
        }
        return result;
    }

    protected static char[] byte2Char(byte[] a, char[] s2) {
        int length = a.length;
        if (s2 == null) {
            s2 = new char[FrontCodedStringList.countUTF8Chars(a)];
        }
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int c;
            int b = a[i] & 0xFF;
            int t2 = b >> 4;
            if (t2 < 8) {
                s2[j++] = (char)b;
                continue;
            }
            if (t2 < 14) {
                if (((c = a[++i] & 0xFF) & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s2[j++] = (char)((b & 0x1F) << 6 | c & 0x3F);
                continue;
            }
            if (t2 < 15) {
                c = a[++i] & 0xFF;
                byte d = a[++i];
                if ((c & 0xC0) != 128 || (d & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s2[j++] = (char)((b & 0xF) << 12 | (c & 0x3F) << 6 | (d & 0x3F) << 0);
                continue;
            }
            String surrogatePair = new String(a, i, 4, Charsets.UTF_8);
            s2[j++] = surrogatePair.charAt(0);
            s2[j++] = surrogatePair.charAt(1);
            i += 3;
        }
        return s2;
    }

    @Override
    public ObjectListIterator<MutableString> listIterator(final int k) {
        return new ObjectListIterator<MutableString>(){
            ObjectListIterator<?> i;
            {
                this.i = FrontCodedStringList.this.utf8 ? FrontCodedStringList.this.byteFrontCodedList.listIterator(k) : FrontCodedStringList.this.charFrontCodedList.listIterator(k);
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            @Override
            public MutableString next() {
                return MutableString.wrap(FrontCodedStringList.this.utf8 ? FrontCodedStringList.byte2Char((byte[])this.i.next(), null) : (char[])this.i.next());
            }

            @Override
            public MutableString previous() {
                return MutableString.wrap(FrontCodedStringList.this.utf8 ? FrontCodedStringList.byte2Char((byte[])this.i.previous(), null) : (char[])this.i.previous());
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex();
            }
        };
    }

    @Override
    public int size() {
        return this.utf8 ? this.byteFrontCodedList.size() : this.charFrontCodedList.size();
    }

    public static void main(String[] arg) throws IOException, JSAPException, NoSuchMethodException {
        SimpleJSAP jsap = new SimpleJSAP(FrontCodedStringList.class.getName(), "Builds a front-coded string list reading from standard input a newline-separated ordered list of strings.", new Parameter[]{new FlaggedOption("bufferSize", IntSizeStringParser.getParser(), "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read strings."), new FlaggedOption("encoding", ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The file encoding."), new FlaggedOption("ratio", IntSizeStringParser.getParser(), "4", false, 'r', "ratio", "The compression ratio."), new Switch("utf8", 'u', "utf8", "Store the strings as UTF-8 byte arrays."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("frontCodedList", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised front-coded list.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        int ratio = jsapResult.getInt("ratio");
        boolean utf8 = jsapResult.getBoolean("utf8");
        boolean zipped = jsapResult.getBoolean("zipped");
        String listName = jsapResult.getString("frontCodedList");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        Logger logger = LoggerFactory.getLogger(FrontCodedStringList.class);
        ProgressLogger pl = new ProgressLogger(logger);
        pl.displayFreeMemory = true;
        pl.displayLocalSpeed = true;
        pl.itemsName = "strings";
        pl.start("Reading strings...");
        FrontCodedStringList frontCodedStringList = new FrontCodedStringList(new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding), bufferSize), pl), ratio, utf8);
        pl.done();
        logger.info("Writing front-coded list to file...");
        BinIO.storeObject((Object)frontCodedStringList, (CharSequence)listName);
        logger.info("Completed.");
    }
}

