/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.util;

import java.io.EOFException;
import java.io.IOException;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.AbstractLongList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.InputBitStream;

public class SemiExternalGammaList
extends AbstractLongList {
    public static final int DEFAULT_STEP = 128;
    private final long[] position;
    private final InputBitStream ibs;
    private final int step;
    private final int numLongs;

    public SemiExternalGammaList(InputBitStream longs, int step, int numLongs) throws IOException {
        this.step = step == -1 ? 128 : step;
        int slots = (numLongs + this.step - 1) / this.step;
        this.position = new long[slots];
        this.numLongs = numLongs;
        this.ibs = longs;
        this.ibs.position(0L);
        this.ibs.readBits(0L);
        int lastSlot = this.position.length - 1;
        for (int i = 0; i <= lastSlot; ++i) {
            this.position[i] = this.ibs.readBits();
            if (i == lastSlot) continue;
            this.ibs.skipGammas(this.step);
        }
    }

    public SemiExternalGammaList(InputBitStream longs) throws IOException {
        this(longs, 128, SemiExternalGammaList.estimateNumberOfLongs(longs));
    }

    private static int estimateNumberOfLongs(InputBitStream longs) {
        int numLongs = 0;
        try {
            longs.position(0L);
            while (true) {
                longs.readLongGamma();
                ++numLongs;
            }
        }
        catch (EOFException e) {
            return numLongs;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final long getLong(int index) {
        if (index < 0 || index >= this.numLongs) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int slotNumber = index / this.step;
        int k = index % this.step;
        try {
            this.ibs.position(this.position[slotNumber]);
            this.ibs.skipGammas(k);
            return this.ibs.readLongGamma();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.numLongs;
    }
}

