/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.util;

import java.io.Serializable;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.Util;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.HashCommon;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.logging.ProgressLogger;
import org.apache.commons.math3.random.AbstractRandomGenerator;

public class SplitMix64RandomGenerator
extends AbstractRandomGenerator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final long PHI = -7046029254386353131L;
    private long x;

    public SplitMix64RandomGenerator() {
        this(Util.randomSeed());
    }

    public SplitMix64RandomGenerator(long seed) {
        this.setSeed(seed);
    }

    private static long staffordMix13(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    private static int staffordMix4Upper32(long z) {
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    @Override
    public long nextLong() {
        return SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L);
    }

    @Override
    public int nextInt() {
        return SplitMix64RandomGenerator.staffordMix4Upper32(this.x += -7046029254386353131L);
    }

    @Override
    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t2 = SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L);
        long nMinus1 = n - 1L;
        if ((n & nMinus1) == 0L) {
            return t2 & nMinus1;
        }
        long u = t2 >>> 1;
        while (u + nMinus1 - (t2 = u % n) < 0L) {
            u = SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L) >>> 1;
        }
        return t2;
    }

    @Override
    public double nextDouble() {
        return (double)(SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L) >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public float nextFloat() {
        return (float)(SplitMix64RandomGenerator.staffordMix4Upper32(this.x += -7046029254386353131L) >>> 8) * 5.9604645E-8f;
    }

    @Override
    public boolean nextBoolean() {
        return SplitMix64RandomGenerator.staffordMix4Upper32(this.x += -7046029254386353131L) < 0;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L);
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    @Override
    public void setSeed(long seed) {
        this.x = HashCommon.murmurHash3(seed);
    }

    public void setState(long state) {
        this.x = state;
    }

    public static void main(String[] arg) {
        long n = Long.parseLong(arg[0]);
        long x = 0L;
        ProgressLogger pl = new ProgressLogger();
        SplitMix64RandomGenerator r = new SplitMix64RandomGenerator();
        int k = 10;
        while (k-- != 0) {
            pl.start("Measuring...");
            long i = n;
            while (i-- != 0L) {
                x ^= r.nextLong();
            }
            pl.done(n);
            if (x != 0L) continue;
            System.out.println(x);
        }
    }
}

