/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.modules.send;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerConnectRequest;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public class CommandSend
extends Command
implements TabExecutor {
    public CommandSend() {
        super("send", "bungeecord.command.send", new String[0]);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        List<ProxiedPlayer> targets;
        if (args.length != 2) {
            sender.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("send_cmd_usage", sender.getLanguageType()));
            return;
        }
        ServerInfo server = ProxyServer.getInstance().getServerInfo(args[1]);
        if (server == null) {
            sender.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("no_server", sender.getLanguageType()));
            return;
        }
        if (args[0].equalsIgnoreCase("all")) {
            targets = new ArrayList<ProxiedPlayer>(ProxyServer.getInstance().getPlayers());
        } else if (args[0].equalsIgnoreCase("current")) {
            if (!(sender instanceof ProxiedPlayer)) {
                sender.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("player_only", sender.getLanguageType()));
                return;
            }
            ProxiedPlayer player = (ProxiedPlayer)sender;
            targets = new ArrayList<ProxiedPlayer>(player.getServer().getInfo().getPlayers());
        } else {
            ServerInfo serverTarget = ProxyServer.getInstance().getServerInfo(args[0]);
            if (serverTarget != null) {
                targets = new ArrayList<ProxiedPlayer>(serverTarget.getPlayers());
            } else {
                ProxiedPlayer player = ProxyServer.getInstance().getPlayer(args[0]);
                if (player == null) {
                    sender.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("user_not_online", sender.getLanguageType()));
                    return;
                }
                targets = Collections.singletonList(player);
            }
        }
        SendCallback callback = new SendCallback(sender);
        for (ProxiedPlayer player : targets) {
            ServerConnectRequest request = ServerConnectRequest.builder().target(server).reason(ServerConnectEvent.Reason.COMMAND).callback(new SendCallback.Entry(callback, player, server)).build();
            player.connect(request);
        }
        sender.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("command_send_players", sender.getLanguageType()).replace("count", "" + targets.size()).replace("target", server.getName()));
    }

    @Override
    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length > 2 || args.length == 0) {
            return ImmutableSet.of();
        }
        HashSet<String> matches = new HashSet<String>();
        if (args.length == 1) {
            String search = args[0].toLowerCase(Locale.ROOT);
            for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
                if (!player.getName().toLowerCase(Locale.ROOT).startsWith(search)) continue;
                matches.add(player.getName());
            }
            if ("all".startsWith(search)) {
                matches.add("all");
            }
            if ("current".startsWith(search)) {
                matches.add("current");
            }
        } else {
            String search = args[1].toLowerCase(Locale.ROOT);
            for (String server : ProxyServer.getInstance().getServersCopy().keySet()) {
                if (!server.toLowerCase(Locale.ROOT).startsWith(search)) continue;
                matches.add(server);
            }
        }
        return matches;
    }

    protected static class SendCallback {
        private final Map<ServerConnectRequest.Result, List<String>> results = new HashMap<ServerConnectRequest.Result, List<String>>();
        private final CommandSender sender;
        private int count = 0;

        public SendCallback(CommandSender sender) {
            this.sender = sender;
            for (ServerConnectRequest.Result result : ServerConnectRequest.Result.values()) {
                this.results.put(result, Collections.synchronizedList(new ArrayList()));
            }
        }

        public void lastEntryDone() {
            this.sender.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("command_send_results", this.sender.getLanguageType()));
            for (Map.Entry<ServerConnectRequest.Result, List<String>> entry : this.results.entrySet()) {
                ComponentBuilder builder = new ComponentBuilder("");
                if (!entry.getValue().isEmpty()) {
                    builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(Joiner.on(", ").join((Iterable<? extends Object>)entry.getValue())).color(ChatColor.YELLOW).create()));
                }
                builder.append(entry.getKey().name() + ": ").color(ChatColor.GREEN);
                builder.append("" + entry.getValue().size()).bold(true);
                this.sender.sendMessage(builder.create());
            }
        }

        public static class Entry
        implements Callback<ServerConnectRequest.Result> {
            private final SendCallback callback;
            private final ProxiedPlayer player;
            private final ServerInfo target;

            public Entry(SendCallback callback, ProxiedPlayer player, ServerInfo target) {
                this.callback = callback;
                this.player = player;
                this.target = target;
                ++this.callback.count;
            }

            @Override
            public void done(ServerConnectRequest.Result result, Throwable error) {
                this.callback.results.get((Object)result).add(this.player.getName());
                if (result == ServerConnectRequest.Result.SUCCESS) {
                    this.player.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("you_got_summoned", this.player.getLanguageType()).replace("target", this.target.getName()).replace("sender", this.callback.sender.getName()));
                }
                if (--this.callback.count == 0) {
                    this.callback.lastEntryDone();
                }
            }
        }
    }
}

