/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives.compression.libdeflate;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.zip.DataFormatException;
import net.shieldcommunity.nullcordx.natives.compression.Decompressor;
import net.shieldcommunity.nullcordx.natives.compression.jni.NativeLibdeflateInflate;

public class LibdeflateDecompressor
implements Decompressor {
    private final long inflateCtx = NativeLibdeflateInflate.init();
    private boolean closed = false;

    @Override
    public void inflate(ByteBuf source, ByteBuf destination, int uncompressedSize) throws DataFormatException {
        Preconditions.checkState(!this.closed, "Decompressor already closed");
        destination.ensureWritable(uncompressedSize);
        long sourceAddress = source.memoryAddress() + (long)source.readerIndex();
        long destinationAddress = destination.memoryAddress() + (long)destination.writerIndex();
        NativeLibdeflateInflate.process(this.inflateCtx, sourceAddress, source.readableBytes(), destinationAddress, uncompressedSize);
        destination.writerIndex(destination.writerIndex() + uncompressedSize);
    }

    @Override
    public void close() {
        if (!this.closed) {
            NativeLibdeflateInflate.close(this.inflateCtx);
        }
        this.closed = true;
    }

    @Override
    public boolean isNeedDirectBuffer() {
        return true;
    }
}

