/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives.compression.zlib;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.zip.DataFormatException;
import net.md_5.bungee.jni.zlib.NativeCompressImpl;
import net.shieldcommunity.nullcordx.natives.compression.Compressor;

public class ZlibCompressor
implements Compressor {
    private final NativeCompressImpl nativeCompress = new NativeCompressImpl();
    private final long ctx;
    private boolean closed = false;

    public ZlibCompressor(int level) {
        this.free();
        this.ctx = this.nativeCompress.init(true, level);
    }

    @Override
    public void deflate(ByteBuf source, ByteBuf destination) throws DataFormatException {
        Preconditions.checkState(!this.closed, "Compressor already closed");
        source.memoryAddress();
        destination.memoryAddress();
        Preconditions.checkState(this.ctx != 0L, "Invalid pointer to compressor!");
        while (!this.nativeCompress.finished) {
            destination.ensureWritable(8192);
            int processed = this.nativeCompress.process(this.ctx, source.memoryAddress() + (long)source.readerIndex(), source.readableBytes(), destination.memoryAddress() + (long)destination.writerIndex(), destination.writableBytes(), true);
            source.readerIndex(source.readerIndex() + this.nativeCompress.consumed);
            destination.writerIndex(destination.writerIndex() + processed);
        }
        this.nativeCompress.reset(this.ctx, true);
        this.nativeCompress.consumed = 0;
        this.nativeCompress.finished = false;
    }

    private void free() {
        if (this.ctx != 0L) {
            this.nativeCompress.end(this.ctx, true);
        }
        this.nativeCompress.consumed = 0;
        this.nativeCompress.finished = false;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.free();
        }
        this.closed = true;
    }

    @Override
    public boolean isNeedDirectBuffer() {
        return true;
    }
}

