/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.protocol.ProtocolBlockType;
import se.llbit.nbt.CompoundTag;
import se.llbit.nbt.IntTag;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.Tag;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ProtocolItemType {
    AIR,
    FILLED_MAP{

        @Override
        public Tag getNbtTag(int protocol, int data) {
            CompoundTag nbt = new CompoundTag();
            nbt.add("map", new IntTag(data));
            if (protocol >= 764) {
                return nbt;
            }
            return new NamedTag("", nbt);
        }
    };

    private Map<Integer, Integer> mappings;

    public int getIdByProtocol(int version) {
        Integer id = this.mappings.get(version);
        if (id == null) {
            throw new IllegalStateException("Mappings with version " + version + " for type " + this.name() + " does not exists!");
        }
        return id;
    }

    public Tag getNbtTag(int protocol, int data) {
        return null;
    }

    static {
        try (JsonReader reader = new Gson().newJsonReader(new InputStreamReader(ProtocolBlockType.class.getResourceAsStream("/items.json"), StandardCharsets.UTF_8));){
            JsonElement element = JsonParser.parseReader(reader);
            JsonObject jsonObject = element.getAsJsonObject();
            for (ProtocolItemType type : ProtocolItemType.values()) {
                JsonElement e = jsonObject.get(type.name());
                if (e == null) {
                    throw new IllegalStateException("Failed to find " + type.name() + " in items mappings!");
                }
                Int2ObjectOpenHashMap<Integer> idByProtocol = new Int2ObjectOpenHashMap<Integer>();
                JsonObject elementObject = e.getAsJsonObject();
                Set<String> keys = elementObject.keySet();
                for (String key : keys) {
                    idByProtocol.put(Integer.valueOf(Integer.parseInt(key)), Integer.valueOf(elementObject.get(key).getAsInt()));
                }
                Iterator<Object> iterator = ProtocolConstants.SUPPORTED_VERSION_IDS.iterator();
                while (iterator.hasNext()) {
                    int protocol = (Integer)iterator.next();
                    Integer id = (Integer)idByProtocol.get((Object)protocol);
                    if (id == null) {
                        throw new IllegalStateException("Failed to find protocol version " + protocol + " for " + type.name() + " in items mappings!");
                    }
                    idByProtocol.put(Integer.valueOf(protocol), id);
                }
                type.mappings = idByProtocol;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

