/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EntityInteractPacket
extends DefinedPacket {
    private int entityId;
    private int type;
    private float x;
    private float y;
    private float z;
    private int hand;
    private boolean sneaking;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        this.entityId = EntityInteractPacket.readVarInt(buf);
        this.type = EntityInteractPacket.readVarInt(buf);
        if (this.type == 2) {
            this.x = buf.readFloat();
            this.y = buf.readFloat();
            this.z = buf.readFloat();
        }
        if (version > 47 && (this.type == 2 || this.type == 0)) {
            this.hand = EntityInteractPacket.readVarInt(buf);
        }
        if (version > 578) {
            this.sneaking = buf.readBoolean();
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getType() {
        return this.type;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public int getHand() {
        return this.hand;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setHand(int hand) {
        this.hand = hand;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    @Override
    public String toString() {
        return "EntityInteractPacket(entityId=" + this.getEntityId() + ", type=" + this.getType() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", hand=" + this.getHand() + ", sneaking=" + this.isSneaking() + ")";
    }

    public EntityInteractPacket() {
    }

    public EntityInteractPacket(int entityId, int type, float x, float y, float z, int hand, boolean sneaking) {
        this.entityId = entityId;
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.hand = hand;
        this.sneaking = sneaking;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityInteractPacket)) {
            return false;
        }
        EntityInteractPacket other = (EntityInteractPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Float.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (this.getHand() != other.getHand()) {
            return false;
        }
        return this.isSneaking() == other.isSneaking();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityInteractPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getType();
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getZ());
        result = result * 59 + this.getHand();
        result = result * 59 + (this.isSneaking() ? 79 : 97);
        return result;
    }
}

