/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.ProtocolDimensionType;
import net.shieldcommunity.nullcordx.protocol.ProtocolGameEventChangeGameMode;

public class LoginPacket
extends DefinedPacket {
    private final int entityId;
    private boolean hardcore = false;
    private ProtocolGameEventChangeGameMode gameMode = ProtocolGameEventChangeGameMode.SURVIVAL;
    private int previousGameMode = 0;
    private List<String> worldNames = Collections.singletonList("minecraft:overworld");
    private String worldName = "minecraft:overworld";
    private int dimensionId = 0;
    private long seed = 1L;
    private int difficulty = 0;
    private int maxPlayers = 1;
    private String levelType = "flat";
    private int viewDistance = 0;
    private boolean reducedDebugInfo = false;
    private boolean normalRespawn = true;
    private boolean limitedCrafting = false;
    private boolean debug = false;
    private boolean flat = true;
    private int portalCooldown = 0;
    private boolean secureProfile = false;
    private ProtocolDimensionType protocolDimensionType;

    public LoginPacket() {
        this(0, ProtocolDimensionType.OVERWORLD, false, ProtocolGameEventChangeGameMode.SURVIVAL, 1L);
    }

    public LoginPacket(int entityId, ProtocolDimensionType protocolDimensionType, boolean hardcore, ProtocolGameEventChangeGameMode gameMode, long seed) {
        this.entityId = entityId;
        this.dimensionId = protocolDimensionType.getDimensionId();
        this.worldName = protocolDimensionType.getKey();
        this.worldNames = Collections.singletonList(protocolDimensionType.getKey());
        this.protocolDimensionType = protocolDimensionType;
        this.hardcore = hardcore;
        this.gameMode = gameMode;
        this.seed = seed;
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        buf.writeInt(this.entityId);
        if (version >= 751) {
            buf.writeBoolean(this.hardcore);
        }
        if (version < 764) {
            buf.writeByte((int)this.gameMode.getProtocolGameEventValueByVersion(version));
        }
        if (version >= 735) {
            if (version < 764) {
                buf.writeByte(this.previousGameMode);
            }
            LoginPacket.writeVarInt(this.worldNames.size(), buf);
            for (String world : this.worldNames) {
                LoginPacket.writeString(world, buf);
            }
            if (version < 764) {
                LoginPacket.writeTag(this.protocolDimensionType.getFullCodec(version), buf, version);
            }
        }
        if (version >= 735) {
            if (version >= 751 && version < 759) {
                LoginPacket.writeTag(this.protocolDimensionType.getAttributes(version), buf, version);
            } else if (version < 764) {
                LoginPacket.writeString(this.worldName, buf);
            }
            if (version < 764) {
                LoginPacket.writeString(this.worldName, buf);
            }
        } else if (version > 107) {
            buf.writeInt(this.dimensionId);
        } else {
            buf.writeByte(this.dimensionId);
        }
        if (version >= 573 && version < 764) {
            buf.writeLong(this.seed);
        }
        if (version < 477) {
            buf.writeByte(this.difficulty);
        }
        if (version >= 751) {
            LoginPacket.writeVarInt(this.maxPlayers, buf);
        } else {
            buf.writeByte(this.maxPlayers);
        }
        if (version < 735) {
            LoginPacket.writeString(this.levelType, buf);
        }
        if (version >= 477) {
            LoginPacket.writeVarInt(this.viewDistance, buf);
        }
        if (version >= 757) {
            LoginPacket.writeVarInt(this.viewDistance, buf);
        }
        if (version >= 29) {
            buf.writeBoolean(this.reducedDebugInfo);
        }
        if (version >= 573) {
            buf.writeBoolean(this.normalRespawn);
        }
        if (version >= 764) {
            buf.writeBoolean(this.limitedCrafting);
            LoginPacket.writeString(this.worldName, buf);
            LoginPacket.writeString(this.worldName, buf);
            buf.writeLong(this.seed);
            buf.writeByte((int)this.gameMode.getProtocolGameEventValueByVersion(version));
            buf.writeByte(this.previousGameMode);
        }
        if (version >= 735) {
            buf.writeBoolean(this.debug);
            buf.writeBoolean(this.flat);
        }
        if (version >= 759) {
            buf.writeBoolean(false);
        }
        if (version >= 763) {
            LoginPacket.writeVarInt(this.portalCooldown, buf);
        }
        if (version >= 0x400000BB) {
            buf.writeBoolean(this.secureProfile);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public ProtocolGameEventChangeGameMode getGameMode() {
        return this.gameMode;
    }

    public int getPreviousGameMode() {
        return this.previousGameMode;
    }

    public List<String> getWorldNames() {
        return this.worldNames;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public boolean isNormalRespawn() {
        return this.normalRespawn;
    }

    public boolean isLimitedCrafting() {
        return this.limitedCrafting;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean isSecureProfile() {
        return this.secureProfile;
    }

    public ProtocolDimensionType getProtocolDimensionType() {
        return this.protocolDimensionType;
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = hardcore;
    }

    public void setGameMode(ProtocolGameEventChangeGameMode gameMode) {
        this.gameMode = gameMode;
    }

    public void setPreviousGameMode(int previousGameMode) {
        this.previousGameMode = previousGameMode;
    }

    public void setWorldNames(List<String> worldNames) {
        this.worldNames = worldNames;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public void setDimensionId(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }

    public void setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    public void setNormalRespawn(boolean normalRespawn) {
        this.normalRespawn = normalRespawn;
    }

    public void setLimitedCrafting(boolean limitedCrafting) {
        this.limitedCrafting = limitedCrafting;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    public void setSecureProfile(boolean secureProfile) {
        this.secureProfile = secureProfile;
    }

    public void setProtocolDimensionType(ProtocolDimensionType protocolDimensionType) {
        this.protocolDimensionType = protocolDimensionType;
    }

    @Override
    public String toString() {
        return "LoginPacket(entityId=" + this.getEntityId() + ", hardcore=" + this.isHardcore() + ", gameMode=" + this.getGameMode() + ", previousGameMode=" + this.getPreviousGameMode() + ", worldNames=" + this.getWorldNames() + ", worldName=" + this.getWorldName() + ", dimensionId=" + this.getDimensionId() + ", seed=" + this.getSeed() + ", difficulty=" + this.getDifficulty() + ", maxPlayers=" + this.getMaxPlayers() + ", levelType=" + this.getLevelType() + ", viewDistance=" + this.getViewDistance() + ", reducedDebugInfo=" + this.isReducedDebugInfo() + ", normalRespawn=" + this.isNormalRespawn() + ", limitedCrafting=" + this.isLimitedCrafting() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ", portalCooldown=" + this.getPortalCooldown() + ", secureProfile=" + this.isSecureProfile() + ", protocolDimensionType=" + this.getProtocolDimensionType() + ")";
    }

    public LoginPacket(int entityId) {
        this.entityId = entityId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginPacket)) {
            return false;
        }
        LoginPacket other = (LoginPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.isHardcore() != other.isHardcore()) {
            return false;
        }
        if (this.getPreviousGameMode() != other.getPreviousGameMode()) {
            return false;
        }
        if (this.getDimensionId() != other.getDimensionId()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getMaxPlayers() != other.getMaxPlayers()) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.isReducedDebugInfo() != other.isReducedDebugInfo()) {
            return false;
        }
        if (this.isNormalRespawn() != other.isNormalRespawn()) {
            return false;
        }
        if (this.isLimitedCrafting() != other.isLimitedCrafting()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        if (this.getPortalCooldown() != other.getPortalCooldown()) {
            return false;
        }
        if (this.isSecureProfile() != other.isSecureProfile()) {
            return false;
        }
        ProtocolGameEventChangeGameMode this$gameMode = this.getGameMode();
        ProtocolGameEventChangeGameMode other$gameMode = other.getGameMode();
        if (this$gameMode == null ? other$gameMode != null : !this$gameMode.equals(other$gameMode)) {
            return false;
        }
        List<String> this$worldNames = this.getWorldNames();
        List<String> other$worldNames = other.getWorldNames();
        if (this$worldNames == null ? other$worldNames != null : !((Object)this$worldNames).equals(other$worldNames)) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        String this$levelType = this.getLevelType();
        String other$levelType = other.getLevelType();
        if (this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType)) {
            return false;
        }
        ProtocolDimensionType this$protocolDimensionType = this.getProtocolDimensionType();
        ProtocolDimensionType other$protocolDimensionType = other.getProtocolDimensionType();
        return !(this$protocolDimensionType == null ? other$protocolDimensionType != null : !((Object)((Object)this$protocolDimensionType)).equals((Object)other$protocolDimensionType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + (this.isHardcore() ? 79 : 97);
        result = result * 59 + this.getPreviousGameMode();
        result = result * 59 + this.getDimensionId();
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getMaxPlayers();
        result = result * 59 + this.getViewDistance();
        result = result * 59 + (this.isReducedDebugInfo() ? 79 : 97);
        result = result * 59 + (this.isNormalRespawn() ? 79 : 97);
        result = result * 59 + (this.isLimitedCrafting() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        result = result * 59 + this.getPortalCooldown();
        result = result * 59 + (this.isSecureProfile() ? 79 : 97);
        ProtocolGameEventChangeGameMode $gameMode = this.getGameMode();
        result = result * 59 + ($gameMode == null ? 43 : $gameMode.hashCode());
        List<String> $worldNames = this.getWorldNames();
        result = result * 59 + ($worldNames == null ? 43 : ((Object)$worldNames).hashCode());
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        String $levelType = this.getLevelType();
        result = result * 59 + ($levelType == null ? 43 : $levelType.hashCode());
        ProtocolDimensionType $protocolDimensionType = this.getProtocolDimensionType();
        result = result * 59 + ($protocolDimensionType == null ? 43 : ((Object)((Object)$protocolDimensionType)).hashCode());
        return result;
    }
}

