/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.ProtocolEffectType;

public class RemoveEntityEffectPacket
extends DefinedPacket {
    private int entityId;
    private ProtocolEffectType effectType;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        RemoveEntityEffectPacket.writeVarInt(this.entityId, buf);
        if (protocolVersion > 756) {
            RemoveEntityEffectPacket.writeVarInt(this.effectType.getEffectIdByProtocol(protocolVersion), buf);
        } else {
            buf.writeByte(this.effectType.getEffectIdByProtocol(protocolVersion));
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ProtocolEffectType getEffectType() {
        return this.effectType;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setEffectType(ProtocolEffectType effectType) {
        this.effectType = effectType;
    }

    @Override
    public String toString() {
        return "RemoveEntityEffectPacket(entityId=" + this.getEntityId() + ", effectType=" + this.getEffectType() + ")";
    }

    public RemoveEntityEffectPacket() {
    }

    public RemoveEntityEffectPacket(int entityId, ProtocolEffectType effectType) {
        this.entityId = entityId;
        this.effectType = effectType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveEntityEffectPacket)) {
            return false;
        }
        RemoveEntityEffectPacket other = (RemoveEntityEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        ProtocolEffectType this$effectType = this.getEffectType();
        ProtocolEffectType other$effectType = other.getEffectType();
        return !(this$effectType == null ? other$effectType != null : !((Object)((Object)this$effectType)).equals((Object)other$effectType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoveEntityEffectPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        ProtocolEffectType $effectType = this.getEffectType();
        result = result * 59 + ($effectType == null ? 43 : ((Object)((Object)$effectType)).hashCode());
        return result;
    }
}

