/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.EntityMetadata;
import net.shieldcommunity.nullcordx.protocol.EntityMetadataFieldType;
import net.shieldcommunity.nullcordx.protocol.EntityMetadataIndexType;

public class SetEntityMetadataPacket
extends DefinedPacket {
    private int entityId;
    private List<EntityMetadata> entityMetadataList;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        SetEntityMetadataPacket.writeVarInt(this.entityId, buf);
        if (version > 47) {
            for (EntityMetadata entityMetadata : this.entityMetadataList) {
                EntityMetadataIndexType indexType = entityMetadata.getIndexType();
                buf.writeByte(indexType.getIndexByProtocol(version));
                EntityMetadataFieldType fieldType = entityMetadata.getFieldType();
                int fieldTypeId = fieldType.getTypeByProtocol(version);
                if (version > 340) {
                    SetEntityMetadataPacket.writeVarInt(fieldTypeId, buf);
                } else {
                    buf.writeByte(fieldTypeId);
                }
                entityMetadata.getMetadata().writeMetadata(buf, version);
            }
            buf.writeByte(255);
            return;
        }
        for (EntityMetadata entityMetadata : this.entityMetadataList) {
            EntityMetadataIndexType indexType = entityMetadata.getIndexType();
            int indexTypeId = indexType.getIndexByProtocol(version);
            EntityMetadataFieldType fieldType = entityMetadata.getFieldType();
            int fieldTypeId = fieldType.getTypeByProtocol(version);
            buf.writeByte(SetEntityMetadataPacket.createIndexAndTypeByte(indexTypeId, fieldTypeId));
            entityMetadata.getMetadata().writeMetadata(buf, version);
        }
        buf.writeByte(127);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    private static int createIndexAndTypeByte(int index, int type) {
        return (type << 5 | index & 0x1F) & 0xFF;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public List<EntityMetadata> getEntityMetadataList() {
        return this.entityMetadataList;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setEntityMetadataList(List<EntityMetadata> entityMetadataList) {
        this.entityMetadataList = entityMetadataList;
    }

    @Override
    public String toString() {
        return "SetEntityMetadataPacket(entityId=" + this.getEntityId() + ", entityMetadataList=" + this.getEntityMetadataList() + ")";
    }

    public SetEntityMetadataPacket() {
    }

    public SetEntityMetadataPacket(int entityId, List<EntityMetadata> entityMetadataList) {
        this.entityId = entityId;
        this.entityMetadataList = entityMetadataList;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetEntityMetadataPacket)) {
            return false;
        }
        SetEntityMetadataPacket other = (SetEntityMetadataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        List<EntityMetadata> this$entityMetadataList = this.getEntityMetadataList();
        List<EntityMetadata> other$entityMetadataList = other.getEntityMetadataList();
        return !(this$entityMetadataList == null ? other$entityMetadataList != null : !((Object)this$entityMetadataList).equals(other$entityMetadataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetEntityMetadataPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        List<EntityMetadata> $entityMetadataList = this.getEntityMetadataList();
        result = result * 59 + ($entityMetadataList == null ? 43 : ((Object)$entityMetadataList).hashCode());
        return result;
    }
}

