/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.utils.CustomFJPThreadFactory;

public final class TasksUtils {
    public static <T extends Future<?>> int findWaitTasksCount(List<T> tasks) {
        int count = 0;
        for (Future task : tasks) {
            if (task.isDone()) continue;
            ++count;
        }
        return count;
    }

    public static <T extends RecursiveTask<V>, V> List<V> executeSimpleTasks(int threads, String threadName, Logger logger, List<T> tasks, MessageSupplier message) {
        if (threads <= 0) {
            threads = 1;
        }
        ForkJoinPool executor = new ForkJoinPool(threads, new CustomFJPThreadFactory(threadName, 1), null, false);
        return TasksUtils.executeSimpleTasks(executor, logger, tasks, message);
    }

    public static <T extends RecursiveTask<V>, V> List<V> executeSimpleTasks(ForkJoinPool executor, Logger logger, List<T> tasks, MessageSupplier message) {
        for (RecursiveTask task : tasks) {
            executor.execute(task);
        }
        long time = System.currentTimeMillis();
        long oldDataCount = 0L;
        while (executor.getActiveThreadCount() != 0) {
            if (System.currentTimeMillis() - time >= 1000L) {
                time = System.currentTimeMillis();
                long dataToGenerate = executor.getQueuedTaskCount();
                long perSec = oldDataCount - dataToGenerate;
                oldDataCount = dataToGenerate;
                if (!CaptchaSettings.IMP.CAPTCHA.AUTO_REGENERATE_HIDE_MESSAGES) {
                    message.onMessage(logger, dataToGenerate, perSec);
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Failed to generate data", e);
                return null;
            }
        }
        try {
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Failed to shutdown executor", e);
        }
        ArrayList result = new ArrayList();
        for (RecursiveTask task : tasks) {
            try {
                Object data = task.get();
                if (data == null) continue;
                result.add(data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private TasksUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface MessageSupplier {
        public void onMessage(Logger var1, long var2, long var4);
    }
}

