/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import java.io.IOException;
import java.util.Map;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.core.JsonGenerationException;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.core.JsonGenerator;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.SerializerProvider;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.TriConsumer;

public class ContextDataSerializer
extends StdSerializer<ReadOnlyStringMap> {
    private static final long serialVersionUID = 1L;
    private static final TriConsumer<String, Object, JsonGenerator> WRITE_STRING_FIELD_INTO = (key, value, jsonGenerator) -> {
        try {
            if (value == null) {
                jsonGenerator.writeNullField((String)key);
            } else {
                jsonGenerator.writeStringField((String)key, String.valueOf(value));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Problem with key " + key, ex);
        }
    };

    protected ContextDataSerializer() {
        super(Map.class, false);
    }

    @Override
    public void serialize(ReadOnlyStringMap contextData, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        contextData.forEach(WRITE_STRING_FIELD_INTO, jgen);
        jgen.writeEndObject();
    }
}

