/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import java.io.IOException;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.core.JsonParser;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.core.JsonToken;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.DeserializationContext;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.JsonMappingException;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.util.ClassUtil;
import org.apache.logging.log4j.core.util.Integers;

public final class Log4jStackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;

    public Log4jStackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t2 = jp.getCurrentToken();
        if (t2 == JsonToken.START_OBJECT) {
            String className = null;
            String methodName = null;
            String fileName = null;
            int lineNumber = -1;
            block15: while ((t2 = jp.nextValue()) != JsonToken.END_OBJECT) {
                String propName;
                switch (propName = jp.getCurrentName()) {
                    case "class": {
                        className = jp.getText();
                        continue block15;
                    }
                    case "file": {
                        fileName = jp.getText();
                        continue block15;
                    }
                    case "line": {
                        if (t2.isNumeric()) {
                            lineNumber = jp.getIntValue();
                            continue block15;
                        }
                        try {
                            lineNumber = Integers.parseInt(jp.getText());
                            continue block15;
                        }
                        catch (NumberFormatException e) {
                            throw JsonMappingException.from(jp, "Non-numeric token (" + (Object)((Object)t2) + ") for property 'line'", (Throwable)e);
                        }
                    }
                    case "method": {
                        methodName = jp.getText();
                        continue block15;
                    }
                }
                this.handleUnknownProperty(jp, ctxt, this._valueClass, propName);
            }
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        throw JsonMappingException.from(jp, String.format("Cannot deserialize instance of %s out of %s token", new Object[]{ClassUtil.nameOf(this._valueClass), t2}));
    }
}

