/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.util.Objects;
import net.shieldcommunity.nullcordx.libs.javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.http.HttpTransporter;

@Named(value="http")
public final class HttpTransporterFactory
implements TransporterFactory {
    private float priority = 5.0f;

    @Override
    public float getPriority() {
        return this.priority;
    }

    public HttpTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull("session", "session cannot be null");
        Objects.requireNonNull("repository", "repository cannot be null");
        return new HttpTransporter(repository, session);
    }
}

