/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import net.shieldcommunity.nullcordx.libs.google.inject.Binding;
import net.shieldcommunity.nullcordx.libs.google.inject.Key;
import net.shieldcommunity.nullcordx.libs.google.inject.TypeLiteral;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.DefaultBindingTargetVisitor;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.InjectionPoint;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.LinkedKeyBinding;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.UntargettedBinding;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.TypeArguments;

final class DependencyVerifier
extends DefaultBindingTargetVisitor<Object, Boolean> {
    DependencyVerifier() {
    }

    @Override
    public Boolean visit(UntargettedBinding<?> binding) {
        return DependencyVerifier.verifyImplementation(binding.getKey().getTypeLiteral());
    }

    @Override
    public Boolean visit(LinkedKeyBinding<?> binding) {
        Key<?> linkedKey = binding.getLinkedKey();
        if (linkedKey.getAnnotationType() == null) {
            return DependencyVerifier.verifyImplementation(linkedKey.getTypeLiteral());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitOther(Binding<?> binding) {
        return Boolean.TRUE;
    }

    private static Boolean verifyImplementation(TypeLiteral<?> type) {
        if (TypeArguments.isConcrete(type) && !type.toString().startsWith("java")) {
            try {
                InjectionPoint.forInstanceMethodsAndFields(type);
                InjectionPoint.forConstructorOf(type);
            }
            catch (RuntimeException e) {
                Logs.trace("Potential problem: {}", type, e);
                return Boolean.FALSE;
            }
            catch (LinkageError e) {
                Logs.trace("Potential problem: {}", type, e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

