/*
 * Decompiled with CFR 0.152.
 */
package lumien.custombackgrounds;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.gui.Gui;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="custombackgrounds", name="Custom Backgrounds", version="1.0", clientSideOnly=true, acceptedMinecraftVersions="[1.12]")
public class CustomBackgrounds {
    ArrayList<ResourceLocation> backgroundLocations;
    boolean obfuscated;
    Logger logger;
    Field optionsBackground;
    int counter = 0;
    ResourceLocation fixedBackground;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.optionsBackground = null;
        this.backgroundLocations = new ArrayList();
        this.loadConfig(event);
        if (this.fixedBackground == null) {
            this.addBlock("stone_andesite");
            this.addBlock("end_stone");
            this.addBlock("stone_diorite");
            this.addBlock("stone_granite");
            this.addBlock("clay");
            this.addBlock("hardened_clay_stained_pink");
            this.addBlock("hardened_clay_stained_cyan");
            this.addBlock("planks_spruce");
            this.addBlock("planks_acacia");
            this.addBlock("planks_birch");
            this.addBlock("planks_jungle");
            this.addBlock("quartz_block_bottom");
            this.addBlock("quartz_block_chiseled");
            this.addBlock("quartz_block_lines");
            this.addBlock("slime");
            this.addBlock("soul_sand");
            this.addBlock("prismarine_bricks");
            this.addBlock("prismarine_dark");
            this.addBlock("netherrack");
            this.addBlock("wool_colored_cyan");
            this.addBlock("sand");
            this.addBlock("purpur_block");
            this.addBlock("purpur_pillar");
            this.addBlock("purpur_pillar_top");
            this.addBlock("concrete_blue");
            this.addBlock("concrete_powder_silver");
        }
    }

    private void loadConfig(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        String fixedString = config.getString("Fixed-Background", "Settings", "", "If you set this to something this texture will be used as the background. (For more information on how to use this see the curse mod post)");
        this.fixedBackground = null;
        if (!fixedString.equals("")) {
            this.fixedBackground = new ResourceLocation(fixedString);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private void addBlock(String block) {
        this.backgroundLocations.add(new ResourceLocation("textures/blocks/" + block + ".png"));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.obfuscated = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") == false;
        try {
            this.optionsBackground = Gui.class.getField(this.obfuscated ? "field_110325_k" : "OPTIONS_BACKGROUND");
        }
        catch (Exception e) {
            this.logger.log(Level.ERROR, "Couldn't reflect on optionsBackground, CustomBackgrounds will not work");
            e.printStackTrace();
        }
        if (this.fixedBackground != null) {
            this.setBackground(this.fixedBackground);
        } else {
            this.setBackground(this.backgroundLocations.get(new Random().nextInt(this.backgroundLocations.size())));
        }
    }

    private void setBackground(ResourceLocation rl) {
        if (this.optionsBackground != null) {
            try {
                this.setFinalStatic(this.optionsBackground, rl);
            }
            catch (Exception e) {
                this.logger.log(Level.ERROR, "Couldn't reflect on optionsBackground, CustomBackgrounds will not work");
                e.printStackTrace();
            }
        }
    }

    private void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }
}

