/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.container;

import com.inventorypets.container.CanTagNBT;
import com.inventorypets.container.NBTHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class InventoryChestPet
implements IInventory,
CanTagNBT {
    public ItemStack parentItemStack;
    protected NonNullList<ItemStack> inventory;
    public ItemStack[] itemSlots = new ItemStack[64];
    protected String customName;
    public NBTTagCompound tag;
    public static boolean instantAdd = false;
    private boolean added = false;
    public ItemStack item;
    boolean foid = false;
    public int stacksize;

    public InventoryChestPet(ItemStack itemStack) {
        int size = 27;
        this.parentItemStack = itemStack;
        this.inventory = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        if (!this.foid) {
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            this.tag = itemStack.func_77978_p();
            this.item = itemStack;
            this.readFromNBT(itemStack.func_77978_p());
        } else {
            this.itemSlots = new ItemStack[size];
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            this.tag = itemStack.func_77978_p();
            this.item = itemStack;
            this.stacksize = 64;
        }
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        this.parentItemStack = this.findParentItemStack(entityPlayer);
        if (this.parentItemStack != ItemStack.field_190927_a) {
            this.save();
        }
    }

    public ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (NBTHelper.hasUUID(this.parentItemStack)) {
            UUID parentItemStackUUID = new UUID(this.parentItemStack.func_77978_p().func_74763_f("UUIDMostSig"), this.parentItemStack.func_77978_p().func_74763_f("UUIDLeastSig"));
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (!NBTHelper.hasUUID(itemStack) || itemStack.func_77978_p().func_74763_f("UUIDMostSig") != parentItemStackUUID.getMostSignificantBits() || itemStack.func_77978_p().func_74763_f("UUIDLeastSig") != parentItemStackUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean matchesUUID(UUID uuid) {
        return NBTHelper.hasUUID(this.parentItemStack) && this.parentItemStack.func_77978_p().func_74763_f("UUIDLeastSig") == uuid.getLeastSignificantBits() && this.parentItemStack.func_77978_p().func_74763_f("UUIDMostSig") == uuid.getMostSignificantBits();
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.parentItemStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            UUID uuid = UUID.randomUUID();
            nbtTagCompound.func_74772_a("UUIDMostSig", uuid.getMostSignificantBits());
            nbtTagCompound.func_74772_a("UUIDLeastSig", uuid.getLeastSignificantBits());
        }
        this.writeToNBT(nbtTagCompound);
        this.parentItemStack.func_77982_d(nbtTagCompound);
    }

    public int func_70302_i_() {
        if (!this.foid) {
            return this.inventory.size();
        }
        return 65;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (!this.foid) {
            return (ItemStack)this.inventory.get(slotIndex);
        }
        return slotIndex == 64 ? ItemStack.field_190927_a : this.itemSlots[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        if (!this.foid) {
            ItemStack itemStack = this.func_70301_a(slotIndex);
            if (itemStack != ItemStack.field_190927_a) {
                if (itemStack.func_190916_E() <= decrementAmount) {
                    this.func_70299_a(slotIndex, ItemStack.field_190927_a);
                } else if ((itemStack = itemStack.func_77979_a(decrementAmount)) == ItemStack.field_190927_a) {
                    this.func_70299_a(slotIndex, ItemStack.field_190927_a);
                }
            }
            return itemStack;
        }
        if (slotIndex == 64) {
            return ItemStack.field_190927_a;
        }
        if (this.itemSlots[slotIndex] != ItemStack.field_190927_a) {
            if (this.itemSlots[slotIndex].func_190916_E() <= decrementAmount) {
                ItemStack itemstack = this.itemSlots[slotIndex];
                this.itemSlots[slotIndex] = ItemStack.field_190927_a;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.itemSlots[slotIndex].func_77979_a(decrementAmount);
            if (this.itemSlots[slotIndex] == ItemStack.field_190927_a) {
                this.itemSlots[slotIndex] = ItemStack.field_190927_a;
            }
            this.func_70296_d();
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (!this.foid) {
            if (this.inventory.get(index) != ItemStack.field_190927_a) {
                ItemStack itemStack = (ItemStack)this.inventory.get(index);
                this.inventory.set(index, (Object)ItemStack.field_190927_a);
                return itemStack;
            }
            return ItemStack.field_190927_a;
        }
        return this.func_70301_a(index);
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (!this.foid) {
            this.inventory.set(slotIndex, (Object)itemStack);
            if (itemStack != ItemStack.field_190927_a && itemStack.func_190916_E() > this.func_70297_j_()) {
                itemStack.func_190920_e(this.func_70297_j_());
            }
            this.func_70296_d();
        } else if (slotIndex != 64) {
            this.itemSlots[slotIndex] = itemStack;
            this.func_70296_d();
            if (instantAdd) {
                this.processInv();
            } else {
                this.added = true;
            }
        }
    }

    public ItemStack addItem(ItemStack stack) {
        ItemStack itemstack = stack.func_77946_l();
        for (int i = 0; i < this.itemSlots.length; ++i) {
            ItemStack itemstack1 = this.func_70301_a(i);
            if (itemstack1.func_190926_b()) {
                this.func_70299_a(i, itemstack);
                this.func_70296_d();
                return ItemStack.field_190927_a;
            }
            if (!ItemStack.func_179545_c((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            int j = Math.min(this.func_70297_j_(), itemstack1.func_77976_d());
            int k = Math.min(itemstack.func_190916_E(), j - itemstack1.func_190916_E());
            if (k <= 0) continue;
            itemstack1.func_190917_f(k);
            itemstack.func_190918_g(k);
            if (!itemstack.func_190926_b()) continue;
            this.func_70296_d();
            return ItemStack.field_190927_a;
        }
        if (itemstack.func_190916_E() != stack.func_190916_E()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void processInv() {
        if (this.itemSlots[0] != ItemStack.field_190927_a) {
            this.itemSlots[0] = ItemStack.field_190927_a;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.writeToNBT(this.tag);
        this.setNBT(this.item);
    }

    public void setNBT(ItemStack item) {
        item.func_77982_d(this.tag);
    }

    public void func_174889_b(EntityPlayer entityplayer) {
        this.readFromNBT(this.tag);
    }

    public void func_174886_c(EntityPlayer entityplayer) {
        this.writeToNBT(this.tag);
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        if (!this.foid) {
            return true;
        }
        return slotIndex <= 64;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        block4: {
            block3: {
                if (this.foid) break block3;
                if (nbtTagCompound == null || !nbtTagCompound.func_74764_b("Items")) break block4;
                if (nbtTagCompound.func_74764_b("Items")) {
                    NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
                    this.inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound tagCompound = tagList.func_150305_b(i);
                        byte slotIndex = tagCompound.func_74771_c("Slot");
                        if (slotIndex < 0 || slotIndex >= this.inventory.size()) continue;
                        this.inventory.set((int)slotIndex, (Object)new ItemStack(tagCompound));
                    }
                }
                if (!nbtTagCompound.func_74764_b("display") || !nbtTagCompound.func_74781_a("display").getClass().equals(NBTTagCompound.class) || !nbtTagCompound.func_74775_l("display").func_74764_b("Name")) break block4;
                this.customName = nbtTagCompound.func_74775_l("display").func_74779_i("Name");
                break block4;
            }
            this.itemSlots = new ItemStack[this.func_70302_i_()];
            NBTTagList inventory = nbtTagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < inventory.func_74745_c(); ++i) {
                NBTTagCompound Slots = inventory.func_150305_b(i);
                byte slot = Slots.func_74771_c("Slot");
                if (slot < 0 || slot >= this.itemSlots.length) continue;
                this.itemSlots[slot] = new ItemStack(Slots);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        if (!this.foid) {
            NBTTagList tagList = new NBTTagList();
            for (int currentIndex = 0; currentIndex < this.inventory.size(); ++currentIndex) {
                if (this.inventory.get(currentIndex) == ItemStack.field_190927_a) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)currentIndex);
                ((ItemStack)this.inventory.get(currentIndex)).func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
        } else {
            NBTTagList inventory = new NBTTagList();
            for (int slot = 0; slot < this.itemSlots.length; ++slot) {
                if (this.itemSlots[slot] == ItemStack.field_190927_a) continue;
                NBTTagCompound Slots = new NBTTagCompound();
                Slots.func_74774_a("Slot", (byte)slot);
                this.itemSlots[slot].func_77955_b(Slots);
                inventory.func_74742_a((NBTBase)Slots);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)inventory);
            this.processInv();
        }
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String getCustomName() {
        return this.customName;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.getCustomName();
        }
        return "container.chest:Chests";
    }

    @Override
    public String getTagLabel() {
        return "InventoryChestPet";
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }
}

