/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.nether;

import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.init.ModBiomes;
import biomesoplenty.common.world.generator.GeneratorHive;
import biomesoplenty.core.BiomesOPlenty;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class BOPHellBiome
extends BOPBiome {
    public IBlockState wallBlock = Blocks.field_150424_aL.func_176223_P();
    public IBlockState roofTopBlock = Blocks.field_150424_aL.func_176223_P();
    public IBlockState roofFillerBlock = Blocks.field_150424_aL.func_176223_P();

    public BOPHellBiome(String idName, BOPBiome.PropsBuilder defaultBuilder) {
        super(idName, defaultBuilder);
        this.field_76752_A = Blocks.field_150424_aL.func_176223_P();
        this.field_76753_B = Blocks.field_150424_aL.func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityGhast.class, 50, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityPigZombie.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityMagmaCube.class, 2, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEnderman.class, 1, 4, 4));
        this.addGenerator("hive", GeneratorStage.PRE, ((GeneratorHive.Builder)new GeneratorHive.Builder().amountPerChunk(0.2f)).create());
    }

    @Override
    public void configure(IConfigObj conf) {
        super.configure(conf);
        this.wallBlock = conf.getBlockState("wallBlock", this.wallBlock);
        this.roofTopBlock = conf.getBlockState("roofTopBlock", this.roofTopBlock);
        this.roofFillerBlock = conf.getBlockState("roofFillerBlock", this.roofFillerBlock);
        for (String msg : conf.flushMessages()) {
            BiomesOPlenty.logger.info(msg);
        }
        ModBiomes.writeDefaultConfigFile(ModBiomes.BOP_DEFAULTS_DIR, this.getResourceLocation().func_110623_a(), conf);
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("ruby");
            this.removeGenerator("topaz");
            this.removeGenerator("amber");
            this.removeGenerator("peridot");
            this.removeGenerator("malachite");
            this.removeGenerator("sapphire");
            this.removeGenerator("tanzanite");
            this.removeGenerator("amethyst");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.POISON_IVY)) {
            this.removeGenerator("poison_ivy");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.BERRY_BUSHES)) {
            this.removeGenerator("berry_bushes");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.NETHER_HIVES)) {
            this.removeGenerator("hive");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.THORNS)) {
            this.removeGenerator("thorns");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.QUICKSAND)) {
            this.removeGenerator("quicksand");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.HOT_SPRINGS)) {
            this.removeGenerator("hot_springs");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.LIQUID_POISON)) {
            this.removeGenerator("poison_lakes");
        }
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double stoneNoiseVal) {
        int blockSkip;
        IBlockState roof = this.roofTopBlock;
        IBlockState roofFiller = this.roofFillerBlock;
        IBlockState wall = this.wallBlock;
        IBlockState floor = this.field_76752_A;
        IBlockState floorFiller = this.field_76753_B;
        int roofDepth = 4;
        int floorDepth = 4;
        int localX = x & 0xF;
        int localZ = z & 0xF;
        boolean lastSolid = true;
        for (int localY = 127; localY >= 0; localY -= blockSkip) {
            IBlockState state;
            blockSkip = 1;
            IBlockState currentState = primer.func_177856_a(localZ, localY, localX);
            if (currentState.func_177230_c() == Blocks.field_150424_aL) {
                primer.func_177855_a(localZ, localY, localX, wall);
                if (!lastSolid) {
                    primer.func_177855_a(localZ, localY, localX, floor);
                    for (int floorOffset = 1; floorOffset <= floorDepth - 1 && localY - floorOffset >= 0; ++floorOffset) {
                        state = primer.func_177856_a(localZ, localY - floorOffset, localX);
                        blockSkip = floorOffset + 1;
                        if (state.func_177230_c() != Blocks.field_150424_aL) break;
                        primer.func_177855_a(localZ, localY - floorOffset, localX, floorFiller);
                    }
                }
                lastSolid = true;
                continue;
            }
            if (currentState.func_185904_a() != Material.field_151579_a) continue;
            if (lastSolid) {
                primer.func_177855_a(localZ, localY + 1, localX, roof);
                for (int roofOffset = 2; roofOffset <= roofDepth && localY + roofOffset <= 127 && ((state = primer.func_177856_a(localZ, localY + roofOffset, localX)).func_177230_c() == Blocks.field_150424_aL || state == wall); ++roofOffset) {
                    primer.func_177855_a(localZ, localY + roofOffset, localX, roofFiller);
                }
            }
            lastSolid = false;
        }
    }

    @Override
    public ResourceLocation getBeachLocation() {
        return null;
    }
}

