/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.nether;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.nether.BOPHellBiome;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.block.BlockBOPMushroom;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorBigMushroom;
import biomesoplenty.common.world.generator.GeneratorFlora;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeFungiForest
extends BOPHellBiome {
    public IBlockState usualTopBlock;
    public IBlockState alternateTopBlock;

    public BiomeFungiForest() {
        super("fungi_forest", new BOPBiome.PropsBuilder("Fungi Forest").withGuiColour(11091006).withTemperature(Float.valueOf(2.0f)).withRainfall(Float.valueOf(0.0f)).withRainDisabled());
        this.addWeight(BOPClimates.HELL, 5);
        this.hasBiomeEssence = false;
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.MYCELIAL_NETHERRACK));
        IBlockPosQuery surfaceBlocks = BlockQuery.buildOr().states(this.field_76752_A).create();
        this.addGenerator("glowshroom", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.5f)).generationAttempts(16)).with(BlockBOPMushroom.MushroomType.GLOWSHROOM)).scatterYMethod(GeneratorUtils.ScatterYMethod.NETHER_SURFACE)).create());
        this.addGenerator("flat_mushroom", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).generationAttempts(16)).with(BlockBOPMushroom.MushroomType.FLAT_MUSHROOM)).scatterYMethod(GeneratorUtils.ScatterYMethod.NETHER_SURFACE)).create());
        this.addGenerator("toadstools", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).generationAttempts(16)).with(BlockBOPMushroom.MushroomType.TOADSTOOL)).scatterYMethod(GeneratorUtils.ScatterYMethod.NETHER_SURFACE)).create());
        this.addGenerator("red_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(5.0f)).generationAttempts(16)).with(Blocks.field_150337_Q.func_176223_P())).scatterYMethod(GeneratorUtils.ScatterYMethod.NETHER_SURFACE)).create());
        this.addGenerator("brown_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(2.0f)).generationAttempts(16)).with(Blocks.field_150338_P.func_176223_P())).scatterYMethod(GeneratorUtils.ScatterYMethod.NETHER_SURFACE)).create());
        this.addGenerator("big_brown_mushroom", GeneratorStage.BIG_SHROOM, ((GeneratorBigMushroom.Builder)new GeneratorBigMushroom.Builder().amountPerChunk(2.0f)).mushroomType(GeneratorBigMushroom.BigMushroomType.BROWN).scatterYMethod(GeneratorUtils.ScatterYMethod.NETHER_SURFACE).placeOn(surfaceBlocks).create());
        this.addGenerator("big_red_mushroom", GeneratorStage.BIG_SHROOM, ((GeneratorBigMushroom.Builder)new GeneratorBigMushroom.Builder().amountPerChunk(30.0f)).mushroomType(GeneratorBigMushroom.BigMushroomType.RED).scatterYMethod(GeneratorUtils.ScatterYMethod.NETHER_SURFACE).minHeight(5).maxHeight(10).placeOn(surfaceBlocks).create());
    }

    @Override
    public void configure(IConfigObj conf) {
        super.configure(conf);
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = conf.getBlockState("alternateTopBlock", this.alternateTopBlock);
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        this.field_76752_A = noise + rand.nextDouble() * 1.0 > 1.8 ? this.alternateTopBlock : this.usualTopBlock;
        super.func_180622_a(world, rand, primer, x, z, noise);
    }
}

