/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.world.generator.GeneratorColumns;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorPalmTree;
import biomesoplenty.common.world.generator.tree.GeneratorTwigletTree;
import java.util.Random;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeGenOasis
extends BOPOverworldBiome {
    public BiomeGenOasis() {
        super("oasis", new BOPBiome.PropsBuilder("Oasis").withGuiColour(7712283).withTemperature(Float.valueOf(2.0f)).withRainfall(Float.valueOf(0.5f)).withRainDisabled());
        this.terrainSettings.avgHeight(62.0).heightVariation(5.0, 7.0);
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        this.hasBiomeEssence = false;
        this.field_76752_A = Blocks.field_150354_m.func_176223_P();
        this.field_76753_B = Blocks.field_150354_m.func_176223_P();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        this.clearWeights();
        GeneratorWeighted treeGenerator = new GeneratorWeighted(4.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("palm", 3, ((GeneratorPalmTree.Builder)((GeneratorPalmTree.Builder)((GeneratorPalmTree.Builder)new GeneratorPalmTree.Builder().placeOn(BlockQueries.litSand)).log(BOPWoods.PALM)).leaves(BlockBOPLeaves.paging.getVariantState(BOPTrees.PALM).func_177226_a((IProperty)BlockOldLeaf.field_176237_a, (Comparable)Boolean.valueOf(false)))).create());
        treeGenerator.add("jungle_twiglet", 2, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().placeOn(BlockQueries.litSand)).minHeight(2)).maxHeight(2)).log(BlockPlanks.EnumType.JUNGLE)).leaves(BlockPlanks.EnumType.JUNGLE)).trunkFruit(Blocks.field_150375_by.func_176223_P())).create());
        this.addGenerator("dunegrass", GeneratorStage.GRASS, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().amountPerChunk(10.0f)).with(BOPPlants.DUNEGRASS)).placeOn(BlockQueries.litDry)).generationAttempts(8)).create());
        this.addGenerator("desert_sprouts", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(5.0f)).with(BOPPlants.DESERTSPROUTS)).generationAttempts(8)).create());
        this.addGenerator("desertgrass", GeneratorStage.GRASS, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().amountPerChunk(1.0f)).with(BOPPlants.DESERTGRASS)).generationAttempts(8)).create());
        this.addGenerator("bromeliad", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).with(BOPFlowers.BROMELIAD)).generationAttempts(8)).create());
        this.addGenerator("tiny_cacti", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).with(BOPPlants.TINYCACTUS)).generationAttempts(8)).create());
        this.addGenerator("sugar_cane", GeneratorStage.FLOWERS, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(2.0f)).generationAttempts(24).placeOn(BlockQueries.litDryWaterside)).with(Blocks.field_150436_aH.func_176223_P())).minHeight(1).maxHeight(3).create());
        this.addGenerator("ruby", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.RUBY)).create());
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && rand.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(worldIn, rand, pos);
        }
    }
}

