/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPHalfWoodSlab;
import biomesoplenty.common.block.IBOPBlock;
import biomesoplenty.common.util.block.BlockStateUtils;
import biomesoplenty.common.util.block.VariantPagingHelper;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPDoubleWoodSlab
extends BlockSlab
implements IBOPBlock {
    public static VariantPagingHelper<BlockBOPDoubleWoodSlab, BOPWoods> paging = new VariantPagingHelper(8, BOPWoods.class, BOPWoods.withPlanks);
    private static IProperty currentVariantProperty;
    public IProperty variantProperty;

    public static void createAllPages() {
        int numPages = paging.getNumPages();
        for (int i = 0; i < numPages; ++i) {
            currentVariantProperty = paging.getVariantProperty(i);
            paging.addBlock(i, new BlockBOPDoubleWoodSlab());
        }
    }

    protected BlockStateContainer func_180661_e() {
        this.variantProperty = currentVariantProperty;
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, this.variantProperty});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return null;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{this.variantProperty};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return new IProperty[]{field_176554_a};
    }

    @Override
    public String getStateName(IBlockState state) {
        return "double_" + ((BOPWoods)((Object)state.func_177229_b(this.variantProperty))).func_176610_l() + "_wood_slab";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return null;
    }

    private BlockBOPDoubleWoodSlab() {
        super(Material.field_151575_d);
        this.field_149783_u = true;
        this.func_149711_c(2.0f).func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public String func_150002_b(int meta) {
        return this.getStateName(this.func_176203_a(meta));
    }

    public IProperty func_176551_l() {
        return this.variantProperty;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return paging.getVariant(this, stack.func_77960_j() & 7);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.variantProperty, (Comparable)((Object)paging.getVariant(this, meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        BOPWoods wood = (BOPWoods)((Object)state.func_177229_b(this.variantProperty));
        return paging.getIndex(wood);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        BOPWoods wood = (BOPWoods)((Object)state.func_177229_b(this.variantProperty));
        IBlockState halfState = BlockBOPHalfWoodSlab.paging.getVariantState(wood);
        ret.add(new ItemStack(halfState.func_177230_c(), 2, halfState.func_177230_c().func_176201_c(halfState)));
        return ret;
    }

    public boolean func_176552_j() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        ImmutableSet<IBlockState> presets = BlockStateUtils.getBlockPresets((Block)this);
        for (IBlockState state : presets) {
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(state)));
        }
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPWoods wood = (BOPWoods)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (wood) {
            case HELLBARK: {
                return 0;
            }
        }
        return Blocks.field_150373_bw.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPWoods wood = (BOPWoods)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (wood) {
            case HELLBARK: {
                return 0;
            }
        }
        return Blocks.field_150373_bw.getFireSpreadSpeed(world, pos, face);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.SOLID;
    }
}

