/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.block.ISustainsPlantType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class BlockQuery {
    public static IBlockPosQuery anything = new IBlockPosQuery(){

        @Override
        public boolean matches(World world, BlockPos pos) {
            return true;
        }
    };
    public static IBlockPosQuery nothing = new IBlockPosQuery(){

        @Override
        public boolean matches(World world, BlockPos pos) {
            return false;
        }
    };
    public static final Map<String, IBlockPosQuery> predefined = new HashMap<String, IBlockPosQuery>();
    private static Pattern nextTokenRegex = Pattern.compile("^(!?([\\w:]+|\\%\\w+|\\$\\w+|~\\w+|\\[.+\\]|@\\w+))");
    private static Pattern commaDelimitRegex = Pattern.compile("\\s*,\\s*");

    public static CompoundQueryBuilder buildAnd() {
        return new CompoundQueryBuilder(new BlockPosQueryAnd(new IBlockPosQuery[0]));
    }

    public static CompoundQueryBuilder buildOr() {
        return new CompoundQueryBuilder(new BlockPosQueryOr(new IBlockPosQuery[0]));
    }

    public static IBlockPosQuery parseQueryString(String spec) throws BlockQueryParseException {
        String[] subspecs;
        BlockPosQueryOr bmAny = new BlockPosQueryOr(new IBlockPosQuery[0]);
        for (String subspec : subspecs = commaDelimitRegex.split(spec)) {
            bmAny.add(BlockQuery.parseQueryStringSingle(subspec));
        }
        return bmAny.instance();
    }

    private static IBlockPosQuery parseQueryStringSingle(String spec) throws BlockQueryParseException {
        BlockPosQueryAnd bmAll = new BlockPosQueryAnd(new IBlockPosQuery[0]);
        Matcher m = nextTokenRegex.matcher(spec);
        while (spec.length() > 0) {
            m = nextTokenRegex.matcher(spec);
            if (!m.find()) {
                throw new BlockQueryParseException("Syntax error in " + spec);
            }
            String token = m.group(0);
            spec = spec.substring(token.length());
            boolean negated = false;
            if (token.charAt(0) == '!') {
                negated = true;
                token = token.substring(1);
            }
            if (token.charAt(0) == '%') {
                bmAll.add(BlockQueryClass.of(token.substring(1), negated, false));
                continue;
            }
            if (token.charAt(0) == '$') {
                bmAll.add(BlockQueryClass.of(token.substring(1), negated, true));
                continue;
            }
            if (token.charAt(0) == '~') {
                bmAll.add(BlockQueryMaterial.of(token.substring(1), negated));
                continue;
            }
            if (token.charAt(0) == '[') {
                String[] subtokens;
                for (String subtoken : subtokens = commaDelimitRegex.split(token.substring(1, token.length() - 1))) {
                    bmAll.add(BlockQueryProperty.of(subtoken, negated));
                }
                continue;
            }
            if (token.charAt(0) == '@') {
                IBlockPosQuery bm = predefined.get(token.substring(1));
                if (bm == null) {
                    throw new BlockQueryParseException("No predefined query named " + token.substring(1));
                }
                bmAll.add(negated ? new BlockPosQueryNot(bm) : bm);
                continue;
            }
            bmAll.add(BlockQueryBlock.of(token, negated));
        }
        return bmAll.instance();
    }

    public static class BlockQueryParseException
    extends Exception {
        public BlockQueryParseException(String message) {
            super(message);
        }
    }

    public static class BlockQueryMaterial
    extends BlockQueryBase {
        private Set<Material> materials;

        public BlockQueryMaterial(Material ... materials) {
            this.materials = Sets.newHashSet((Object[])materials);
        }

        @Override
        public boolean matches(IBlockState state) {
            return this.materials.contains(state.func_185904_a());
        }

        public static IBlockQuery of(String materialName, boolean negated) throws BlockQueryParseException {
            try {
                Field f = Material.class.getField(materialName);
                Object mat = f.get(null);
                if (mat instanceof Material) {
                    BlockQueryMaterial bm = new BlockQueryMaterial((Material)mat);
                    return negated ? new BlockQueryNot(bm) : bm;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new BlockQueryParseException("No block material found called " + materialName);
        }
    }

    public static class BlockQueryProperty
    extends BlockQueryBase {
        private static Pattern propertyNameValueRegex = Pattern.compile("^\\s*((\\w+)\\s*=\\s*)?([\\w\\|]+)\\s*$");
        private String propName;
        private String[] propValues;

        public BlockQueryProperty(String propName, String ... propValues) {
            this.propName = propName;
            this.propValues = propValues;
        }

        @Override
        public boolean matches(IBlockState state) {
            ImmutableMap properties = state.func_177228_b();
            for (Object property : properties.keySet()) {
                if (!((IProperty)property).func_177701_a().equalsIgnoreCase(this.propName)) continue;
                String thisPropValue = properties.get(property).toString();
                for (String value : this.propValues) {
                    if (!thisPropValue.equalsIgnoreCase(value)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public static IBlockQuery of(String nameValuePair, boolean negated) throws BlockQueryParseException {
            Matcher m = propertyNameValueRegex.matcher(nameValuePair);
            if (!m.find()) {
                throw new BlockQueryParseException("Syntax error in " + nameValuePair);
            }
            String propName = m.group(2);
            String[] propValues = m.group(3).split("\\|");
            if (propName == null) {
                propName = "variant";
            }
            BlockQueryProperty bm = new BlockQueryProperty(propName, propValues);
            return negated ? new BlockQueryNot(bm) : bm;
        }
    }

    public static class BlockQueryClass
    extends BlockQueryBase {
        public static String[] packages = new String[]{"", "biomesoplenty.common.block.", "net.minecraft.block."};
        private Class<? extends Block> clazz;
        private boolean strict;

        public BlockQueryClass(Class<? extends Block> clazz) {
            this(clazz, false);
        }

        public BlockQueryClass(Class<? extends Block> clazz, boolean strict) {
            this.clazz = clazz;
            this.strict = strict;
        }

        @Override
        public boolean matches(IBlockState state) {
            return this.strict ? state.func_177230_c().getClass() == this.clazz : this.clazz.isInstance(state.func_177230_c());
        }

        public static IBlockQuery of(String className, boolean negated, boolean strict) throws BlockQueryParseException {
            for (String packageName : packages) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(packageName + className);
                }
                catch (Exception e) {
                    continue;
                }
                if (!Block.class.isAssignableFrom(clazz)) continue;
                BlockQueryClass bm = new BlockQueryClass(clazz, strict);
                return negated ? new BlockQueryNot(bm) : bm;
            }
            throw new BlockQueryParseException("No class found extending from Block called " + className);
        }
    }

    public static class BlockQueryState
    extends BlockQueryBase {
        private Set<IBlockState> states;

        public BlockQueryState(IBlockState ... states) {
            this.states = Sets.newHashSet((Object[])states);
        }

        @Override
        public boolean matches(IBlockState state) {
            return this.states.contains(state);
        }
    }

    public static class BlockQueryBlock
    extends BlockQueryBase {
        private Set<Block> blocks;

        public BlockQueryBlock(Block ... blocks) {
            this.blocks = Sets.newHashSet((Object[])blocks);
        }

        @Override
        public boolean matches(IBlockState state) {
            return this.blocks.contains(state.func_177230_c());
        }

        public static IBlockQuery of(String blockName, boolean negated) throws BlockQueryParseException {
            Block block = Block.func_149684_b((String)blockName);
            if (block == null) {
                throw new BlockQueryParseException("No block called " + blockName);
            }
            BlockQueryBlock bm = new BlockQueryBlock(block);
            return negated ? new BlockQueryNot(bm) : bm;
        }
    }

    public static class BlockQueryNot
    extends BlockQueryBase {
        IBlockQuery child;

        public BlockQueryNot(IBlockQuery child) {
            this.child = child;
        }

        @Override
        public boolean matches(IBlockState state) {
            return !this.child.matches(state);
        }
    }

    public static abstract class BlockQueryBase
    implements IBlockQuery {
        @Override
        public boolean matches(World world, BlockPos pos) {
            return this.matches(world.func_180495_p(pos));
        }
    }

    public static class BlockPosQuerySustainsPlantType
    implements IBlockPosQuery {
        private EnumPlantType plantType;

        public BlockPosQuerySustainsPlantType(EnumPlantType plantType) {
            this.plantType = plantType;
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof ISustainsPlantType) {
                return ((ISustainsPlantType)block).canSustainPlantType((IBlockAccess)world, pos, this.plantType);
            }
            switch (this.plantType) {
                case Desert: {
                    return block == Blocks.field_150354_m || block == Blocks.field_150405_ch || block == Blocks.field_150406_ce || block == Blocks.field_150346_d || block == BOPBlocks.dirt || block == BOPBlocks.white_sand;
                }
                case Nether: {
                    return block == Blocks.field_150425_aM || state == BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.OVERGROWN_NETHERRACK));
                }
                case Crop: {
                    return block == Blocks.field_150458_ak || block == BOPBlocks.farmland_0 || block == BOPBlocks.farmland_1;
                }
                case Cave: {
                    return block.isSideSolid(state, (IBlockAccess)world, pos, EnumFacing.UP);
                }
                case Plains: {
                    return block == Blocks.field_150349_c || state == BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.LOAMY)) || state == BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SILTY)) || state == BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SANDY)) || state == BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.DAISY)) || block == Blocks.field_150346_d || block == BOPBlocks.dirt || block == Blocks.field_150458_ak || block == BOPBlocks.farmland_0 || block == BOPBlocks.farmland_1 || block == Blocks.field_150391_bh;
                }
                case Water: {
                    return state.func_185904_a() == Material.field_151586_h && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
                }
                case Beach: {
                    boolean isBeach = block == Blocks.field_150349_c || state == BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.LOAMY)) || state == BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SILTY)) || state == BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SANDY)) || state == BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.DAISY)) || block == Blocks.field_150346_d || block == BOPBlocks.dirt || block == BOPBlocks.white_sand || block == Blocks.field_150354_m || block == Blocks.field_150391_bh;
                    boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                    return isBeach && hasWater;
                }
            }
            return false;
        }
    }

    public static class BlockPosQueryLightAboveNoMoreThan
    implements IBlockPosQuery {
        public int level;

        public BlockPosQueryLightAboveNoMoreThan(int level) {
            this.level = level;
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            return world.func_175699_k(pos.func_177984_a()) <= this.level;
        }
    }

    public static class BlockPosQueryLightAboveAtLeast
    implements IBlockPosQuery {
        public int level;

        public BlockPosQueryLightAboveAtLeast(int level) {
            this.level = level;
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            return world.func_175699_k(pos.func_177984_a()) >= this.level || world.func_175678_i(pos.func_177984_a());
        }
    }

    public static class BlockPosQueryAltitude
    implements IBlockPosQuery {
        public int minHeight;
        public int maxHeight;

        public BlockPosQueryAltitude(int minHeight, int maxHeight) {
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            return pos.func_177956_o() >= this.minHeight && pos.func_177956_o() <= this.maxHeight;
        }
    }

    public static class BlockPosQueryNot
    implements IBlockPosQuery {
        IBlockPosQuery child;

        public BlockPosQueryNot(IBlockPosQuery child) {
            this.child = child;
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            return !this.child.matches(world, pos);
        }
    }

    public static class BlockPosQueryAnd
    implements ICompoundBlockPosQuery {
        private ArrayList<IBlockPosQuery> children;

        public BlockPosQueryAnd(IBlockPosQuery ... children) {
            this.children = new ArrayList<IBlockPosQuery>(Arrays.asList(children));
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            for (IBlockPosQuery child : this.children) {
                if (child.matches(world, pos)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void add(IBlockPosQuery child) {
            if (child != null) {
                this.children.add(child);
            }
        }

        @Override
        public IBlockPosQuery instance() {
            return this.children.size() == 0 ? anything : (this.children.size() == 1 ? this.children.get(0) : this);
        }
    }

    public static class BlockPosQueryOr
    implements ICompoundBlockPosQuery {
        private ArrayList<IBlockPosQuery> children;

        public BlockPosQueryOr(IBlockPosQuery ... children) {
            this.children = new ArrayList<IBlockPosQuery>(Arrays.asList(children));
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            for (IBlockPosQuery child : this.children) {
                if (!child.matches(world, pos)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void add(IBlockPosQuery child) {
            if (child != null) {
                this.children.add(child);
            }
        }

        @Override
        public IBlockPosQuery instance() {
            return this.children.size() == 0 ? anything : (this.children.size() == 1 ? this.children.get(0) : this);
        }
    }

    public static class CompoundQueryBuilder {
        private ICompoundBlockPosQuery query;

        public CompoundQueryBuilder(ICompoundBlockPosQuery query) {
            this.query = query;
        }

        public CompoundQueryBuilder add(IBlockPosQuery a) {
            this.query.add(a);
            return this;
        }

        public CompoundQueryBuilder blocks(Block ... blocks) {
            return this.add(new BlockQueryBlock(blocks));
        }

        public CompoundQueryBuilder states(IBlockState ... states) {
            return this.add(new BlockQueryState(states));
        }

        public CompoundQueryBuilder blockClass(Class<? extends Block> clazz) {
            return this.add(new BlockQueryClass(clazz));
        }

        public CompoundQueryBuilder materials(Material ... materials) {
            return this.add(new BlockQueryMaterial(materials));
        }

        public CompoundQueryBuilder withProperty(String propName, String ... propValues) {
            return this.add(new BlockQueryProperty(propName, propValues));
        }

        public CompoundQueryBuilder not(IBlockPosQuery query) {
            return this.add(new BlockPosQueryNot(query));
        }

        public CompoundQueryBuilder notBlocks(Block ... blocks) {
            return this.not(new BlockQueryBlock(blocks));
        }

        public CompoundQueryBuilder notStates(IBlockState ... states) {
            return this.not(new BlockQueryState(states));
        }

        public CompoundQueryBuilder notBlockClass(Class<? extends Block> clazz) {
            return this.not(new BlockQueryClass(clazz));
        }

        public CompoundQueryBuilder notMaterial(Material ... materials) {
            return this.not(new BlockQueryMaterial(materials));
        }

        public CompoundQueryBuilder notWithProperty(String propName, String ... propValues) {
            return this.not(new BlockQueryProperty(propName, propValues));
        }

        public CompoundQueryBuilder withAltitudeBetween(int a, int b) {
            return this.add(new BlockPosQueryAltitude(a, b));
        }

        public CompoundQueryBuilder byWater() {
            return this.add(BlockQueries.hasWater);
        }

        public CompoundQueryBuilder withAirAbove() {
            return this.add(BlockQueries.airAbove);
        }

        public CompoundQueryBuilder withAirBelow() {
            return this.add(BlockQueries.airBelow);
        }

        public CompoundQueryBuilder withLightAboveAtLeast(int a) {
            return this.add(new BlockPosQueryLightAboveAtLeast(a));
        }

        public CompoundQueryBuilder withLightAboveNoMoreThan(int a) {
            return this.add(new BlockPosQueryLightAboveNoMoreThan(a));
        }

        public CompoundQueryBuilder sustainsPlant(EnumPlantType plantType) {
            return this.add(new BlockPosQuerySustainsPlantType(plantType));
        }

        public IBlockPosQuery create() {
            return this.query.instance();
        }
    }

    public static interface IBlockQuery
    extends IBlockPosQuery {
        public boolean matches(IBlockState var1);
    }

    public static interface ICompoundBlockPosQuery
    extends IBlockPosQuery {
        public void add(IBlockPosQuery var1);

        public IBlockPosQuery instance();
    }
}

