/*
 * Decompiled with CFR 0.152.
 */
package gkappa.modernsplash;

import gkappa.modernsplash.MSLoadingPlugin;
import gkappa.modernsplash.ModernSplash;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleResource;
import net.minecraft.crash.CrashReport;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.asm.FMLSanityChecker;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.SharedDrawable;
import org.lwjgl.util.glu.GLU;

public class CustomSplash {
    private static Drawable d;
    private static volatile boolean pause;
    private static volatile boolean done;
    private static Thread thread;
    private static volatile Throwable threadError;
    private static int angle;
    private static final Lock lock;
    private static SplashFontRenderer fontRenderer;
    private static final IResourcePack mcPack;
    private static final IResourcePack fmlPack;
    private static IResourcePack miscPack;
    private static Texture fontTexture;
    private static Texture logoTexture;
    private static Texture forgeTexture;
    private static Properties config;
    private static boolean enabled;
    private static boolean forgeLogo;
    private static boolean rotate;
    private static int logoOffset;
    private static int backgroundColor;
    private static int fontColor;
    private static int logoColor;
    private static int barBorderColor;
    private static int barColor;
    private static int barBackgroundColor;
    private static boolean showMemory;
    private static boolean showTotalMemoryLine;
    private static int memoryGoodColor;
    private static int memoryWarnColor;
    private static int memoryLowColor;
    private static float memoryColorPercent;
    private static long memoryColorChangeTime;
    public static boolean isDisplayVSyncForced;
    public static boolean displayStartupTimeOnMainMenu;
    public static boolean enableTimer;
    private static final int TIMING_FRAME_COUNT = 200;
    private static final int TIMING_FRAME_THRESHOLD = 1000000000;
    public static final Semaphore mutex;
    private static int max_texture_size;
    private static final IntBuffer buf;

    private static String getString(String name, String def) {
        String value = config.getProperty(name, def);
        config.setProperty(name, value);
        return value;
    }

    private static boolean getBool(String name, boolean def) {
        return Boolean.parseBoolean(CustomSplash.getString(name, Boolean.toString(def)));
    }

    private static int getInt(String name, int def) {
        return Integer.decode(CustomSplash.getString(name, Integer.toString(def)));
    }

    private static int getHex(String name, int def) {
        return Integer.decode(CustomSplash.getString(name, "0x" + Integer.toString(def, 16).toUpperCase()));
    }

    public static void start() {
        File configFile = new File(Minecraft.func_71410_x().field_71412_D, "config/splash.properties");
        File parent = configFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        config = new Properties();
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
            config.load(r);
        }
        catch (IOException e) {
            FMLLog.log.info("Could not load splash.properties, will create a default one");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HHmm");
        int now = Integer.parseInt(formatter.format(LocalDateTime.now()));
        boolean defaultEnabled = true;
        enabled = CustomSplash.getBool("enabled", defaultEnabled) && (!FMLClientHandler.instance().hasOptifine() || Launch.blackboard.containsKey("optifine.ForgeSplashCompatible"));
        forgeLogo = CustomSplash.getBool("forgeLogo", false);
        rotate = CustomSplash.getBool("rotate", false);
        showMemory = CustomSplash.getBool("showMemory", true);
        showTotalMemoryLine = CustomSplash.getBool("showTotalMemoryLine", false);
        enableTimer = CustomSplash.getBool("enableTimer", true);
        logoOffset = CustomSplash.getInt("logoOffset", 0);
        backgroundColor = CustomSplash.getHex("background", 15675965);
        fontColor = CustomSplash.getHex("font", 0xFFFFFF);
        logoColor = CustomSplash.getHex("logo", 0xFFFFFF);
        barBorderColor = CustomSplash.getHex("barBorder", 0xFFFFFF);
        barColor = CustomSplash.getHex("bar", 0xFFFFFF);
        barBackgroundColor = CustomSplash.getHex("barBackground", 15675965);
        memoryGoodColor = CustomSplash.getHex("memoryGood", 0xFFFFFF);
        memoryWarnColor = CustomSplash.getHex("memoryWarn", 0xFFFFFF);
        memoryLowColor = CustomSplash.getHex("memoryLow", 0xFFFFFF);
        displayStartupTimeOnMainMenu = CustomSplash.getBool("timeOnMainMenu", true);
        boolean darkModeOnly = CustomSplash.getBool("darkModeOnly", false);
        int darkStartTime = CustomSplash.getInt("darkStartTime", 2300);
        int darkEndTime = CustomSplash.getInt("darkEndTime", 600);
        int backgroundColorNight = CustomSplash.getHex("backgroundDark", 0x202020);
        int fontColorNight = CustomSplash.getHex("fontDark", 0x606060);
        int logoColorNight = CustomSplash.getHex("logoDark", 0x999999);
        int barBorderColorNight = CustomSplash.getHex("barBorderDark", 0x4E4E4E);
        int barColorNight = CustomSplash.getHex("barDark", 0x4E4E4E);
        int barBackgroundColorNight = CustomSplash.getHex("barBackgroundDark", 0x202020);
        int memoryGoodColorNight = CustomSplash.getHex("memoryGoodDark", 0x4E4E4E);
        int memoryWarnColorNight = CustomSplash.getHex("memoryWarnDark", 0x4E4E4E);
        int memoryLowColorNight = CustomSplash.getHex("memoryLowDark", 0x4E4E4E);
        if (darkModeOnly || (darkEndTime >= darkStartTime ? now >= darkStartTime && now < darkEndTime : now >= darkStartTime || now <= darkEndTime)) {
            backgroundColor = backgroundColorNight;
            fontColor = fontColorNight;
            logoColor = logoColorNight;
            barBorderColor = barBorderColorNight;
            barColor = barColorNight;
            barBackgroundColor = barBackgroundColorNight;
            memoryGoodColor = memoryGoodColorNight;
            memoryWarnColor = memoryWarnColorNight;
            memoryLowColor = memoryLowColorNight;
        }
        final ResourceLocation fontLoc = new ResourceLocation(CustomSplash.getString("fontTexture", "textures/font/ascii.png"));
        final ResourceLocation logoLoc = new ResourceLocation(CustomSplash.getString("logoTexture", "modernsplash:textures/gui/title/mojang.png"));
        final ResourceLocation forgeLoc = new ResourceLocation(CustomSplash.getString("forgeTexture", "fml:textures/gui/forge.png"));
        final ResourceLocation forgeFallbackLoc = new ResourceLocation("fml:textures/gui/forge.png");
        File miscPackFile = new File(Minecraft.func_71410_x().field_71412_D, CustomSplash.getString("resourcePackPath", "resources"));
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8);){
            config.store(w, "Splash screen properties");
        }
        catch (IOException e) {
            FMLLog.log.error("Could not save the splash.properties file", (Throwable)e);
        }
        miscPack = CustomSplash.createResourcePack(miscPackFile);
        if (!enabled) {
            return;
        }
        FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

            public String call() throws Exception {
                return "' Vendor: '" + GL11.glGetString((int)7936) + "' Version: '" + GL11.glGetString((int)7938) + "' Renderer: '" + GL11.glGetString((int)7937) + "'";
            }

            public String getLabel() {
                return "GL info";
            }
        });
        CrashReport report = CrashReport.func_85055_a((Throwable)new Throwable(), (String)"Loading screen debug info");
        StringBuilder systemDetailsBuilder = new StringBuilder();
        report.func_85056_g().func_85072_a(systemDetailsBuilder);
        FMLLog.log.info(systemDetailsBuilder.toString());
        try {
            d = new SharedDrawable(Display.getDrawable());
            Display.getDrawable().releaseContext();
            d.makeCurrent();
        }
        catch (LWJGLException e) {
            FMLLog.log.error("Error starting SplashProgress:", (Throwable)e);
            CustomSplash.disableSplash((Exception)((Object)e));
        }
        CustomSplash.getMaxTextureSize();
        thread = new Thread(new Runnable(){
            private final int barWidth = 400;
            private final int barHeight = 20;
            private final int textHeight2 = 20;
            private final int barOffset = 45;
            private long updateTiming;
            private long framecount;

            @Override
            public void run() {
                this.setGL();
                fontTexture = new Texture(fontLoc, null);
                logoTexture = new Texture(logoLoc, null, true);
                forgeTexture = new Texture(forgeLoc, forgeFallbackLoc);
                GL11.glEnable((int)3553);
                fontRenderer = new SplashFontRenderer();
                GL11.glDisable((int)3553);
                while (!done) {
                    ++this.framecount;
                    ProgressManager.ProgressBar first = null;
                    ProgressManager.ProgressBar penult = null;
                    ProgressManager.ProgressBar last = null;
                    Iterator i = ProgressManager.barIterator();
                    while (i.hasNext()) {
                        if (first == null) {
                            first = (ProgressManager.ProgressBar)i.next();
                            continue;
                        }
                        penult = last;
                        last = (ProgressManager.ProgressBar)i.next();
                    }
                    GL11.glClear((int)16384);
                    int w = Display.getWidth();
                    int h = Display.getHeight();
                    GL11.glViewport((int)0, (int)0, (int)w, (int)h);
                    GL11.glMatrixMode((int)5889);
                    GL11.glLoadIdentity();
                    GL11.glOrtho((double)(320 - w / 2), (double)(320 + w / 2), (double)(240 + h / 2), (double)(240 - h / 2), (double)-1.0, (double)1.0);
                    GL11.glMatrixMode((int)5888);
                    GL11.glLoadIdentity();
                    this.setColor(logoColor);
                    GL11.glEnable((int)3553);
                    logoTexture.bind();
                    GL11.glBegin((int)7);
                    logoTexture.texCoord(0, 0.0f, 0.0f);
                    GL11.glVertex2f((float)64.0f, (float)-16.0f);
                    logoTexture.texCoord(0, 0.0f, 1.0f);
                    GL11.glVertex2f((float)64.0f, (float)496.0f);
                    logoTexture.texCoord(0, 1.0f, 1.0f);
                    GL11.glVertex2f((float)576.0f, (float)496.0f);
                    logoTexture.texCoord(0, 1.0f, 0.0f);
                    GL11.glVertex2f((float)576.0f, (float)-16.0f);
                    GL11.glEnd();
                    GL11.glDisable((int)3553);
                    if (showMemory) {
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)120.0f, (float)20.0f, (float)0.0f);
                        this.drawMemoryBar();
                        GL11.glPopMatrix();
                    }
                    if (enableTimer) {
                        GL11.glPushMatrix();
                        this.setColor(fontColor);
                        GL11.glTranslatef((float)(320 - Display.getWidth() / 2 + 4), (float)(240 + Display.getHeight() / 2 - 20), (float)0.0f);
                        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                        GL11.glEnable((int)3553);
                        String renderString = this.getString();
                        fontRenderer.func_78276_b(renderString, 0, 0, 0);
                        GL11.glDisable((int)3553);
                        GL11.glPopMatrix();
                    }
                    if (first != null) {
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)120.0f, (float)310.0f, (float)0.0f);
                        this.drawBar(first);
                        if (penult != null) {
                            GL11.glTranslatef((float)0.0f, (float)45.0f, (float)0.0f);
                            this.drawBar(penult);
                        }
                        if (last != null) {
                            GL11.glTranslatef((float)0.0f, (float)45.0f, (float)0.0f);
                            this.drawBar(last);
                        }
                        GL11.glPopMatrix();
                    }
                    if (forgeLogo) {
                        angle = angle + 1;
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        float fw = (float)forgeTexture.getWidth() / 2.0f;
                        float fh = (float)forgeTexture.getHeight() / 2.0f;
                        if (rotate) {
                            float sh = Math.max(fw, fh);
                            GL11.glTranslatef((float)((float)(320 + w / 2) - sh - (float)logoOffset), (float)((float)(240 + h / 2) - sh - (float)logoOffset), (float)0.0f);
                            GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                        } else {
                            GL11.glTranslatef((float)((float)(320 + w / 2) - fw - (float)logoOffset), (float)((float)(240 + h / 2) - fh - (float)logoOffset), (float)0.0f);
                        }
                        int f = angle / 5 % forgeTexture.getFrames();
                        GL11.glEnable((int)3553);
                        forgeTexture.bind();
                        GL11.glBegin((int)7);
                        forgeTexture.texCoord(f, 0.0f, 0.0f);
                        GL11.glVertex2f((float)(-fw), (float)(-fh));
                        forgeTexture.texCoord(f, 0.0f, 1.0f);
                        GL11.glVertex2f((float)(-fw), (float)fh);
                        forgeTexture.texCoord(f, 1.0f, 1.0f);
                        GL11.glVertex2f((float)fw, (float)fh);
                        forgeTexture.texCoord(f, 1.0f, 0.0f);
                        GL11.glVertex2f((float)fw, (float)(-fh));
                        GL11.glEnd();
                        GL11.glDisable((int)3553);
                    }
                    mutex.acquireUninterruptibly();
                    long updateStart = System.nanoTime();
                    Display.update();
                    long dur = System.nanoTime() - updateStart;
                    if (this.framecount < 200L) {
                        this.updateTiming += dur;
                    }
                    mutex.release();
                    if (pause) {
                        this.clearGL();
                        this.setGL();
                    }
                    if (this.framecount >= 200L && this.updateTiming > 1000000000L) {
                        if (!isDisplayVSyncForced) {
                            isDisplayVSyncForced = true;
                            FMLLog.log.info("Using alternative sync timing : {} frames of Display.update took {} nanos", (Object)200, (Object)this.updateTiming);
                        }
                        try {
                            Thread.sleep(16L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    if (this.framecount == 200L) {
                        FMLLog.log.info("Using sync timing. {} frames of Display.update took {} nanos", (Object)200, (Object)this.updateTiming);
                    }
                    Display.sync((int)100);
                }
                this.clearGL();
            }

            private String getString() {
                long startupTime = ManagementFactory.getRuntimeMXBean().getUptime();
                if (ModernSplash.doneTime > 0L) {
                    startupTime = ModernSplash.doneTime;
                }
                long minutes = startupTime / 1000L / 60L;
                long seconds = startupTime / 1000L % 60L;
                String str = "Startup: " + minutes + "m " + seconds + "s";
                if (MSLoadingPlugin.expectedTime > 0L) {
                    long ex_minutes = MSLoadingPlugin.expectedTime / 1000L / 60L;
                    long ex_seconds = MSLoadingPlugin.expectedTime / 1000L % 60L;
                    str = str + " / ~" + ex_minutes + "m " + ex_seconds + "s";
                }
                return str;
            }

            private void setColor(int color) {
                GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
            }

            private void drawBox(int w, int h) {
                GL11.glBegin((int)7);
                GL11.glVertex2f((float)0.0f, (float)0.0f);
                GL11.glVertex2f((float)0.0f, (float)h);
                GL11.glVertex2f((float)w, (float)h);
                GL11.glVertex2f((float)w, (float)0.0f);
                GL11.glEnd();
            }

            private void drawBar(ProgressManager.ProgressBar b) {
                String progress = "" + b.getStep() + "/" + b.getSteps();
                GL11.glPushMatrix();
                this.setColor(fontColor);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                GL11.glEnable((int)3553);
                fontRenderer.func_78276_b(b.getTitle() + " " + progress + " - " + b.getMessage(), 0, 0, 0);
                GL11.glDisable((int)3553);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)20.0f, (float)0.0f);
                this.setColor(barBorderColor);
                this.drawBox(400, 20);
                this.setColor(barBackgroundColor);
                GL11.glTranslatef((float)2.0f, (float)2.0f, (float)0.0f);
                this.drawBox(396, 16);
                this.setColor(barColor);
                GL11.glTranslatef((float)2.0f, (float)2.0f, (float)0.0f);
                this.drawBox(392 * (b.getStep() + 1) / (b.getSteps() + 1), 12);
                GL11.glPopMatrix();
            }

            private void drawMemoryBar() {
                int maxMemory = CustomSplash.bytesToMb(Runtime.getRuntime().maxMemory());
                int totalMemory = CustomSplash.bytesToMb(Runtime.getRuntime().totalMemory());
                int freeMemory = CustomSplash.bytesToMb(Runtime.getRuntime().freeMemory());
                int usedMemory = totalMemory - freeMemory;
                float usedMemoryPercent = (float)usedMemory / (float)maxMemory;
                String progress = this.getMemoryString(usedMemory) + " / " + this.getMemoryString(maxMemory);
                GL11.glPushMatrix();
                this.setColor(fontColor);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                GL11.glEnable((int)3553);
                fontRenderer.func_78276_b("Memory Usage : " + progress, 0, 0, 0);
                GL11.glDisable((int)3553);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)20.0f, (float)0.0f);
                this.setColor(barBorderColor);
                this.drawBox(400, 20);
                this.setColor(barBackgroundColor);
                GL11.glTranslatef((float)2.0f, (float)2.0f, (float)0.0f);
                this.drawBox(396, 16);
                long time = System.currentTimeMillis();
                if (usedMemoryPercent > memoryColorPercent || time - memoryColorChangeTime > 1000L) {
                    memoryColorChangeTime = time;
                    memoryColorPercent = usedMemoryPercent;
                }
                int memoryBarColor = memoryColorPercent < 0.75f ? memoryGoodColor : (memoryColorPercent < 0.85f ? memoryWarnColor : memoryLowColor);
                if (showTotalMemoryLine) {
                    this.setColor(memoryLowColor);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(392 * totalMemory / maxMemory - 2), (float)2.0f, (float)0.0f);
                    this.drawBox(2, 12);
                    GL11.glPopMatrix();
                }
                this.setColor(memoryBarColor);
                GL11.glTranslatef((float)2.0f, (float)2.0f, (float)0.0f);
                this.drawBox(392 * usedMemory / maxMemory, 12);
                GL11.glPopMatrix();
            }

            private String getMemoryString(int memory) {
                return StringUtils.leftPad((String)Integer.toString(memory), (int)4, (char)' ') + " MB";
            }

            private void setGL() {
                lock.lock();
                try {
                    Display.getDrawable().makeCurrent();
                }
                catch (LWJGLException e) {
                    FMLLog.log.error("Error setting GL context:", (Throwable)e);
                    throw new RuntimeException(e);
                }
                GL11.glClearColor((float)((float)(backgroundColor >> 16 & 0xFF) / 255.0f), (float)((float)(backgroundColor >> 8 & 0xFF) / 255.0f), (float)((float)(backgroundColor & 0xFF) / 255.0f), (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }

            private void clearGL() {
                Minecraft mc = Minecraft.func_71410_x();
                mc.field_71443_c = Display.getWidth();
                mc.field_71440_d = Display.getHeight();
                mc.func_71370_a(mc.field_71443_c, mc.field_71440_d);
                GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)2929);
                GL11.glDepthFunc((int)515);
                GL11.glEnable((int)3008);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                try {
                    Display.getDrawable().releaseContext();
                }
                catch (LWJGLException e) {
                    FMLLog.log.error("Error releasing GL context:", (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    lock.unlock();
                }
            }
        });
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                FMLLog.log.error("Splash thread Exception", e);
                threadError = e;
            }
        });
        thread.start();
        CustomSplash.checkThreadState();
    }

    public static int getMaxTextureSize() {
        if (max_texture_size != -1) {
            return max_texture_size;
        }
        max_texture_size = GL11.glGetInteger((int)3379);
        return max_texture_size;
    }

    private static void checkThreadState() {
        if (thread.getState() == Thread.State.TERMINATED || threadError != null) {
            throw new IllegalStateException("Splash thread", threadError);
        }
    }

    @Deprecated
    public static void pause() {
        if (!enabled) {
            return;
        }
        CustomSplash.checkThreadState();
        pause = true;
        lock.lock();
        try {
            d.releaseContext();
            Display.getDrawable().makeCurrent();
        }
        catch (LWJGLException e) {
            FMLLog.log.error("Error setting GL context:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void resume() {
        if (!enabled) {
            return;
        }
        CustomSplash.checkThreadState();
        pause = false;
        try {
            Display.getDrawable().releaseContext();
            d.makeCurrent();
        }
        catch (LWJGLException e) {
            FMLLog.log.error("Error releasing GL context:", (Throwable)e);
            throw new RuntimeException(e);
        }
        lock.unlock();
    }

    public static void finish() {
        if (!enabled) {
            return;
        }
        try {
            CustomSplash.checkThreadState();
            done = true;
            thread.join();
            GL11.glFlush();
            d.releaseContext();
            Display.getDrawable().makeCurrent();
            fontTexture.delete();
            logoTexture.delete();
            forgeTexture.delete();
        }
        catch (Exception e) {
            FMLLog.log.error("Error finishing SplashProgress:", (Throwable)e);
            CustomSplash.disableSplash(e);
        }
    }

    private static boolean disableSplash(Exception e) {
        if (CustomSplash.disableSplash()) {
            throw new EnhancedRuntimeException(e){

                protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                    stream.println("SplashProgress has detected a error loading Minecraft.");
                    stream.println("This can sometimes be caused by bad video drivers.");
                    stream.println("We have automatically disabled the new Splash Screen in config/splash.properties.");
                    stream.println("Try reloading minecraft before reporting any errors.");
                }
            };
        }
        throw new EnhancedRuntimeException(e){

            protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                stream.println("SplashProgress has detected a error loading Minecraft.");
                stream.println("This can sometimes be caused by bad video drivers.");
                stream.println("Please try disabling the new Splash Screen in config/splash.properties.");
                stream.println("After doing so, try reloading minecraft before reporting any errors.");
            }
        };
    }

    private static boolean disableSplash() {
        File configFile = new File(Minecraft.func_71410_x().field_71412_D, "config/splash.properties");
        File parent = configFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        enabled = false;
        config.setProperty("enabled", "false");
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8);){
            config.store(w, "Splash screen properties");
        }
        catch (IOException e) {
            FMLLog.log.error("Could not save the splash.properties file", (Throwable)e);
            return false;
        }
        return true;
    }

    private static IResourcePack createResourcePack(File file) {
        if (file.isDirectory()) {
            return new FolderResourcePack(file);
        }
        return new FileResourcePack(file);
    }

    public static void drawVanillaScreen(TextureManager renderEngine) throws LWJGLException {
        if (!enabled) {
            Minecraft.func_71410_x().func_180510_a(renderEngine);
        }
    }

    public static void clearVanillaResources(TextureManager renderEngine, ResourceLocation mojangLogo) {
        if (!enabled) {
            renderEngine.func_147645_c(mojangLogo);
        }
    }

    public static void checkGLError(String where) {
        int err = GL11.glGetError();
        if (err != 0) {
            throw new IllegalStateException(where + ": " + GLU.gluErrorString((int)err));
        }
    }

    private static InputStream open(ResourceLocation loc, @Nullable ResourceLocation fallback, boolean allowResourcePack) throws IOException {
        if (!allowResourcePack) {
            return mcPack.func_110590_a(loc);
        }
        if (miscPack.func_110589_b(loc)) {
            return miscPack.func_110590_a(loc);
        }
        if (fmlPack.func_110589_b(loc)) {
            return fmlPack.func_110590_a(loc);
        }
        if (!mcPack.func_110589_b(loc) && fallback != null) {
            return CustomSplash.open(fallback, null, true);
        }
        return mcPack.func_110590_a(loc);
    }

    private static int bytesToMb(long bytes) {
        return (int)(bytes / 1024L / 1024L);
    }

    static {
        pause = false;
        done = false;
        angle = 0;
        lock = new ReentrantLock(true);
        mcPack = Minecraft.func_71410_x().field_110450_ap;
        fmlPack = CustomSplash.createResourcePack(FMLSanityChecker.fmlLocation);
        isDisplayVSyncForced = false;
        displayStartupTimeOnMainMenu = true;
        enableTimer = true;
        mutex = new Semaphore(1);
        max_texture_size = -1;
        buf = BufferUtils.createIntBuffer((int)0x400000);
    }

    private static class SplashFontRenderer
    extends FontRenderer {
        public SplashFontRenderer() {
            super(Minecraft.func_71410_x().field_71474_y, fontTexture.getLocation(), null, false);
            super.func_110549_a(null);
        }

        protected void bindTexture(@Nonnull ResourceLocation location) {
            if (location != this.field_111273_g) {
                throw new IllegalArgumentException();
            }
            fontTexture.bind();
        }

        @Nonnull
        protected IResource getResource(@Nonnull ResourceLocation location) throws IOException {
            DefaultResourcePack pack = Minecraft.func_71410_x().field_110450_ap;
            return new SimpleResource(pack.func_130077_b(), location, pack.func_110590_a(location), null, null);
        }
    }

    private static class Texture {
        private final ResourceLocation location;
        private final int name;
        private final int width;
        private final int height;
        private final int frames;
        private final int size;

        public Texture(ResourceLocation location, @Nullable ResourceLocation fallback) {
            this(location, fallback, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Texture(ResourceLocation location, @Nullable ResourceLocation fallback, boolean allowRP) {
            InputStream s = null;
            try {
                this.location = location;
                s = CustomSplash.open(location, fallback, allowRP);
                ImageInputStream stream = ImageIO.createImageInputStream(s);
                Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                if (!readers.hasNext()) {
                    throw new IOException("No suitable reader found for image" + location);
                }
                ImageReader reader = readers.next();
                reader.setInput(stream);
                int frames = reader.getNumImages(true);
                BufferedImage[] images = new BufferedImage[frames];
                for (int i = 0; i < frames; ++i) {
                    images[i] = reader.read(i);
                }
                reader.dispose();
                this.width = images[0].getWidth();
                int height = images[0].getHeight();
                if (height > this.width && height % this.width == 0) {
                    frames = height / this.width;
                    BufferedImage original = images[0];
                    height = this.width;
                    images = new BufferedImage[frames];
                    for (int i = 0; i < frames; ++i) {
                        images[i] = original.getSubimage(0, i * height, this.width, height);
                    }
                }
                this.frames = frames;
                this.height = height;
                int size = 1;
                while (size / this.width * (size / height) < frames) {
                    size *= 2;
                }
                this.size = size;
                GL11.glEnable((int)3553);
                Class<CustomSplash> i = CustomSplash.class;
                synchronized (CustomSplash.class) {
                    this.name = GL11.glGenTextures();
                    GL11.glBindTexture((int)3553, (int)this.name);
                    // ** MonitorExit[i] (shouldn't be in output)
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)size, (int)size, (int)0, (int)32993, (int)33639, (IntBuffer)null);
                    CustomSplash.checkGLError("Texture creation");
                    int i2 = 0;
                    while (i2 * (size / this.width) < frames) {
                        for (int j = 0; i2 * (size / this.width) + j < frames && j < size / this.width; ++j) {
                            buf.clear();
                            BufferedImage image = images[i2 * (size / this.width) + j];
                            for (int k = 0; k < height; ++k) {
                                for (int l = 0; l < this.width; ++l) {
                                    buf.put(image.getRGB(l, k));
                                }
                            }
                            buf.position(0).limit(this.width * height);
                            GL11.glTexSubImage2D((int)3553, (int)0, (int)(j * this.width), (int)(i2 * height), (int)this.width, (int)height, (int)32993, (int)33639, (IntBuffer)buf);
                            CustomSplash.checkGLError("Texture uploading");
                        }
                        ++i2;
                    }
                    GL11.glBindTexture((int)3553, (int)0);
                    GL11.glDisable((int)3553);
                }
            }
            catch (IOException e) {
                try {
                    FMLLog.log.error("Error reading texture from file: {}", (Object)location, (Object)e);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(s);
                    throw throwable;
                }
            }
            {
                IOUtils.closeQuietly((InputStream)s);
                return;
            }
        }

        public ResourceLocation getLocation() {
            return this.location;
        }

        public int getName() {
            return this.name;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getFrames() {
            return this.frames;
        }

        public int getSize() {
            return this.size;
        }

        public void bind() {
            GL11.glBindTexture((int)3553, (int)this.name);
        }

        public void delete() {
            GL11.glDeleteTextures((int)this.name);
        }

        public float getU(int frame, float u) {
            return (float)this.width * ((float)(frame % (this.size / this.width)) + u) / (float)this.size;
        }

        public float getV(int frame, float v) {
            return (float)this.height * ((float)(frame / (this.size / this.width)) + v) / (float)this.size;
        }

        public void texCoord(int frame, float u, float v) {
            GL11.glTexCoord2f((float)this.getU(frame, u), (float)this.getV(frame, v));
        }
    }
}

