/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.commands;

import chanceCubes.client.gui.SchematicCreationGui;
import chanceCubes.client.listeners.RenderEvent;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomProfileLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.hookins.ModHookUtil;
import chanceCubes.profiles.GlobalProfileManager;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.registry.player.PlayerRewardInfo;
import chanceCubes.rewards.DefaultGiantRewards;
import chanceCubes.rewards.DefaultRewards;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.util.GiantCubeUtil;
import chanceCubes.util.NonreplaceableBlockOverride;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.SchematicUtil;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CCubesServerCommands
extends CommandBase {
    private List<String> aliases = new ArrayList<String>();
    private List<String> tab;

    public CCubesServerCommands() {
        this.aliases.add("Chancecubes");
        this.aliases.add("chancecubes");
        this.aliases.add("ChanceCube");
        this.aliases.add("Chancecube");
        this.aliases.add("chancecube");
        this.aliases.add("CCubes");
        this.tab = new ArrayList<String>();
        this.tab.add("reload");
        this.tab.add("version");
        this.tab.add("handNBT");
        this.tab.add("handID");
        this.tab.add("disableReward");
        this.tab.add("enableReward");
        this.tab.add("schematic");
        this.tab.add("rewardsInfo");
        this.tab.add("testRewards");
        this.tab.add("testCustomRewards");
        this.tab.add("spawnGiantCube");
    }

    public String func_71517_b() {
        return "ChanceCubes";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/ChanceCubes <reload/version/handNBT/enableReward/disableReward>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            return;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            new Thread(() -> {
                GlobalCCRewardRegistry.DEFAULT.ClearRewards();
                GlobalCCRewardRegistry.GIANT.ClearRewards();
                GlobalProfileManager.clearProfiles();
                ConfigLoader.reload();
                DefaultRewards.loadDefaultRewards();
                DefaultGiantRewards.loadDefaultRewards();
                CustomRewardsLoader.instance.loadCustomRewards();
                GlobalCCRewardRegistry.loadCustomUserRewards(server);
                ModHookUtil.loadCustomModRewards();
                NonreplaceableBlockOverride.loadOverrides();
                GlobalProfileManager.initProfiles();
                CustomProfileLoader.instance.loadProfiles();
                GlobalProfileManager.updateProfilesForWorld(server.func_130014_f_());
                sender.func_145747_a((ITextComponent)new TextComponentString("Rewards Reloaded"));
            }).start();
        } else if (args[0].equalsIgnoreCase("version")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Chance Cubes Version 1.12.2-5.0.2.385"));
        } else if (args[0].equalsIgnoreCase("handNBT")) {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                NBTTagCompound nbt = player.field_71071_by.func_70448_g().func_77978_p();
                if (nbt != null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(nbt.toString()));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("This item has no tag nbt data"));
                }
            }
        } else if (args[0].equalsIgnoreCase("handID")) {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                ItemStack stack = player.field_71071_by.func_70448_g();
                if (!stack.func_190926_b()) {
                    ResourceLocation res = stack.func_77973_b().getRegistryName();
                    sender.func_145747_a((ITextComponent)new TextComponentString(res.func_110624_b() + ":" + res.func_110623_a()));
                    sender.func_145747_a((ITextComponent)new TextComponentString("meta: " + stack.func_77952_i()));
                }
            }
        } else if (args[0].equalsIgnoreCase("disableReward")) {
            if (args.length > 2) {
                if (args[1].equalsIgnoreCase("global")) {
                    if (GlobalCCRewardRegistry.DEFAULT.disableReward(args[1])) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(args[1] + " Has been temporarily disabled."));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString(args[1] + " is either not currently enabled or is not a valid reward name."));
                    }
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Try /chancecubes enableReward <global|playername> <Reward Name>"));
            }
        } else if (args[0].equalsIgnoreCase("enableReward")) {
            if (args.length > 2) {
                if (args[1].equalsIgnoreCase("global")) {
                    if (GlobalCCRewardRegistry.DEFAULT.enableReward(args[1])) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(args[1] + " Has been enabled."));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString(args[1] + " is either not currently disabled or is not a valid reward name."));
                    }
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Try /chancecubes disableReward <Reward Name>"));
            }
        } else if (args[0].equalsIgnoreCase("schematic") && args.length == 2) {
            if (Minecraft.func_71410_x().func_71356_B()) {
                if (sender instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)sender;
                    if (player.field_71075_bZ.field_75098_d) {
                        if (args[1].equalsIgnoreCase("create")) {
                            if (RenderEvent.isCreatingSchematic()) {
                                if (SchematicUtil.selectionPoints[0] != null && SchematicUtil.selectionPoints[1] != null) {
                                    FMLCommonHandler.instance().showGuiScreen((Object)new SchematicCreationGui(player));
                                } else {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("Please set both points before moving on!"));
                                }
                            } else {
                                RenderEvent.setCreatingSchematic(true);
                            }
                        } else if (args[1].equalsIgnoreCase("cancel")) {
                            RenderEvent.setCreatingSchematic(false);
                            SchematicUtil.selectionPoints[0] = null;
                            SchematicUtil.selectionPoints[1] = null;
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Sorry, you need to be in creative to use this command"));
                    }
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Sorry, but this command only works in single player"));
            }
        } else if (args[0].equalsIgnoreCase("rewardsInfo")) {
            int defaultEnabled = 0;
            int giantEnabled = 0;
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                List<PlayerRewardInfo> defaultrewards = GlobalCCRewardRegistry.DEFAULT.getPlayerRewardRegistry(player.func_110124_au().toString()).getPlayersRewards();
                List<PlayerRewardInfo> giantrewards = GlobalCCRewardRegistry.GIANT.getPlayerRewardRegistry(player.func_110124_au().toString()).getPlayersRewards();
                defaultEnabled = defaultrewards.size();
                giantEnabled = giantrewards.size();
                if (args.length > 1 && args[1].equalsIgnoreCase("list")) {
                    if (args.length > 2 && args[2].equalsIgnoreCase("default")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("===DEFAULT REWARDS==="));
                        for (PlayerRewardInfo reward : defaultrewards) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(reward.reward.getName()));
                        }
                    } else if (args.length > 2 && args[2].equalsIgnoreCase("giant")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("===GIANT REWARDS==="));
                        for (PlayerRewardInfo reward : giantrewards) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(reward.reward.getName()));
                        }
                    } else if (args.length > 2 && args[2].equalsIgnoreCase("defaultall")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("===DEFAULT REWARDS==="));
                        for (String reward : GlobalCCRewardRegistry.DEFAULT.getRewardNames()) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(reward));
                        }
                    } else if (args.length > 2 && args[2].equalsIgnoreCase("giantall")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("===GIANT REWARDS==="));
                        for (String reward : GlobalCCRewardRegistry.GIANT.getRewardNames()) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(reward));
                        }
                    } else if (args.length > 2 && args[2].equalsIgnoreCase("defaultdisabled")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("===DEFAULT REWARDS DISABLED==="));
                        ArrayList<String> playerRewards = new ArrayList<String>();
                        for (PlayerRewardInfo playerRewardInfo : defaultrewards) {
                            playerRewards.add(playerRewardInfo.reward.getName());
                        }
                        for (String string : GlobalCCRewardRegistry.DEFAULT.getRewardNames()) {
                            if (playerRewards.contains(string)) continue;
                            sender.func_145747_a((ITextComponent)new TextComponentString(string));
                        }
                    } else if (args.length > 2 && args[2].equalsIgnoreCase("giantdisabled")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("===GIANT REWARDS DISABLED==="));
                        ArrayList<String> playerRewards = new ArrayList<String>();
                        for (PlayerRewardInfo playerRewardInfo : giantrewards) {
                            playerRewards.add(playerRewardInfo.reward.getName());
                        }
                        for (String string : GlobalCCRewardRegistry.GIANT.getRewardNames()) {
                            if (playerRewards.contains(string)) continue;
                            sender.func_145747_a((ITextComponent)new TextComponentString(string));
                        }
                    }
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("There are currently " + GlobalCCRewardRegistry.DEFAULT.getNumberOfLoadedRewards() + " regular rewards loaded and you have " + defaultEnabled + " rewards enabled"));
            sender.func_145747_a((ITextComponent)new TextComponentString("There are currently " + GlobalCCRewardRegistry.GIANT.getNumberOfLoadedRewards() + " giant rewards loaded and you have " + giantEnabled + " rewards enabled"));
        } else if (args[0].equalsIgnoreCase("testRewards")) {
            CCubesSettings.testRewards = !CCubesSettings.testRewards;
            CCubesSettings.testingRewardIndex = 0;
            if (CCubesSettings.testRewards) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Reward testing is now enabled for all rewards!"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Reward testing is now disabled and normal randomness is back."));
            }
        } else if (args[0].equalsIgnoreCase("testCustomRewards")) {
            CCubesSettings.testCustomRewards = !CCubesSettings.testCustomRewards;
            CCubesSettings.testingRewardIndex = 0;
            if (CCubesSettings.testCustomRewards) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Reward testing is now enabled for custom rewards!"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Reward testing is now disabled and normal randomness is back."));
            }
        } else if (!args[0].equalsIgnoreCase("test")) {
            if (args[0].equalsIgnoreCase("spawnGiantCube")) {
                if (args.length < 4) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid arguments! Try /chancecubes spawnGiantCube <x> <y> <z> (NOTE: You may use ~ with offsets)"));
                    return;
                }
                BlockPos pos = CCubesServerCommands.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false);
                World world = sender.func_130014_f_();
                if (RewardsUtil.isBlockUnbreakable(world, pos.func_177982_a(0, 0, 0)) && CCubesSettings.nonReplaceableBlocks.contains(world.func_180495_p(pos.func_177982_a(0, 0, 0)))) {
                    return;
                }
                GiantCubeUtil.setupStructure(pos.func_177982_a(-1, -1, -1), world, true);
                world.func_184133_a(null, pos, CCubesSounds.GIANT_CUBE_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (args[0].equalsIgnoreCase("enableProfile")) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Temporarily removed!"));
            } else if (args[0].equalsIgnoreCase("disableProfile")) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Temporarily removed!"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid arguments for the Chance Cubes command"));
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            if (server.func_71264_H()) {
                return true;
            }
            GameProfile profile = ((EntityPlayer)sender).func_146103_bH();
            if (server.func_184103_al().func_152596_g(profile)) {
                UserListOpsEntry userlistopsentry = (UserListOpsEntry)server.func_184103_al().func_152603_m().func_152683_b((Object)profile);
                return userlistopsentry != null && userlistopsentry.func_152644_a() >= 2;
            }
            return false;
        }
        return false;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return this.tab;
        }
        if (args.length > 1) {
            if (args[0].equalsIgnoreCase("disableReward")) {
                return new ArrayList<String>(GlobalCCRewardRegistry.DEFAULT.getRewardNames());
            }
            if (args[0].equalsIgnoreCase("enableReward")) {
                return new ArrayList<String>(GlobalCCRewardRegistry.DEFAULT.getRewardNames());
            }
            if (args[0].equalsIgnoreCase("schematic") && args.length == 2) {
                return Arrays.asList("create", "cancel");
            }
        }
        return Collections.emptyList();
    }
}

