/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class BossWitchReward
extends BossBaseReward {
    private List<Class<? extends Entity>> entities = Arrays.asList(EntityCreeper.class, EntitySkeleton.class, EntityBlaze.class, EntityEnderman.class, EntityEndermite.class, EntityPigZombie.class, EntitySilverfish.class, EntitySlime.class, EntitySpider.class, EntityZombie.class);

    public BossWitchReward() {
        super("evil_witch");
    }

    @Override
    public void spawnBoss(final World world, BlockPos pos, final EntityPlayer player, Map<String, Object> settings) {
        final EntityWitch witch = new EntityWitch(world);
        witch.func_96094_a("Evil Witch");
        witch.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        witch.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBossHealthDynamic(player, settings));
        witch.func_70606_j(witch.func_110138_aP());
        ItemStack stack = new ItemStack((Item)Items.field_151024_Q);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EntityEquipmentSlot.HEAD, stack);
        witch.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
        stack = new ItemStack((Item)Items.field_151027_R);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EntityEquipmentSlot.CHEST, stack);
        witch.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
        stack = new ItemStack((Item)Items.field_151026_S);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EntityEquipmentSlot.LEGS, stack);
        witch.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
        stack = new ItemStack((Item)Items.field_151021_T);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EntityEquipmentSlot.FEET, stack);
        witch.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
        this.spawnMinoins(pos, world);
        Scheduler.scheduleTask(new Task("witch_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (witch.field_70128_L) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(15) == 4) {
                    BossWitchReward.this.spawnMinoins(witch.func_180425_c(), world);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossWitchReward.this.lightningStrike(player.func_180425_c(), world);
                }
                if (RewardsUtil.rand.nextInt(5) == 4) {
                    BossWitchReward.this.throwPotion(witch, player.func_180425_c(), world);
                }
            }
        });
        world.func_72838_d((Entity)witch);
        super.trackEntities(new Entity[]{witch});
        super.trackedPlayers(player);
    }

    private void lightningStrike(BlockPos playerPos, World world) {
        world.func_72942_c((Entity)new EntityLightningBolt(world, (double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), false));
    }

    private void throwPotion(EntityWitch witch, BlockPos playerPos, World world) {
        PotionType potionType = (PotionType)PotionType.field_185176_a.func_148754_a(RewardsUtil.rand.nextInt(PotionType.field_185176_a.func_148742_b().size()));
        EntityPotion pot = new EntityPotion(world, (EntityLivingBase)witch, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potionType));
        double d0 = (double)playerPos.func_177956_o() + 0.5;
        double d1 = (double)playerPos.func_177958_n() - witch.field_70165_t;
        double d2 = d0 - pot.field_70163_u;
        double d3 = (double)playerPos.func_177952_p() - witch.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        pot.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        world.func_72838_d((Entity)pot);
    }

    private void spawnMinoins(BlockPos pos, World world) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) continue;
            try {
                Entity ent = this.entities.get(RewardsUtil.rand.nextInt(this.entities.size())).getConstructor(World.class).newInstance(world);
                BlockPos adjPos = pos.func_177972_a(facing);
                ent.func_70107_b((double)adjPos.func_177958_n(), (double)adjPos.func_177956_o(), (double)adjPos.func_177952_p());
                world.func_72838_d(ent);
                this.trackSubEntities(ent);
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "Uh oh! Something went wrong and the minions could not be spawned! Please report this to the mod dev!");
                return;
            }
        }
    }

    @Override
    public void onBossFightEnd(World world, BlockPos pos, EntityPlayer player) {
    }
}

