/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import uk.kihira.tails.client.gui.GuiEditor;
import uk.kihira.tails.client.texture.TextureHelper;
import uk.kihira.tails.common.Tails;
import uk.kihira.tails.common.network.PlayerDataMessage;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    private boolean sentPartInfoToServer = false;
    private boolean clearAllPartInfo = false;

    @SubscribeEvent
    public void onScreenInitPost(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiIngameMenu) {
            event.getButtonList().add(new GuiButton(1234, event.getGui().field_146294_l / 2 - 35, event.getGui().field_146295_m - 25, 70, 20, I18n.func_135052_a((String)"gui.button.editor", (Object[])new Object[0])));
        }
    }

    @SubscribeEvent
    public void onButtonClickPre(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getGui() instanceof GuiIngameMenu && event.getButton().field_146127_k == 1234) {
            event.getGui().field_146297_k.func_147108_a((GuiScreen)new GuiEditor());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onConnectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (Tails.localPartsData != null) {
            Tails.proxy.addPartsData(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId(), Tails.localPartsData);
        }
    }

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        Tails.hasRemote = false;
        this.sentPartInfoToServer = false;
        this.clearAllPartInfo = true;
        Tails.instance.loadConfig();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.START && TextureHelper.needsBuild(e.player) && e.player instanceof AbstractClientPlayer) {
            TextureHelper.buildPlayerPartsData((AbstractClientPlayer)e.player);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            if (this.clearAllPartInfo) {
                Tails.proxy.clearAllPartsData();
                this.clearAllPartInfo = false;
            } else if (!this.sentPartInfoToServer && Minecraft.func_71410_x().field_71441_e != null) {
                Tails.networkWrapper.sendToServer((IMessage)new PlayerDataMessage(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId(), Tails.localPartsData, false));
                this.sentPartInfoToServer = true;
            }
        }
    }
}

