/*
 * Decompiled with CFR 0.152.
 */
package cubex2.ttfr;

import com.google.common.collect.Maps;
import cubex2.ttfr.IBFFontRenderer;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    private static final String[] LOGICAL_FONTS = new String[]{"Serif", "SansSerif", "Dialog", "DialogInput", "Monospaced"};
    private static final Font[] ALL_FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    private static final String[] ALL_FONT_NAMES = Config.getAllFontNames();
    public static Configuration cfg;
    private static String fontName;
    private static int fontSize;
    private static boolean antiAlias;
    private static boolean dropShadow;

    public static void load(File file) {
        cfg = new Configuration(file);
        Config.syncConfig();
    }

    private static void syncConfig() {
        Property fontNameProp = cfg.get("general", "fontName", "SansSerif", "Valid font names: " + Arrays.toString(ALL_FONT_NAMES));
        fontName = fontNameProp.getString();
        fontSize = cfg.getInt("fontSize", "general", 18, 1, 100, "The font's size");
        antiAlias = cfg.getBoolean("antiAlias", "general", false, "Whether to use anti-aliasing");
        dropShadow = cfg.getBoolean("dropShadow", "general", true, "Setting this to \"false\" will disable drop shadows completely");
        fontNameProp.setConfigEntryClass(SelectFontEntry.class);
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("betterfonts")) {
            Config.syncConfig();
            IBFFontRenderer font = (IBFFontRenderer)FMLClientHandler.instance().getClient().field_71466_p;
            Config.applyFont(font);
        }
    }

    public static void applyFont(IBFFontRenderer font) {
        font.setDropShadowEnabled(dropShadow);
        if (fontName == null || fontName.isEmpty()) {
            font.getStringRenderer().getCache().setDefaultFont("SansSerif", 18, false);
        } else {
            font.getStringRenderer().getCache().setDefaultFont(Config.getActualFontName(fontName), fontSize, antiAlias);
        }
    }

    private static String[] getAllFontNames() {
        String[] names = new String[ALL_FONTS.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ALL_FONTS[i].getName();
        }
        return names;
    }

    private static String getActualFontName(String fontName) {
        String searchName = fontName.replaceAll("[- ]", "").toLowerCase();
        for (String font : LOGICAL_FONTS) {
            if (font.compareToIgnoreCase(searchName) != 0) continue;
            return font;
        }
        String altSearchName = searchName + " medium";
        String partialMatch = null;
        for (Font font : ALL_FONTS) {
            String name = font.getName().replaceAll("[- ]", "");
            if (name.compareToIgnoreCase(searchName) == 0 || name.compareToIgnoreCase(altSearchName) == 0) {
                return font.getName();
            }
            if (!(name + font.getFamily()).replaceAll("[- ]", "").toLowerCase().contains(searchName) || partialMatch != null && partialMatch.length() <= font.getName().length()) continue;
            partialMatch = font.getName();
        }
        if (partialMatch != null) {
            return partialMatch;
        }
        System.out.println("Invalid font. Using " + fontName + " instead");
        return fontName;
    }

    public static class SelectFontEntry
    extends GuiConfigEntries.SelectValueEntry {
        public SelectFontEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement, SelectFontEntry.getValues());
        }

        private static Map<Object, String> getValues() {
            HashMap values = Maps.newHashMap();
            for (String name : ALL_FONT_NAMES) {
                values.put(name, name);
            }
            return values;
        }
    }
}

