/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client;

import com.mrcrayfish.furniture.handler.ConfigurationHandler;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;

public class DownloadUtils {
    @Nullable
    public static URI createUri(String url) {
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static boolean isValidScheme(URI uri) {
        String scheme = uri.getScheme();
        return scheme != null && (scheme.equals("http") || scheme.equals("https"));
    }

    public static boolean isValidType(URI uri, String ... types) {
        if (uri.getPath() == null) {
            return false;
        }
        boolean supported = false;
        for (String type : types) {
            if (!uri.getPath().endsWith("." + type)) continue;
            supported = true;
            break;
        }
        return supported;
    }

    public static boolean isTrustedDomain(URI uri) {
        String domain = uri.getHost();
        if (domain == null) {
            return false;
        }
        if (domain.startsWith("www.")) {
            domain = domain.substring(4);
        }
        boolean trusted = false;
        for (String trustedDomain : ConfigurationHandler.trustedUrlDomains) {
            if (!domain.equals(trustedDomain)) continue;
            trusted = true;
            break;
        }
        return trusted;
    }
}

