/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.integration.crafttweaker.helpers;

import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.integration.crafttweaker.CraftTweakerIntegration;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.Collection;
import javax.annotation.Nonnull;
import stanhebben.zenscript.annotations.Optional;

public class OneToOneRecipes {
    protected final String name;
    protected final Collection<RecipeData> recipes;

    public OneToOneRecipes(String name, Collection<RecipeData> recipes) {
        this.name = name;
        this.recipes = recipes;
    }

    public void remove(@Optional IIngredient output, @Optional IIngredient input) {
        if (output == null) {
            output = IngredientAny.INSTANCE;
        }
        if (input == null) {
            input = IngredientAny.INSTANCE;
        }
        IIngredient finalOutput = output;
        IIngredient finalInput = input;
        CraftTweakerIntegration.defer("Remove recipe(s) matching " + output + " given " + input + " from " + this.name, () -> {
            if (!this.recipes.removeIf(data -> {
                if (finalOutput.matchesExact((IItemStack)new MCItemStack(data.getOutput())) && finalInput.matchesExact((IItemStack)new MCItemStack(data.getInput()))) {
                    CraftTweakerAPI.logInfo((String)(this.name + ": Removed recipe " + data));
                    return true;
                }
                return false;
            })) {
                CraftTweakerAPI.logError((String)(this.name + ": No recipe matched"));
            }
        });
    }

    public void addRecipe(@Nonnull IItemStack output, @Nonnull IItemStack input) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null");
        }
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        RecipeData data = new RecipeData();
        data.setOutput(CraftTweakerMC.getItemStack((IItemStack)output));
        data.setInput(CraftTweakerMC.getItemStack((IItemStack)input));
        CraftTweakerIntegration.defer("Add recipe " + data + " to " + this.name, () -> {
            this.recipes.add(data);
            CraftTweakerAPI.logInfo((String)(this.name + ": Added recipe " + data));
        });
    }
}

