/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.value;

import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.HashVariables;
import mod.lucky.drop.value.ValueParser;
import net.minecraft.nbt.NBTTagCompound;

public class DropValue {
    private String rawValue = null;
    private Object value = null;
    private Class valueType;
    private boolean needsInitialize = false;

    public DropValue(Object value) {
        this.value = value;
    }

    public DropValue(String rawValue, Class valueType) {
        this.valueType = valueType;
        this.rawValue = rawValue;
        if (HashVariables.containsHashVariables(rawValue)) {
            this.needsInitialize = true;
        } else {
            try {
                this.value = ValueParser.getObject(rawValue, valueType, null);
            }
            catch (Exception e) {
                System.err.println("Lucky Block: Error processing value: " + this.rawValue);
                e.printStackTrace();
            }
        }
    }

    public boolean initialize(DropProcessData processData) {
        if (this.needsInitialize) {
            try {
                this.value = ValueParser.getObject(this.rawValue, this.valueType, processData);
                return true;
            }
            catch (Exception e) {
                System.err.println("Lucky Block: Error processing value: " + this.rawValue);
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean needsInitialize() {
        return this.needsInitialize;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public Object getValue() {
        return this.value;
    }

    public int getValueInt() {
        return (Integer)this.value;
    }

    public String getValueString() {
        return (String)this.value;
    }

    public boolean getValueBoolean() {
        return (Boolean)this.value;
    }

    public float getValueFloat() {
        return ((Float)this.value).floatValue();
    }

    public NBTTagCompound getValueNBT() {
        return (NBTTagCompound)this.value;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound mainTag = new NBTTagCompound();
        if (this.value != null) {
            mainTag.func_74782_a("value", ValueParser.getNBTBaseFromValue(this.value));
        }
        if (this.rawValue != null) {
            mainTag.func_74778_a("rawValue", this.rawValue);
        }
        if (this.valueType != null) {
            mainTag.func_74778_a("valueType", (String)ValueParser.classTypeToString.inverse().get((Object)this.valueType));
        }
        mainTag.func_74757_a("needsInitialize", this.needsInitialize);
        return mainTag;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("value")) {
            this.value = ValueParser.getValueFromNBTBase(tagCompound.func_74781_a("value"));
        }
        if (tagCompound.func_74764_b("rawValue")) {
            this.rawValue = tagCompound.func_74779_i("rawValue");
        }
        if (tagCompound.func_74764_b("valueType")) {
            this.valueType = (Class)ValueParser.classTypeToString.get((Object)tagCompound.func_74779_i("valueType"));
        }
        this.needsInitialize = tagCompound.func_74767_n("needsInitialize");
    }

    public DropValue copy() {
        DropValue dropValue = new DropValue(this.value);
        dropValue.rawValue = this.rawValue;
        dropValue.valueType = this.valueType;
        dropValue.needsInitialize = this.needsInitialize;
        return dropValue;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        if (this.rawValue != null) {
            return this.rawValue;
        }
        return "error";
    }
}

