/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.com.naef.jnlua;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import li.cil.repack.com.naef.jnlua.Converter;
import li.cil.repack.com.naef.jnlua.JavaFunction;
import li.cil.repack.com.naef.jnlua.JavaReflector;
import li.cil.repack.com.naef.jnlua.LuaRuntimeException;
import li.cil.repack.com.naef.jnlua.LuaState;
import li.cil.repack.com.naef.jnlua.LuaType;
import li.cil.repack.com.naef.jnlua.LuaValueProxy;
import li.cil.repack.com.naef.jnlua.NamedJavaFunction;
import li.cil.repack.com.naef.jnlua.TypedJavaObject;

public class DefaultJavaReflector
implements JavaReflector {
    private static final DefaultJavaReflector INSTANCE = new DefaultJavaReflector();
    private static final Object JAVA_FUNCTION_TYPE = new Object();
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private Map<Class<?>, Map<String, Accessor>> accessors = new HashMap();
    private ReadWriteLock accessorLock = new ReentrantReadWriteLock();
    private Map<LuaCallSignature, Invocable> invocableDispatches = new HashMap<LuaCallSignature, Invocable>();
    private ReadWriteLock invocableDispatchLock = new ReentrantReadWriteLock();
    private JavaFunction index = new Index();
    private JavaFunction newIndex = new NewIndex();
    private JavaFunction equal = new Equal();
    private JavaFunction length = new Length();
    private JavaFunction lessThan = new LessThan();
    private JavaFunction lessThanOrEqual = new LessThanOrEqual();
    private JavaFunction toString = new ToString();
    private JavaFunction pairs = new Pairs();
    private JavaFunction ipairs = new IPairs();
    private JavaFunction javaFields = new AccessorPairs(FieldAccessor.class);
    private JavaFunction javaMethods = new AccessorPairs(InvocableAccessor.class);
    private JavaFunction javaProperties = new AccessorPairs(PropertyAccessor.class);

    public static DefaultJavaReflector getInstance() {
        return INSTANCE;
    }

    private DefaultJavaReflector() {
    }

    @Override
    public JavaFunction getMetamethod(JavaReflector.Metamethod metamethod) {
        switch (metamethod) {
            case INDEX: {
                return this.index;
            }
            case NEWINDEX: {
                return this.newIndex;
            }
            case LEN: {
                return this.length;
            }
            case EQ: {
                return this.equal;
            }
            case LT: {
                return this.lessThan;
            }
            case LE: {
                return this.lessThanOrEqual;
            }
            case TOSTRING: {
                return this.toString;
            }
            case PAIRS: {
                return this.pairs;
            }
            case IPAIRS: {
                return this.ipairs;
            }
            case JAVAFIELDS: {
                return this.javaFields;
            }
            case JAVAMETHODS: {
                return this.javaMethods;
            }
            case JAVAPROPERTIES: {
                return this.javaProperties;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Accessor> getObjectAccessors(Object object) {
        Map<String, Accessor> result2;
        Class<?> clazz = this.getObjectClass(object);
        this.accessorLock.readLock().lock();
        try {
            result2 = this.accessors.get(clazz);
            if (result2 != null) {
                Map<String, Accessor> map = result2;
                return map;
            }
        }
        finally {
            this.accessorLock.readLock().unlock();
        }
        result2 = this.createClassAccessors(clazz);
        this.accessorLock.writeLock().lock();
        try {
            if (!this.accessors.containsKey(clazz)) {
                this.accessors.put(clazz, result2);
            } else {
                result2 = this.accessors.get(clazz);
            }
        }
        finally {
            this.accessorLock.writeLock().unlock();
        }
        return result2;
    }

    private Map<String, Accessor> createClassAccessors(Class<?> clazz) {
        BeanInfo beanInfo;
        HashMap<String, Accessor> result2 = new HashMap<String, Accessor>();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            result2.put(fields[i].getName(), new FieldAccessor(fields[i]));
        }
        HashMap accessibleMethods = new HashMap();
        Method[] methods2 = clazz.getMethods();
        for (int i = 0; i < methods2.length; ++i) {
            List<Class<?>> parameterTypes;
            Invocable currentInvocable;
            Method method = methods2[i];
            if (result2.containsKey(method.getName()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) && (method = this.getPublicClassMethod(clazz, method.getName(), method.getParameterTypes())) == null) continue;
            HashMap overloaded = (HashMap)accessibleMethods.get(method.getName());
            if (overloaded == null) {
                overloaded = new HashMap();
                accessibleMethods.put(method.getName(), overloaded);
            }
            if ((currentInvocable = (Invocable)overloaded.get(parameterTypes = Arrays.asList(method.getParameterTypes()))) != null && method.getDeclaringClass().isAssignableFrom(currentInvocable.getDeclaringClass())) continue;
            overloaded.put(parameterTypes, new InvocableMethod(method));
        }
        for (Map.Entry entry : accessibleMethods.entrySet()) {
            result2.put((String)entry.getKey(), new InvocableAccessor(clazz, ((Map)entry.getValue()).values()));
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        ArrayList<Invocable> accessibleConstructors = new ArrayList<Invocable>(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            if (!Modifier.isPublic(constructors[i].getDeclaringClass().getModifiers())) continue;
            accessibleConstructors.add(new InvocableConstructor(constructors[i]));
        }
        if (clazz.isInterface()) {
            accessibleConstructors.add(new InvocableProxy(clazz));
        }
        if (!accessibleConstructors.isEmpty()) {
            result2.put("new", new InvocableAccessor(clazz, accessibleConstructors));
        }
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            if (result2.containsKey(propertyDescriptors[i].getName())) continue;
            Method method = propertyDescriptors[i].getReadMethod();
            if (method != null && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method = this.getPublicClassMethod(clazz, method.getName(), method.getParameterTypes());
                try {
                    propertyDescriptors[i].setReadMethod(method);
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
            if ((method = propertyDescriptors[i].getWriteMethod()) != null && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method = this.getPublicClassMethod(clazz, method.getName(), method.getParameterTypes());
                try {
                    propertyDescriptors[i].setWriteMethod(method);
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
            if (propertyDescriptors[i].getReadMethod() == null && propertyDescriptors[i].getWriteMethod() == null) continue;
            result2.put(propertyDescriptors[i].getName(), new PropertyAccessor(clazz, propertyDescriptors[i]));
        }
        return result2;
    }

    private Method getPublicClassMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        Method method = this.getPublicSuperclassMethod(clazz, methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        return this.getInterfaceMethod(clazz, methodName, parameterTypes);
    }

    private Method getPublicSuperclassMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (!Modifier.isPublic(superclass.getModifiers())) continue;
            try {
                Method method = superclass.getDeclaredMethod(methodName, parameterTypes);
                if (!Modifier.isPublic(method.getModifiers())) continue;
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private Method getInterfaceMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        do {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                try {
                    return interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = this.getInterfaceMethod(interfaces[i], methodName, parameterTypes);
                    if (method == null) continue;
                    return method;
                }
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    private Class<?> getObjectClass(Object object) {
        return object instanceof Class ? (Class<?>)object : object.getClass();
    }

    private class Index
    implements JavaFunction {
        private Index() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object = luaState.toJavaObject(1, Object.class);
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            if (objectClass.isArray()) {
                if (!luaState.isNumber(2)) {
                    throw new LuaRuntimeException(String.format("attempt to read array with %s accessor", luaState.typeName(2)));
                }
                long index = luaState.toInteger(2);
                int length = Array.getLength(object);
                if (index < 1L || index > (long)length) {
                    throw new LuaRuntimeException(String.format("attempt to read array of length %d at index %d", length, index));
                }
                luaState.pushJavaObject(Array.get(object, (int)(index - 1L)));
                return 1;
            }
            Map objectAccessors = DefaultJavaReflector.this.getObjectAccessors(object);
            String key = luaState.toString(-1);
            if (key == null) {
                throw new LuaRuntimeException(String.format("attempt to read class %s with %s accessor", object.getClass().getCanonicalName(), luaState.typeName(-1)));
            }
            Accessor accessor = (Accessor)objectAccessors.get(key);
            if (accessor == null) {
                throw new LuaRuntimeException(String.format("attempt to read class %s with accessor '%s' (undefined)", objectClass.getCanonicalName(), key));
            }
            accessor.read(luaState, object);
            return 1;
        }
    }

    private class NewIndex
    implements JavaFunction {
        private NewIndex() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object = luaState.toJavaObject(1, Object.class);
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            if (objectClass.isArray()) {
                if (!luaState.isNumber(2)) {
                    throw new LuaRuntimeException(String.format("attempt to write array with %s accessor", luaState.typeName(2)));
                }
                long index = luaState.toInteger(2);
                int length = Array.getLength(object);
                if (index < 1L || index > (long)length) {
                    throw new LuaRuntimeException(String.format("attempt to write array of length %d at index %d", length, index));
                }
                Class<?> componentType = objectClass.getComponentType();
                if (!luaState.isJavaObject(3, componentType)) {
                    throw new LuaRuntimeException(String.format("attempt to write array of %s at index %d with %s value", componentType.getCanonicalName(), luaState.typeName(3)));
                }
                Object value = luaState.toJavaObject(3, componentType);
                Array.set(object, (int)(index - 1L), value);
                return 0;
            }
            Map objectAccessors = DefaultJavaReflector.this.getObjectAccessors(object);
            String key = luaState.toString(2);
            if (key == null) {
                throw new LuaRuntimeException(String.format("attempt to write class %s with %s accessor", object.getClass().getCanonicalName(), luaState.typeName(2)));
            }
            Accessor accessor = (Accessor)objectAccessors.get(key);
            if (accessor == null) {
                throw new LuaRuntimeException(String.format("attempt to write class %s with accessor '%s' (undefined)", objectClass.getCanonicalName(), key));
            }
            accessor.write(luaState, object);
            return 0;
        }
    }

    private class Equal
    implements JavaFunction {
        private Equal() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object2;
            Object object1 = luaState.toJavaObject(1, Object.class);
            luaState.pushBoolean(object1 == (object2 = luaState.toJavaObject(2, Object.class)) || object1 != null && object1.equals(object2));
            return 1;
        }
    }

    private class Length
    implements JavaFunction {
        private Length() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object = luaState.toJavaObject(1, Object.class);
            if (object.getClass().isArray()) {
                luaState.pushInteger(Array.getLength(object));
                return 1;
            }
            luaState.pushInteger(0L);
            return 1;
        }
    }

    private class LessThan
    implements JavaFunction {
        private LessThan() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object;
            if (!luaState.isJavaObject(1, Comparable.class)) {
                throw new LuaRuntimeException(String.format("class %s does not implement Comparable", luaState.typeName(1)));
            }
            Comparable comparable = luaState.toJavaObject(1, Comparable.class);
            luaState.pushBoolean(comparable.compareTo(object = luaState.toJavaObject(2, Object.class)) < 0);
            return 1;
        }
    }

    private class LessThanOrEqual
    implements JavaFunction {
        private LessThanOrEqual() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object;
            if (!luaState.isJavaObject(1, Comparable.class)) {
                throw new LuaRuntimeException(String.format("class %s does not implement Comparable", luaState.typeName(1)));
            }
            Comparable comparable = luaState.toJavaObject(1, Comparable.class);
            luaState.pushBoolean(comparable.compareTo(object = luaState.toJavaObject(2, Object.class)) <= 0);
            return 1;
        }
    }

    private class ToString
    implements JavaFunction {
        private ToString() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object = luaState.toJavaObject(1, Object.class);
            luaState.pushString(object != null ? object.toString() : "null");
            return 1;
        }
    }

    private static class Pairs
    implements NamedJavaFunction {
        private final JavaFunction navigableMapNext = new NavigableMapNext();

        private Pairs() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Map map = luaState.checkJavaObject(1, Map.class);
            luaState.checkArg(1, map != null, String.format("expected map, got %s", luaState.typeName(1)));
            if (map instanceof NavigableMap) {
                luaState.pushJavaFunction(this.navigableMapNext);
            } else {
                luaState.pushJavaFunction(new MapNext(map.entrySet().iterator()));
            }
            luaState.pushJavaObject(map);
            luaState.pushNil();
            return 3;
        }

        @Override
        public String getName() {
            return "pairs";
        }

        private static class NavigableMapNext
        implements JavaFunction {
            private NavigableMapNext() {
            }

            @Override
            public int invoke(LuaState luaState) {
                NavigableMap navigableMap = luaState.checkJavaObject(1, NavigableMap.class);
                Object key = luaState.checkJavaObject(2, Object.class);
                Map.Entry entry = key != null ? navigableMap.higherEntry(key) : navigableMap.firstEntry();
                if (entry != null) {
                    luaState.pushJavaObject(entry.getKey());
                    luaState.pushJavaObject(entry.getValue());
                    return 2;
                }
                luaState.pushNil();
                return 1;
            }
        }

        private static class MapNext
        implements JavaFunction {
            private Iterator<Map.Entry<Object, Object>> iterator;

            public MapNext(Iterator<Map.Entry<Object, Object>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public int invoke(LuaState luaState) {
                if (this.iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = this.iterator.next();
                    luaState.pushJavaObject(entry.getKey());
                    luaState.pushJavaObject(entry.getValue());
                    return 2;
                }
                luaState.pushNil();
                return 1;
            }
        }
    }

    private static class IPairs
    implements NamedJavaFunction {
        private final JavaFunction listNext = new ListNext();
        private final JavaFunction arrayNext = new ArrayNext();

        private IPairs() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object;
            if (luaState.isJavaObject(1, List.class)) {
                object = luaState.toJavaObject(1, List.class);
                luaState.pushJavaFunction(this.listNext);
            } else {
                object = luaState.checkJavaObject(1, Object.class);
                luaState.checkArg(1, object.getClass().isArray(), String.format("expected list or array, got %s", luaState.typeName(1)));
                luaState.pushJavaFunction(this.arrayNext);
            }
            luaState.pushJavaObject(object);
            luaState.pushInteger(0L);
            return 3;
        }

        @Override
        public String getName() {
            return "ipairs";
        }

        private static class ListNext
        implements JavaFunction {
            private ListNext() {
            }

            @Override
            public int invoke(LuaState luaState) {
                List list2 = luaState.checkJavaObject(1, List.class);
                int size2 = list2.size();
                long index = luaState.checkInteger(2);
                if (++index >= 1L && index <= (long)size2) {
                    luaState.pushInteger(index);
                    luaState.pushJavaObject(list2.get((int)(index - 1L)));
                    return 2;
                }
                luaState.pushNil();
                return 1;
            }
        }

        private static class ArrayNext
        implements JavaFunction {
            private ArrayNext() {
            }

            @Override
            public int invoke(LuaState luaState) {
                Object array = luaState.checkJavaObject(1, Object.class);
                int length = Array.getLength(array);
                long index = luaState.checkInteger(2);
                if (++index >= 1L && index <= (long)length) {
                    luaState.pushInteger(index);
                    luaState.pushJavaObject(Array.get(array, (int)(index - 1L)));
                    return 2;
                }
                luaState.pushNil();
                return 1;
            }
        }
    }

    private class AccessorPairs
    implements JavaFunction {
        private Class<?> accessorClass;

        public AccessorPairs(Class<?> accessorClass) {
            this.accessorClass = accessorClass;
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object = luaState.toJavaObject(1, Object.class);
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            Map objectAccessors = DefaultJavaReflector.this.getObjectAccessors(object);
            Iterator<Map.Entry<String, Accessor>> iterator = objectAccessors.entrySet().iterator();
            luaState.pushJavaObject(new AccessorNext(iterator, objectClass == object));
            luaState.pushJavaObject(object);
            luaState.pushNil();
            return 3;
        }

        private class AccessorNext
        implements JavaFunction {
            private Iterator<Map.Entry<String, Accessor>> iterator;
            private boolean isStatic;

            public AccessorNext(Iterator<Map.Entry<String, Accessor>> iterator, boolean isStatic) {
                this.iterator = iterator;
                this.isStatic = isStatic;
            }

            @Override
            public int invoke(LuaState luaState) {
                while (this.iterator.hasNext()) {
                    Map.Entry<String, Accessor> entry = this.iterator.next();
                    Accessor accessor = entry.getValue();
                    if (accessor.getClass() != AccessorPairs.this.accessorClass || (this.isStatic ? !accessor.isStatic() : !accessor.isNotStatic())) continue;
                    luaState.pushString(entry.getKey());
                    Object object = luaState.toJavaObject(1, Object.class);
                    accessor.read(luaState, object);
                    return 2;
                }
                return 0;
            }
        }
    }

    private class FieldAccessor
    implements Accessor {
        private Field field;

        public FieldAccessor(Field field) {
            this.field = field;
        }

        @Override
        public void read(LuaState luaState, Object object) {
            try {
                Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
                if (objectClass == object) {
                    object = null;
                }
                luaState.pushJavaObject(this.field.get(object));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(LuaState luaState, Object object) {
            try {
                Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
                if (objectClass == object) {
                    object = null;
                }
                Object value = luaState.checkJavaObject(-1, this.field.getType());
                this.field.set(object, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isNotStatic() {
            return !Modifier.isStatic(this.field.getModifiers());
        }

        @Override
        public boolean isStatic() {
            return Modifier.isStatic(this.field.getModifiers());
        }
    }

    private class InvocableAccessor
    implements Accessor,
    JavaFunction {
        private Class<?> clazz;
        private List<Invocable> invocables;

        public InvocableAccessor(Class<?> clazz, Collection<Invocable> invocables) {
            this.clazz = clazz;
            this.invocables = new ArrayList<Invocable>(invocables);
        }

        public String getName() {
            return this.invocables.get(0).getName();
        }

        public String getWhat() {
            return this.invocables.get(0).getWhat();
        }

        @Override
        public void read(LuaState luaState, Object object) {
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            if (objectClass == object) {
                object = null;
            }
            luaState.pushJavaFunction(this);
        }

        @Override
        public void write(LuaState luaState, Object object) {
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            throw new LuaRuntimeException(String.format("attempt to write class %s with accessor '%s' (a %s)", objectClass.getCanonicalName(), this.getName(), this.getWhat()));
        }

        @Override
        public boolean isNotStatic() {
            for (Invocable invocable : this.invocables) {
                if (Modifier.isStatic(invocable.getModifiers())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isStatic() {
            for (Invocable invocable : this.invocables) {
                if (!Modifier.isStatic(invocable.getModifiers())) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int invoke(LuaState luaState) {
            Object result2;
            int i;
            Invocable invocable;
            Object object = luaState.checkJavaObject(1, Object.class);
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            luaState.checkArg(1, this.clazz.isAssignableFrom(objectClass), String.format("class %s is not a subclass of %s", objectClass.getCanonicalName(), this.clazz.getCanonicalName()));
            if (objectClass == object) {
                object = null;
            }
            LuaCallSignature luaCallSignature = this.getLuaCallSignature(luaState);
            DefaultJavaReflector.this.invocableDispatchLock.readLock().lock();
            try {
                invocable = (Invocable)DefaultJavaReflector.this.invocableDispatches.get(luaCallSignature);
            }
            finally {
                DefaultJavaReflector.this.invocableDispatchLock.readLock().unlock();
            }
            if (invocable == null) {
                invocable = this.dispatchInvocable(luaState, object == null);
                DefaultJavaReflector.this.invocableDispatchLock.writeLock().lock();
                try {
                    if (!DefaultJavaReflector.this.invocableDispatches.containsKey(luaCallSignature)) {
                        DefaultJavaReflector.this.invocableDispatches.put(luaCallSignature, invocable);
                    } else {
                        invocable = (Invocable)DefaultJavaReflector.this.invocableDispatches.get(luaCallSignature);
                    }
                }
                finally {
                    DefaultJavaReflector.this.invocableDispatchLock.writeLock().unlock();
                }
            }
            int argCount = luaState.getTop() - 1;
            int parameterCount = invocable.getParameterCount();
            Object[] arguments = new Object[parameterCount];
            if (invocable.isVarArgs()) {
                for (i = 0; i < parameterCount - 1; ++i) {
                    arguments[i] = luaState.toJavaObject(i + 2, invocable.getParameterType(i));
                }
                arguments[parameterCount - 1] = Array.newInstance(invocable.getParameterType(parameterCount - 1), argCount - (parameterCount - 1));
                for (i = parameterCount - 1; i < argCount; ++i) {
                    Array.set(arguments[parameterCount - 1], i - (parameterCount - 1), luaState.toJavaObject(i + 2, invocable.getParameterType(i)));
                }
            } else {
                for (i = 0; i < parameterCount; ++i) {
                    arguments[i] = luaState.toJavaObject(i + 2, invocable.getParameterType(i));
                }
            }
            try {
                result2 = invocable.invoke(object, arguments);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            if (invocable.getReturnType() != Void.TYPE) {
                if (invocable.isRawReturn()) {
                    luaState.pushJavaObjectRaw(result2);
                } else {
                    luaState.pushJavaObject(result2);
                }
                return 1;
            }
            return 0;
        }

        private LuaCallSignature getLuaCallSignature(LuaState luaState) {
            int argCount = luaState.getTop() - 1;
            Object[] types = new Object[argCount];
            block4: for (int i = 0; i < argCount; ++i) {
                LuaType type2 = luaState.type(i + 2);
                switch (type2) {
                    case FUNCTION: {
                        types[i] = luaState.isJavaFunction(i + 2) ? JAVA_FUNCTION_TYPE : LuaType.FUNCTION;
                        continue block4;
                    }
                    case USERDATA: {
                        if (luaState.isJavaObjectRaw(i + 2)) {
                            Object object = luaState.toJavaObjectRaw(i + 2);
                            if (object instanceof TypedJavaObject) {
                                types[i] = ((TypedJavaObject)object).getType();
                                continue block4;
                            }
                            types[i] = object.getClass();
                            continue block4;
                        }
                        types[i] = LuaType.USERDATA;
                        continue block4;
                    }
                    default: {
                        types[i] = type2;
                    }
                }
            }
            return new LuaCallSignature(this.clazz, this.getName(), types);
        }

        private Invocable dispatchInvocable(LuaState luaState, boolean staticDispatch) {
            int j;
            boolean delta;
            int parameterCount;
            Iterator i;
            HashSet<Invocable> candidates = new HashSet<Invocable>(this.invocables);
            Iterator i2 = candidates.iterator();
            while (i2.hasNext()) {
                Invocable invocable = (Invocable)i2.next();
                if (Modifier.isStatic(invocable.getModifiers()) == staticDispatch) continue;
                i2.remove();
            }
            int argCount = luaState.getTop() - 1;
            Iterator i3 = candidates.iterator();
            while (i3.hasNext()) {
                Invocable invocable = (Invocable)i3.next();
                if (invocable.isVarArgs()) {
                    if (argCount >= invocable.getParameterCount() - 1) continue;
                    i3.remove();
                    continue;
                }
                if (argCount == invocable.getParameterCount()) continue;
                i3.remove();
            }
            Converter converter = luaState.getConverter();
            Iterator i4 = candidates.iterator();
            block2: while (i4.hasNext()) {
                Invocable invocable = (Invocable)i4.next();
                for (int j2 = 0; j2 < argCount; ++j2) {
                    int distance = converter.getTypeDistance(luaState, j2 + 2, invocable.getParameterType(j2));
                    if (distance != Integer.MAX_VALUE) continue;
                    i4.remove();
                    continue block2;
                }
            }
            boolean haveFixArgs = false;
            boolean haveVarArgs = false;
            for (Invocable invocable : candidates) {
                haveFixArgs = haveFixArgs || !invocable.isVarArgs();
                haveVarArgs = haveVarArgs || invocable.isVarArgs();
            }
            if (haveVarArgs && haveFixArgs) {
                i = candidates.iterator();
                while (i.hasNext()) {
                    Invocable invocable = (Invocable)i.next();
                    if (!invocable.isVarArgs()) continue;
                    i.remove();
                }
            }
            i = candidates.iterator();
            block6: while (i.hasNext()) {
                Invocable invocable = (Invocable)i.next();
                block7: for (Invocable other : candidates) {
                    if (other == invocable) continue;
                    parameterCount = Math.min(argCount, Math.max(invocable.getParameterCount(), other.getParameterCount()));
                    delta = false;
                    for (j = 0; j < parameterCount; ++j) {
                        int distance = converter.getTypeDistance(luaState, j + 2, invocable.getParameterType(j));
                        int otherDistance = converter.getTypeDistance(luaState, j + 2, other.getParameterType(j));
                        if (otherDistance > distance) continue block7;
                        delta = delta || distance != otherDistance;
                    }
                    if (!delta) continue;
                    i.remove();
                    continue block6;
                }
            }
            i = candidates.iterator();
            block9: while (i.hasNext()) {
                Invocable invocable = (Invocable)i.next();
                block10: for (Invocable other : candidates) {
                    if (other == invocable) continue;
                    parameterCount = Math.min(argCount, Math.max(invocable.getParameterCount(), other.getParameterCount()));
                    delta = false;
                    for (j = 0; j < parameterCount; ++j) {
                        Class<?> otherType;
                        Class<?> type2 = invocable.getParameterType(j);
                        if (!type2.isAssignableFrom(otherType = other.getParameterType(j))) continue block10;
                        delta = delta || type2 != otherType;
                    }
                    if (!delta) continue;
                    i.remove();
                    continue block9;
                }
            }
            if (candidates.isEmpty()) {
                throw this.getSignatureMismatchException(luaState);
            }
            if (candidates.size() > 1) {
                throw this.getSignatureAmbivalenceException(luaState, candidates);
            }
            return (Invocable)candidates.iterator().next();
        }

        private LuaRuntimeException getSignatureMismatchException(LuaState luaState) {
            return new LuaRuntimeException(String.format("no %s of class %s matches '%s(%s)'", this.getWhat(), this.clazz.getCanonicalName(), this.getName(), this.getLuaSignatureString(luaState)));
        }

        private LuaRuntimeException getSignatureAmbivalenceException(LuaState luaState, Set<Invocable> candidates) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%s '%s(%s)' on class %s is ambivalent among ", this.getWhat(), this.getName(), this.getLuaSignatureString(luaState), this.clazz.getCanonicalName()));
            boolean first = true;
            for (Invocable invocable : candidates) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(String.format("'%s(%s)'", this.getName(), this.getJavaSignatureString(invocable.getParameterTypes())));
            }
            return new LuaRuntimeException(sb.toString());
        }

        private String getLuaSignatureString(LuaState luaState) {
            int argCount = luaState.getTop() - 1;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < argCount; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(luaState.typeName(i + 2));
            }
            return sb.toString();
        }

        private String getJavaSignatureString(Class<?>[] types) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(types[i].getCanonicalName());
            }
            return sb.toString();
        }
    }

    private class PropertyAccessor
    implements Accessor {
        private Class<?> clazz;
        private PropertyDescriptor propertyDescriptor;

        public PropertyAccessor(Class<?> clazz, PropertyDescriptor propertyDescriptor) {
            this.clazz = clazz;
            this.propertyDescriptor = propertyDescriptor;
        }

        @Override
        public void read(LuaState luaState, Object object) {
            if (this.propertyDescriptor.getReadMethod() == null) {
                throw new LuaRuntimeException(String.format("attempt to read class %s with accessor '%s' (a write-only property)", this.clazz.getCanonicalName(), this.propertyDescriptor.getName()));
            }
            try {
                luaState.pushJavaObject(this.propertyDescriptor.getReadMethod().invoke(object, EMPTY_ARGUMENTS));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
        }

        @Override
        public void write(LuaState luaState, Object object) {
            if (this.propertyDescriptor.getWriteMethod() == null) {
                throw new LuaRuntimeException(String.format("attempt to write class %s with acessor '%s' (a read-only property)", this.clazz.getCanonicalName(), this.propertyDescriptor.getName()));
            }
            try {
                Object value = luaState.checkJavaObject(-1, this.propertyDescriptor.getPropertyType());
                this.propertyDescriptor.getWriteMethod().invoke(object, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            luaState.pop(1);
        }

        @Override
        public boolean isNotStatic() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }
    }

    private static interface Invocable {
        public String getWhat();

        public Class<?> getDeclaringClass();

        public int getModifiers();

        public String getName();

        public Class<?> getReturnType();

        public boolean isRawReturn();

        public int getParameterCount();

        public Class<?>[] getParameterTypes();

        public Class<?> getParameterType(int var1);

        public boolean isVarArgs();

        public Object invoke(Object var1, Object ... var2) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;
    }

    private static class InvocableMethod
    implements Invocable {
        private Method method;
        private Class<?>[] parameterTypes;

        public InvocableMethod(Method method) {
            this.method = method;
            this.parameterTypes = method.getParameterTypes();
        }

        @Override
        public String getWhat() {
            return "method";
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public boolean isRawReturn() {
            return false;
        }

        @Override
        public int getParameterCount() {
            return this.parameterTypes.length;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public Class<?> getParameterType(int index) {
            if (this.method.isVarArgs() && index >= this.parameterTypes.length - 1) {
                return this.parameterTypes[this.parameterTypes.length - 1].getComponentType();
            }
            return this.parameterTypes[index];
        }

        @Override
        public boolean isVarArgs() {
            return this.method.isVarArgs();
        }

        @Override
        public Object invoke(Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.method.invoke(obj, args);
        }

        public String toString() {
            return this.method.toString();
        }
    }

    private static class InvocableConstructor
    implements Invocable {
        private Constructor<?> constructor;
        private Class<?>[] parameterTypes;

        public InvocableConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
            this.parameterTypes = constructor.getParameterTypes();
        }

        @Override
        public String getWhat() {
            return "constructor";
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.constructor.getDeclaringClass();
        }

        @Override
        public int getModifiers() {
            return this.constructor.getModifiers() | 8;
        }

        @Override
        public String getName() {
            return "new";
        }

        @Override
        public Class<?> getReturnType() {
            return this.constructor.getDeclaringClass();
        }

        @Override
        public boolean isRawReturn() {
            return false;
        }

        @Override
        public int getParameterCount() {
            return this.parameterTypes.length;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public Class<?> getParameterType(int index) {
            if (this.constructor.isVarArgs() && index >= this.parameterTypes.length - 1) {
                return this.parameterTypes[this.parameterTypes.length - 1].getComponentType();
            }
            return this.parameterTypes[index];
        }

        @Override
        public boolean isVarArgs() {
            return this.constructor.isVarArgs();
        }

        @Override
        public Object invoke(Object obj, Object ... args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.constructor.newInstance(args);
        }

        public String toString() {
            return this.constructor.toString();
        }
    }

    private static class InvocableProxy
    implements Invocable {
        private static final Class<?>[] PARAMETER_TYPES = new Class[]{LuaValueProxy.class};
        private Class<?> interfaze;

        public InvocableProxy(Class<?> interfaze) {
            this.interfaze = interfaze;
        }

        @Override
        public String getWhat() {
            return "proxy";
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.interfaze;
        }

        @Override
        public int getModifiers() {
            return this.interfaze.getModifiers() | 8;
        }

        @Override
        public String getName() {
            return "new";
        }

        @Override
        public Class<?> getReturnType() {
            return this.interfaze;
        }

        @Override
        public boolean isRawReturn() {
            return true;
        }

        @Override
        public int getParameterCount() {
            return 1;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return PARAMETER_TYPES;
        }

        @Override
        public Class<?> getParameterType(int index) {
            return PARAMETER_TYPES[0];
        }

        @Override
        public boolean isVarArgs() {
            return false;
        }

        @Override
        public Object invoke(Object obj, Object ... args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            LuaValueProxy luaValueProxy = (LuaValueProxy)args[0];
            luaValueProxy.pushValue();
            Object proxy = luaValueProxy.getLuaState().getProxy(-1, this.interfaze);
            luaValueProxy.getLuaState().pop(1);
            return proxy;
        }

        public String toString() {
            return this.interfaze.toString();
        }
    }

    private static class LuaCallSignature {
        private Class<?> clazz;
        private String invocableName;
        private Object[] types;
        private int hashCode;

        public LuaCallSignature(Class<?> clazz, String invocableName, Object[] types) {
            this.clazz = clazz;
            this.invocableName = invocableName;
            this.types = types;
            this.hashCode = clazz.hashCode();
            this.hashCode = this.hashCode * 65599 + invocableName.hashCode();
            for (int i = 0; i < types.length; ++i) {
                this.hashCode = this.hashCode * 65599 + types[i].hashCode();
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LuaCallSignature)) {
                return false;
            }
            LuaCallSignature other = (LuaCallSignature)obj;
            if (this.clazz != other.clazz || !this.invocableName.equals(other.invocableName) || this.types.length != other.types.length) {
                return false;
            }
            for (int i = 0; i < this.types.length; ++i) {
                if (this.types[i] == other.types[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.clazz.getCanonicalName() + ": " + this.invocableName + "(" + Arrays.asList(this.types) + ")";
        }
    }

    private static interface Accessor {
        public void read(LuaState var1, Object var2);

        public void write(LuaState var1, Object var2);

        public boolean isNotStatic();

        public boolean isStatic();
    }
}

