/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.JustEnoughItems;
import mezz.jei.network.packets.PacketCheatPermission;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.GiveMode;
import mezz.jei.util.Log;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.ItemHandlerHelper;

public final class CommandUtilServer {
    private CommandUtilServer() {
    }

    public static String[] getGiveCommandParameters(EntityPlayer sender, ItemStack itemStack, int amount) {
        String senderName = sender.func_70005_c_();
        Item item = itemStack.func_77973_b();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        if (itemResourceLocation == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("item.getRegistryName() returned null for: " + stackInfo);
        }
        ArrayList<String> commandStrings = new ArrayList<String>();
        commandStrings.add(senderName);
        commandStrings.add(itemResourceLocation.toString());
        commandStrings.add(String.valueOf(amount));
        commandStrings.add(String.valueOf(itemStack.func_77960_j()));
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            commandStrings.add(tagCompound.toString());
        }
        return commandStrings.toArray(new String[0]);
    }

    public static void writeChatMessage(EntityPlayer player, String translationKey, TextFormatting color) {
        TextComponentTranslation component = new TextComponentTranslation(translationKey, new Object[0]);
        component.func_150256_b().func_150238_a(color);
        player.func_145747_a((ITextComponent)component);
    }

    public static boolean hasPermission(EntityPlayerMP sender, ItemStack itemStack) {
        if (sender.func_184812_l_()) {
            return true;
        }
        MinecraftServer minecraftServer = sender.field_71133_b;
        ICommand giveCommand = CommandUtilServer.getGiveCommand(sender);
        if (giveCommand != null && giveCommand.func_184882_a(minecraftServer, (ICommandSender)sender)) {
            String[] commandParameters = CommandUtilServer.getGiveCommandParameters((EntityPlayer)sender, itemStack, itemStack.func_190916_E());
            CommandEvent event = new CommandEvent(giveCommand, (ICommandSender)sender, commandParameters);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                Throwable exception = event.getException();
                if (exception != null) {
                    Throwables.throwIfUnchecked((Throwable)exception);
                }
                return false;
            }
            return true;
        }
        return sender.func_70003_b(minecraftServer.func_110455_j(), "give");
    }

    public static void executeGive(EntityPlayerMP sender, ItemStack itemStack, GiveMode giveMode) {
        if (CommandUtilServer.hasPermission(sender, itemStack)) {
            if (giveMode == GiveMode.INVENTORY) {
                CommandUtilServer.giveToInventory(sender, itemStack);
            } else if (giveMode == GiveMode.MOUSE_PICKUP) {
                CommandUtilServer.mousePickupItemStack((EntityPlayer)sender, itemStack);
            }
        } else {
            JustEnoughItems.getProxy().sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void setHotbarSlot(EntityPlayerMP sender, ItemStack itemStack, int hotbarSlot) {
        if (CommandUtilServer.hasPermission(sender, itemStack)) {
            if (!InventoryPlayer.func_184435_e((int)hotbarSlot)) {
                Log.get().error("Tried to set slot that is not in the hotbar: {}", (Object)hotbarSlot);
                return;
            }
            ItemStack stackInSlot = sender.field_71071_by.func_70301_a(hotbarSlot);
            if (ItemStack.func_77989_b((ItemStack)stackInSlot, (ItemStack)itemStack)) {
                return;
            }
            int count = itemStack.func_190916_E();
            ItemStack originalStack = itemStack.func_77946_l();
            sender.field_71071_by.func_70299_a(hotbarSlot, itemStack);
            sender.field_70170_p.func_184148_a(null, sender.field_70165_t, sender.field_70163_u, sender.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((sender.func_70681_au().nextFloat() - sender.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            sender.field_71069_bz.func_75142_b();
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, count);
            CommandUtilServer.notifyGive(sender, originalStack, count);
        } else {
            JustEnoughItems.getProxy().sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void mousePickupItemStack(EntityPlayer sender, ItemStack itemStack) {
        int giveCount;
        ItemStack existingStack = sender.field_71071_by.func_70445_o();
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)existingStack, (ItemStack)itemStack)) {
            int newCount = Math.min(existingStack.func_77976_d(), existingStack.func_190916_E() + itemStack.func_190916_E());
            giveCount = newCount - existingStack.func_190916_E();
            existingStack.func_190920_e(newCount);
        } else {
            sender.field_71071_by.func_70437_b(itemStack);
            giveCount = itemStack.func_190916_E();
        }
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)sender;
            CommandUtilServer.notifyGive(playerMP, itemStack, giveCount);
            playerMP.func_71113_k();
        }
    }

    private static void giveToInventory(EntityPlayerMP sender, ItemStack itemStack) {
        int count = itemStack.func_190916_E();
        ItemStack originalStack = itemStack.func_77946_l();
        boolean addedToInventory = sender.field_71071_by.func_70441_a(itemStack);
        if (addedToInventory) {
            sender.field_70170_p.func_184148_a(null, sender.field_70165_t, sender.field_70163_u, sender.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((sender.func_70681_au().nextFloat() - sender.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            sender.field_71069_bz.func_75142_b();
        }
        if (addedToInventory && itemStack.func_190926_b()) {
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, count);
        } else {
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, count - itemStack.func_190916_E());
            EntityItem entityitem = sender.func_71019_a(itemStack, false);
            if (entityitem != null) {
                entityitem.func_174868_q();
                entityitem.func_145797_a(sender.func_70005_c_());
            }
        }
        CommandUtilServer.notifyGive(sender, originalStack, count);
    }

    private static void notifyGive(EntityPlayerMP sender, ItemStack itemStack, int count) {
        ICommand giveCommand;
        if (!sender.func_184812_l_() && count > 0 && (giveCommand = CommandUtilServer.getGiveCommand(sender)) != null) {
            ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1);
            CommandBase.func_152373_a((ICommandSender)sender, (ICommand)giveCommand, (String)"commands.give.success", (Object[])new Object[]{copy.func_151000_E(), count, sender.func_70005_c_()});
        }
    }

    @Nullable
    private static ICommand getGiveCommand(EntityPlayerMP sender) {
        MinecraftServer minecraftServer = sender.field_71133_b;
        ICommandManager commandManager = minecraftServer.func_71187_D();
        Map commands = commandManager.func_71555_a();
        return (ICommand)commands.get("give");
    }
}

