/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.app;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.Image;
import com.mrcrayfish.device.api.app.component.ItemList;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.api.app.component.Text;
import com.mrcrayfish.device.api.app.component.TextField;
import com.mrcrayfish.device.api.app.listener.ClickListener;
import com.mrcrayfish.device.api.app.renderer.ListItemRenderer;
import com.mrcrayfish.device.api.io.File;
import com.mrcrayfish.device.api.print.IPrint;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.Wrappable;
import com.mrcrayfish.device.core.io.FileSystem;
import com.mrcrayfish.device.core.network.NetworkDevice;
import com.mrcrayfish.device.core.network.task.TaskGetDevices;
import com.mrcrayfish.device.core.print.task.TaskPrint;
import com.mrcrayfish.device.programs.system.component.FileBrowser;
import com.mrcrayfish.device.programs.system.object.ColorScheme;
import com.mrcrayfish.device.tileentity.TileEntityPrinter;
import com.mrcrayfish.device.util.GLHelper;
import java.awt.Color;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public abstract class Dialog
extends Wrappable {
    private String title = "Message";
    private int width;
    private int height;
    protected final Layout defaultLayout = new Layout(150, 40);
    private Layout customLayout;
    private boolean pendingLayoutUpdate = true;
    private boolean pendingClose = false;

    protected final void addComponent(Component c) {
        if (c != null) {
            this.defaultLayout.addComponent(c);
            c.init(this.defaultLayout);
        }
    }

    protected final void setLayout(Layout layout) {
        this.customLayout = layout;
        this.width = layout.width;
        this.height = layout.height;
        this.pendingLayoutUpdate = true;
        this.customLayout.handleLoad();
    }

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.defaultLayout.clear();
        this.setLayout(this.defaultLayout);
    }

    @Override
    public void onTick() {
        if (this.pendingClose && this.getWindow().getDialogWindow() == null) {
            this.getWindow().close();
        }
        this.customLayout.handleTick();
    }

    @Override
    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean active, float partialTicks) {
        GL11.glEnable((int)3089);
        GLHelper.pushScissor(x, y, this.width, this.height);
        this.customLayout.render(laptop, mc, x, y, mouseX, mouseY, active, partialTicks);
        GLHelper.popScissor();
        GL11.glDisable((int)3089);
        this.customLayout.renderOverlay(laptop, mc, mouseX, mouseY, active);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        this.customLayout.handleMouseClick(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        this.customLayout.handleMouseDrag(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        this.customLayout.handleMouseRelease(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseScroll(int mouseX, int mouseY, boolean direction) {
        this.customLayout.handleMouseScroll(mouseX, mouseY, direction);
    }

    @Override
    public void handleKeyTyped(char character, int code) {
        this.customLayout.handleKeyTyped(character, code);
    }

    @Override
    public void handleKeyReleased(char character, int code) {
        this.customLayout.handleKeyReleased(character, code);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getWindowTitle() {
        return this.title;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void markForLayoutUpdate() {
        this.pendingLayoutUpdate = true;
    }

    @Override
    public boolean isPendingLayoutUpdate() {
        return this.pendingLayoutUpdate;
    }

    @Override
    public void clearPendingLayout() {
        this.pendingLayoutUpdate = false;
    }

    @Override
    public void updateComponents(int x, int y) {
        this.customLayout.updateComponents(x, y);
    }

    @Override
    public void onClose() {
    }

    public void close() {
        this.pendingClose = true;
    }

    public static interface ResponseHandler<E> {
        public boolean onResponse(boolean var1, E var2);
    }

    public static class Print
    extends Dialog {
        private final IPrint print;
        private Layout layoutMain;
        private Label labelMessage;
        private Button buttonRefresh;
        private ItemList<NetworkDevice> itemListPrinters;
        private Button buttonPrint;
        private Button buttonCancel;
        private Button buttonInfo;

        public Print(IPrint print) {
            this.print = print;
            this.setTitle("Print");
        }

        @Override
        public void init(@Nullable NBTTagCompound intent) {
            super.init(intent);
            this.layoutMain = new Layout(150, 132);
            this.labelMessage = new Label("Select a Printer", 5, 5);
            this.layoutMain.addComponent(this.labelMessage);
            this.buttonRefresh = new Button(131, 2, Icons.RELOAD);
            this.buttonRefresh.setPadding(2);
            this.buttonRefresh.setToolTip("Refresh", "Retrieve an updated list of printers");
            this.buttonRefresh.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.itemListPrinters.setSelectedIndex(-1);
                    this.getPrinters(this.itemListPrinters);
                }
            });
            this.layoutMain.addComponent(this.buttonRefresh);
            this.itemListPrinters = new ItemList(5, 18, 140, 5);
            this.itemListPrinters.setListItemRenderer(new ListItemRenderer<NetworkDevice>(16){

                @Override
                public void render(NetworkDevice networkDevice, Gui gui, Minecraft mc, int x, int y, int width, int height, boolean selected) {
                    ColorScheme colorScheme = Laptop.getSystem().getSettings().getColorScheme();
                    Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)(selected ? colorScheme.getItemHighlightColor() : colorScheme.getItemBackgroundColor()));
                    Icons.PRINTER.draw(mc, x + 3, y + 3);
                    RenderUtil.drawStringClipped(networkDevice.getName(), x + 18, y + 4, 118, Laptop.getSystem().getSettings().getColorScheme().getTextColor(), true);
                }
            });
            this.itemListPrinters.setItemClickListener((blockPos, index, mouseButton) -> {
                if (mouseButton == 0) {
                    this.buttonPrint.setEnabled(true);
                    this.buttonInfo.setEnabled(true);
                }
            });
            this.itemListPrinters.sortBy((o1, o2) -> {
                BlockPos laptopPos = Laptop.getPos();
                BlockPos pos1 = o1.getPos();
                double distance1 = laptopPos.func_177957_d((double)pos1.func_177958_n() + 0.5, (double)pos1.func_177956_o() + 0.5, (double)pos1.func_177952_p() + 0.5);
                BlockPos pos2 = o2.getPos();
                double distance2 = laptopPos.func_177957_d((double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
                return distance2 < distance1 ? 1 : (distance1 == distance2 ? 0 : -1);
            });
            this.layoutMain.addComponent(this.itemListPrinters);
            this.buttonPrint = new Button(98, 108, "Print", Icons.CHECK);
            this.buttonPrint.setPadding(5);
            this.buttonPrint.setEnabled(false);
            this.buttonPrint.setClickListener((mouseX, mouseY, mouseButton) -> {
                NetworkDevice networkDevice;
                if (mouseButton == 0 && (networkDevice = this.itemListPrinters.getSelectedItem()) != null) {
                    TaskPrint task = new TaskPrint(Laptop.getPos(), networkDevice, this.print);
                    task.setCallback((nbtTagCompound, success) -> {
                        if (success) {
                            this.close();
                        }
                    });
                    TaskManager.sendTask(task);
                }
            });
            this.layoutMain.addComponent(this.buttonPrint);
            this.buttonCancel = new Button(74, 108, Icons.CROSS);
            this.buttonCancel.setPadding(5);
            this.buttonCancel.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.close();
                }
            });
            this.layoutMain.addComponent(this.buttonCancel);
            this.buttonInfo = new Button(5, 108, Icons.HELP);
            this.buttonInfo.setEnabled(false);
            this.buttonInfo.setPadding(5);
            this.buttonInfo.setClickListener((mouseX, mouseY, mouseButton) -> {
                NetworkDevice printerEntry;
                if (mouseButton == 0 && (printerEntry = this.itemListPrinters.getSelectedItem()) != null) {
                    Info info = new Info(printerEntry);
                    this.openDialog(info);
                }
            });
            this.layoutMain.addComponent(this.buttonInfo);
            this.setLayout(this.layoutMain);
            this.getPrinters(this.itemListPrinters);
        }

        private void getPrinters(ItemList<NetworkDevice> itemList) {
            itemList.removeAll();
            itemList.setLoading(true);
            TaskGetDevices task = new TaskGetDevices(Laptop.getPos(), TileEntityPrinter.class);
            task.setCallback((tagCompound, success) -> {
                if (success) {
                    NBTTagList tagList = tagCompound.func_150295_c("network_devices", 10);
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        itemList.addItem(NetworkDevice.fromTag(tagList.func_150305_b(i)));
                    }
                    itemList.setLoading(false);
                }
            });
            TaskManager.sendTask(task);
        }

        private static class Info
        extends Dialog {
            private final NetworkDevice entry;
            private Layout layoutMain;
            private Label labelName;
            private Image imagePaper;
            private Label labelPaper;
            private Label labelPosition;
            private Button buttonClose;

            private Info(NetworkDevice entry) {
                this.entry = entry;
                this.setTitle("Details");
            }

            @Override
            public void init(@Nullable NBTTagCompound intent) {
                super.init(intent);
                this.layoutMain = new Layout(120, 70);
                this.labelName = new Label(TextFormatting.GOLD.toString() + TextFormatting.BOLD.toString() + this.entry.getName(), 5, 5);
                this.layoutMain.addComponent(this.labelName);
                this.labelPaper = new Label(TextFormatting.DARK_GRAY + "Paper: " + TextFormatting.RESET + Integer.toString(0), 5, 18);
                this.labelPaper.setAlignment(0);
                this.labelPaper.setShadow(false);
                this.layoutMain.addComponent(this.labelPaper);
                String position = TextFormatting.DARK_GRAY + "X: " + TextFormatting.RESET + this.entry.getPos().func_177958_n() + " " + TextFormatting.DARK_GRAY + "Y: " + TextFormatting.RESET + this.entry.getPos().func_177956_o() + " " + TextFormatting.DARK_GRAY + "Z: " + TextFormatting.RESET + this.entry.getPos().func_177952_p();
                this.labelPosition = new Label(position, 5, 30);
                this.labelPosition.setShadow(false);
                this.layoutMain.addComponent(this.labelPosition);
                this.buttonClose = new Button(5, 49, "Close");
                this.buttonClose.setClickListener((mouseX, mouseY, mouseButton) -> {
                    if (mouseButton == 0) {
                        this.close();
                    }
                });
                this.layoutMain.addComponent(this.buttonClose);
                this.setLayout(this.layoutMain);
            }
        }
    }

    public static class SaveFile
    extends Dialog {
        private final Application app;
        private String name;
        private NBTTagCompound data;
        private String positiveText = "Save";
        private String negativeText = "Cancel";
        private Layout main;
        private FileBrowser browser;
        private TextField textFieldFileName;
        private Button buttonPositive;
        private Button buttonNegative;
        public ResponseHandler<File> responseHandler;
        private Predicate<File> filter;
        private String path = "/Home";

        public SaveFile(Application app, NBTTagCompound data) {
            this.app = app;
            this.data = data;
            this.setTitle("Save File");
        }

        public SaveFile(Application app, File file) {
            this.app = app;
            this.name = file.getName();
            this.data = file.toTag();
            this.setTitle("Save File");
        }

        @Override
        public void init(@Nullable NBTTagCompound intent) {
            super.init(intent);
            this.main = new Layout(211, 145);
            this.browser = new FileBrowser(0, 0, this.app, FileBrowser.Mode.BASIC);
            this.browser.setFilter((File file) -> this.filter == null || this.filter.test((File)file) || file.isFolder());
            this.browser.openFolder(this.path);
            this.main.addComponent(this.browser);
            this.buttonPositive = new Button(172, 125, this.positiveText);
            this.buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0 && !this.textFieldFileName.getText().isEmpty()) {
                    if (!FileSystem.PATTERN_FILE_NAME.matcher(this.textFieldFileName.getText()).matches()) {
                        Message dialog = new Message("File name may only contain letters, numbers, underscores and spaces.");
                        this.app.openDialog(dialog);
                        return;
                    }
                    File file = this.name != null ? File.fromTag(this.textFieldFileName.getText(), this.data) : new File(this.textFieldFileName.getText(), this.app, this.data.func_74737_b());
                    this.browser.addFile(file, (response, success) -> {
                        if (response.getStatus() == 4) {
                            Confirmation dialog = new Confirmation("A file with that name already exists. Are you sure you want to override it?");
                            dialog.setPositiveText("Override");
                            dialog.setPositiveListener((mouseX1, mouseY1, mouseButton1) -> this.browser.addFile(file, true, (response1, success1) -> {
                                dialog.close();
                                if (this.responseHandler != null) {
                                    this.responseHandler.onResponse(success1, file);
                                }
                                this.close();
                            }));
                            this.app.openDialog(dialog);
                        } else {
                            if (this.responseHandler != null) {
                                this.responseHandler.onResponse(true, file);
                            }
                            this.close();
                        }
                    });
                }
            });
            this.main.addComponent(this.buttonPositive);
            this.buttonNegative = new Button(126, 125, this.negativeText);
            this.buttonNegative.setClickListener((mouseX, mouseY, mouseButton) -> this.close());
            this.main.addComponent(this.buttonNegative);
            this.textFieldFileName = new TextField(26, 105, 180);
            this.textFieldFileName.setFocused(true);
            if (this.name != null) {
                this.textFieldFileName.setText(this.name);
            }
            this.main.addComponent(this.textFieldFileName);
            this.setLayout(this.main);
        }

        public void setPositiveText(@Nonnull String positiveText) {
            if (positiveText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.positiveText = positiveText;
        }

        public void setNegativeText(@Nonnull String negativeText) {
            if (negativeText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.negativeText = negativeText;
        }

        public void setResponseHandler(ResponseHandler<File> responseHandler) {
            this.responseHandler = responseHandler;
        }

        public void setFilter(Predicate<File> filter) {
            this.filter = filter;
        }

        public void setFilter(Application app) {
            this.filter = file -> app.getInfo().getFormattedId().equals(file.getOpeningApp());
        }

        public void setFolder(String path) {
            this.path = path;
        }
    }

    public static class OpenFile
    extends Dialog {
        private final Application app;
        private String positiveText = "Open";
        private String negativeText = "Cancel";
        private Layout main;
        private FileBrowser browser;
        private Button buttonPositive;
        private Button buttonNegative;
        private ResponseHandler<File> responseListener;
        private Predicate<File> filter;

        public OpenFile(Application app) {
            this.app = app;
            this.setTitle("Open File");
        }

        @Override
        public void init(@Nullable NBTTagCompound intent) {
            super.init(intent);
            this.main = new Layout(211, 126);
            this.browser = new FileBrowser(0, 0, this.app, FileBrowser.Mode.BASIC);
            this.browser.openFolder("/Home");
            this.browser.setFilter((File file) -> this.filter == null || this.filter.test((File)file) || file.isFolder());
            this.browser.setItemClickListener((file, index, mouseButton) -> {
                if (mouseButton == 0 && !file.isFolder()) {
                    this.buttonPositive.setEnabled(true);
                }
            });
            this.main.addComponent(this.browser);
            int positiveWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.positiveText);
            this.buttonPositive = new Button(172, 106, this.positiveText);
            this.buttonPositive.setSize(positiveWidth + 10, 16);
            this.buttonPositive.setEnabled(false);
            this.buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
                File file;
                if (mouseButton == 0 && (file = this.browser.getSelectedFile()) != null) {
                    boolean close = true;
                    if (this.responseListener != null) {
                        close = this.responseListener.onResponse(true, file);
                    }
                    if (close) {
                        this.close();
                    }
                }
            });
            this.main.addComponent(this.buttonPositive);
            int negativeWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.negativeText);
            this.buttonNegative = new Button(125, 106, this.negativeText);
            this.buttonNegative.setSize(negativeWidth + 10, 16);
            this.buttonNegative.setClickListener((mouseX, mouseY, mouseButton) -> this.close());
            this.main.addComponent(this.buttonNegative);
            this.setLayout(this.main);
        }

        public void setPositiveText(String positiveText) {
            if (positiveText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.positiveText = positiveText;
        }

        public void setNegativeText(String negativeText) {
            if (negativeText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.negativeText = negativeText;
        }

        public void setResponseHandler(ResponseHandler<File> responseListener) {
            this.responseListener = responseListener;
        }

        public void setFilter(Predicate<File> filter) {
            this.filter = filter;
        }

        public void setFilter(Application app) {
            this.filter = file -> app.getInfo().getFormattedId().equals(file.getOpeningApp());
        }
    }

    public static class Input
    extends Dialog {
        private static final int DIVIDE_WIDTH = 15;
        private String messageText = null;
        private String inputText = "";
        private String positiveText = "Okay";
        private String negativeText = "Cancel";
        private ResponseHandler<String> responseListener;
        private TextField textFieldInput;
        private Button buttonPositive;
        private Button buttonNegative;

        public Input() {
        }

        public Input(String messageText) {
            this.messageText = messageText;
        }

        @Override
        public void init(@Nullable NBTTagCompound intent) {
            super.init(intent);
            int offset = 0;
            if (this.messageText != null) {
                int lines = Minecraft.func_71410_x().field_71466_p.func_78271_c(this.messageText, this.getWidth() - 10).size();
                this.defaultLayout.height += lines * 9 + 10;
                offset += lines * 9 + 5;
            }
            super.init(intent);
            this.defaultLayout.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)Color.LIGHT_GRAY.getRGB()));
            if (this.messageText != null) {
                Text message = new Text(this.messageText, 5, 5, this.getWidth() - 10);
                this.addComponent(message);
            }
            this.textFieldInput = new TextField(5, 5 + offset, this.getWidth() - 10);
            this.textFieldInput.setText(this.inputText);
            this.textFieldInput.setFocused(true);
            this.addComponent(this.textFieldInput);
            int positiveWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.positiveText);
            this.buttonPositive = new Button(this.getWidth() - positiveWidth - 15, this.getHeight() - 20, this.positiveText);
            this.buttonPositive.setSize(positiveWidth + 10, 16);
            this.buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (!this.textFieldInput.getText().isEmpty()) {
                    boolean close = true;
                    if (this.responseListener != null) {
                        close = this.responseListener.onResponse(true, this.textFieldInput.getText().trim());
                    }
                    if (close) {
                        this.close();
                    }
                }
            });
            this.addComponent(this.buttonPositive);
            int negativeWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.negativeText);
            this.buttonNegative = new Button(this.getWidth() - 15 - positiveWidth - 15 - negativeWidth + 1, this.getHeight() - 20, this.negativeText);
            this.buttonNegative.setSize(negativeWidth + 10, 16);
            this.buttonNegative.setClickListener((mouseX, mouseY, mouseButton) -> this.close());
            this.addComponent(this.buttonNegative);
        }

        public void setInputText(@Nonnull String inputText) {
            if (inputText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.inputText = inputText;
        }

        @Nullable
        public TextField getTextFieldInput() {
            return this.textFieldInput;
        }

        public void setPositiveText(@Nonnull String positiveText) {
            if (positiveText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.positiveText = positiveText;
        }

        public void setNegativeText(@Nonnull String negativeText) {
            if (negativeText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.negativeText = negativeText;
        }

        public void setResponseHandler(ResponseHandler<String> responseListener) {
            this.responseListener = responseListener;
        }
    }

    public static class Confirmation
    extends Dialog {
        private static final int DIVIDE_WIDTH = 15;
        private String messageText = "Are you sure?";
        private String positiveText = "Yes";
        private String negativeText = "No";
        private ClickListener positiveListener;
        private ClickListener negativeListener;
        private Button buttonPositive;
        private Button buttonNegative;

        public Confirmation() {
        }

        public Confirmation(String messageText) {
            this.messageText = messageText;
        }

        @Override
        public void init(@Nullable NBTTagCompound intent) {
            super.init(intent);
            int lines = Minecraft.func_71410_x().field_71466_p.func_78271_c(this.messageText, this.getWidth() - 10).size();
            this.defaultLayout.height += (lines - 1) * 9;
            super.init(intent);
            this.defaultLayout.setBackground(new Layout.Background(){

                @Override
                public void render(Gui gui, Minecraft mc, int x, int y, int width, int height, int mouseX, int mouseY, boolean windowActive) {
                    Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)Color.LIGHT_GRAY.getRGB());
                }
            });
            Text message = new Text(this.messageText, 5, 5, this.getWidth() - 10);
            this.addComponent(message);
            int positiveWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.positiveText);
            this.buttonPositive = new Button(this.getWidth() - positiveWidth - 15, this.getHeight() - 20, this.positiveText);
            this.buttonPositive.setSize(positiveWidth + 10, 16);
            this.buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (this.positiveListener != null) {
                    this.positiveListener.onClick(mouseX, mouseY, mouseButton);
                }
                this.close();
            });
            this.addComponent(this.buttonPositive);
            int negativeWidth = Math.max(20, Minecraft.func_71410_x().field_71466_p.func_78256_a(this.negativeText));
            this.buttonNegative = new Button(this.getWidth() - 15 - positiveWidth - 15 - negativeWidth + 1, this.getHeight() - 20, this.negativeText);
            this.buttonNegative.setSize(negativeWidth + 10, 16);
            this.buttonNegative.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (this.negativeListener != null) {
                    this.negativeListener.onClick(mouseX, mouseY, mouseButton);
                }
                this.close();
            });
            this.addComponent(this.buttonNegative);
        }

        public void setPositiveText(@Nonnull String positiveText) {
            if (positiveText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.positiveText = positiveText;
        }

        public void setNegativeText(@Nonnull String negativeText) {
            if (negativeText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.negativeText = negativeText;
        }

        public void setPositiveListener(ClickListener positiveListener) {
            this.positiveListener = positiveListener;
        }

        public void setNegativeListener(ClickListener negativeListener) {
            this.negativeListener = negativeListener;
        }

        public void setMessageText(String messageText) {
            this.messageText = messageText;
        }
    }

    public static class Message
    extends Dialog {
        private String messageText = "";
        private ClickListener positiveListener;
        private Button buttonPositive;

        public Message(String messageText) {
            this.messageText = messageText;
        }

        @Override
        public void init(@Nullable NBTTagCompound intent) {
            super.init(intent);
            int lines = Minecraft.func_71410_x().field_71466_p.func_78271_c(this.messageText, this.getWidth() - 10).size();
            this.defaultLayout.height += (lines - 1) * 9;
            super.init(intent);
            this.defaultLayout.setBackground(new Layout.Background(){

                @Override
                public void render(Gui gui, Minecraft mc, int x, int y, int width, int height, int mouseX, int mouseY, boolean windowActive) {
                    Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)Color.LIGHT_GRAY.getRGB());
                }
            });
            Text message = new Text(this.messageText, 5, 5, this.getWidth() - 10);
            this.addComponent(message);
            this.buttonPositive = new Button(this.getWidth() - 41, this.getHeight() - 20, "Close");
            this.buttonPositive.setSize(36, 16);
            this.buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (this.positiveListener != null) {
                    this.positiveListener.onClick(mouseX, mouseY, mouseButton);
                }
                this.close();
            });
            this.addComponent(this.buttonPositive);
        }
    }
}

