/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.utils;

import com.mrcrayfish.device.api.task.Callback;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.programs.system.object.Account;
import com.mrcrayfish.device.programs.system.task.TaskAdd;
import com.mrcrayfish.device.programs.system.task.TaskGetBalance;
import com.mrcrayfish.device.programs.system.task.TaskPay;
import com.mrcrayfish.device.programs.system.task.TaskRemove;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BankUtil {
    public static final BankUtil INSTANCE = new BankUtil();
    private Map<UUID, Account> uuidToAccount = new HashMap<UUID, Account>();

    private BankUtil() {
    }

    public static void getBalance(Callback<NBTTagCompound> callback) {
        TaskManager.sendTask(new TaskGetBalance().setCallback(callback));
    }

    public static void pay(String uuid, int amount, Callback<NBTTagCompound> callback) {
        TaskManager.sendTask(new TaskPay().setCallback(callback));
    }

    public static void add(int amount, Callback<NBTTagCompound> callback) {
        TaskManager.sendTask(new TaskAdd(amount).setCallback(callback));
    }

    public static void remove(int amount, Callback<NBTTagCompound> callback) {
        TaskManager.sendTask(new TaskRemove(amount).setCallback(callback));
    }

    public Account getAccount(EntityPlayer player) {
        if (!this.uuidToAccount.containsKey(player.func_110124_au())) {
            this.uuidToAccount.put(player.func_110124_au(), new Account(0));
        }
        return this.uuidToAccount.get(player.func_110124_au());
    }

    public Account getAccount(UUID uuid) {
        return this.uuidToAccount.get(uuid);
    }

    public void save(NBTTagCompound tag) {
        NBTTagList accountList = new NBTTagList();
        for (UUID uuid : this.uuidToAccount.keySet()) {
            NBTTagCompound accountTag = new NBTTagCompound();
            Account account = this.uuidToAccount.get(uuid);
            accountTag.func_74778_a("uuid", uuid.toString());
            accountTag.func_74768_a("balance", account.getBalance());
            accountList.func_74742_a((NBTBase)accountTag);
        }
        tag.func_74782_a("accounts", (NBTBase)accountList);
    }

    public void load(NBTTagCompound tag) {
        NBTTagList accountList = (NBTTagList)tag.func_74781_a("accounts");
        for (int i = 0; i < accountList.func_74745_c(); ++i) {
            NBTTagCompound accountTag = accountList.func_150305_b(i);
            UUID uuid = UUID.fromString(accountTag.func_74779_i("uuid"));
            Account account = new Account(accountTag.func_74762_e("balance"));
            this.uuidToAccount.put(uuid, account);
        }
    }
}

