/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.io.task;

import com.mrcrayfish.device.api.io.Drive;
import com.mrcrayfish.device.api.io.Folder;
import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.io.FileSystem;
import com.mrcrayfish.device.core.io.drive.AbstractDrive;
import com.mrcrayfish.device.tileentity.TileEntityLaptop;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaskGetMainDrive
extends Task {
    private BlockPos pos;
    private AbstractDrive mainDrive;

    private TaskGetMainDrive() {
        super("get_main_drive");
    }

    public TaskGetMainDrive(BlockPos pos) {
        this();
        this.pos = pos;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        nbt.func_74772_a("pos", this.pos.func_177986_g());
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(BlockPos.func_177969_a((long)nbt.func_74763_f("pos")));
        if (tileEntity instanceof TileEntityLaptop) {
            TileEntityLaptop laptop = (TileEntityLaptop)tileEntity;
            FileSystem fileSystem = laptop.getFileSystem();
            this.mainDrive = fileSystem.getMainDrive();
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
        if (this.isSucessful()) {
            NBTTagCompound mainDriveTag = new NBTTagCompound();
            mainDriveTag.func_74778_a("name", this.mainDrive.getName());
            mainDriveTag.func_74778_a("uuid", this.mainDrive.getUUID().toString());
            mainDriveTag.func_74778_a("type", this.mainDrive.getType().toString());
            nbt.func_74782_a("main_drive", (NBTBase)mainDriveTag);
            nbt.func_74782_a("structure", (NBTBase)this.mainDrive.getDriveStructure().toTag());
        }
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
        if (this.isSucessful() && Minecraft.func_71410_x().field_71462_r instanceof Laptop) {
            NBTTagCompound structureTag = nbt.func_74775_l("structure");
            Drive drive = new Drive(nbt.func_74775_l("main_drive"));
            drive.syncRoot(Folder.fromTag("Root", structureTag));
            drive.getRoot().validate();
            if (Laptop.getMainDrive() == null) {
                Laptop.setMainDrive(drive);
            }
        }
    }
}

