/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.object;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.proxy.ClientProxy;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class AppInfo {
    public static final Comparator<AppInfo> SORT_NAME = Comparator.comparing(AppInfo::getName);
    private final transient ResourceLocation APP_ID;
    private transient int iconU = 0;
    private transient int iconV = 0;
    private transient boolean systemApp;
    private String name;
    private String author;
    private String description;
    private String version;
    private String icon;
    private String[] screenshots;
    private Support support;

    public AppInfo(ResourceLocation identifier, boolean isSystemApp) {
        this.APP_ID = identifier;
        this.systemApp = isSystemApp;
    }

    public ResourceLocation getId() {
        return this.APP_ID;
    }

    public String getFormattedId() {
        return this.APP_ID.func_110624_b() + "." + this.APP_ID.func_110623_a();
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getIconU() {
        return this.iconU;
    }

    public int getIconV() {
        return this.iconV;
    }

    public String[] getScreenshots() {
        return this.screenshots;
    }

    public Support getSupport() {
        return this.support;
    }

    public boolean isSystemApp() {
        return this.systemApp;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInfo)) {
            return false;
        }
        AppInfo info = (AppInfo)obj;
        return this == info || this.getFormattedId().equals(info.getFormattedId());
    }

    public void reload() {
        this.resetInfo();
        InputStream stream = ClientProxy.class.getResourceAsStream("/assets/" + this.APP_ID.func_110624_b() + "/apps/" + this.APP_ID.func_110623_a() + ".json");
        if (stream == null) {
            throw new RuntimeException("Missing app info json for '" + this.APP_ID + "'");
        }
        InputStreamReader reader = new InputStreamReader(stream);
        JsonParser parser = new JsonParser();
        JsonElement obj = parser.parse((Reader)reader);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(AppInfo.class, (Object)new Deserializer(this));
        Gson gson = builder.create();
        gson.fromJson(obj, AppInfo.class);
    }

    private void resetInfo() {
        this.name = null;
        this.author = null;
        this.description = null;
        this.version = null;
        this.icon = null;
        this.screenshots = null;
        this.support = null;
    }

    static /* synthetic */ String[] access$402(AppInfo x0, String[] x1) {
        x0.screenshots = x1;
        return x1;
    }

    public static class Deserializer
    implements JsonDeserializer<AppInfo> {
        private static final Pattern LANG = Pattern.compile("\\$\\{[a-z]+}");
        private AppInfo info;

        public Deserializer(AppInfo info) {
            this.info = info;
        }

        public AppInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            try {
                this.info.name = this.convertToLocal(json.getAsJsonObject().get("name").getAsString());
                this.info.author = this.convertToLocal(json.getAsJsonObject().get("author").getAsString());
                this.info.description = this.convertToLocal(json.getAsJsonObject().get("description").getAsString());
                this.info.version = json.getAsJsonObject().get("version").getAsString();
                if (json.getAsJsonObject().has("screenshots") && json.getAsJsonObject().get("screenshots").isJsonArray()) {
                    AppInfo.access$402(this.info, (String[])context.deserialize(json.getAsJsonObject().get("screenshots"), new TypeToken<String[]>(){}.getType()));
                }
                if (json.getAsJsonObject().has("icon") && json.getAsJsonObject().get("icon").isJsonPrimitive()) {
                    this.info.icon = json.getAsJsonObject().get("icon").getAsString();
                }
                if (json.getAsJsonObject().has("support") && json.getAsJsonObject().get("support").getAsJsonObject().size() > 0) {
                    JsonObject supportObj = json.getAsJsonObject().get("support").getAsJsonObject();
                    Support support = new Support();
                    if (supportObj.has("paypal")) {
                        support.paypal = supportObj.get("paypal").getAsString();
                    }
                    if (supportObj.has("patreon")) {
                        support.patreon = supportObj.get("patreon").getAsString();
                    }
                    if (supportObj.has("twitter")) {
                        support.twitter = supportObj.get("twitter").getAsString();
                    }
                    if (supportObj.has("youtube")) {
                        support.youtube = supportObj.get("youtube").getAsString();
                    }
                    this.info.support = support;
                }
            }
            catch (JsonParseException e) {
                MrCrayfishDeviceMod.getLogger().error("Malformed app info json for '" + this.info.getFormattedId() + "'");
            }
            return this.info;
        }

        private String convertToLocal(String s) {
            Matcher m = LANG.matcher(s);
            while (m.find()) {
                String found = m.group();
                s = s.replace(found, I18n.func_135052_a((String)("app." + this.info.getFormattedId() + "." + found.substring(2, found.length() - 1)), (Object[])new Object[0]));
            }
            return s;
        }
    }

    private static class Support {
        private String paypal;
        private String patreon;
        private String twitter;
        private String youtube;

        private Support() {
        }
    }
}

