/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.object;

import com.mrcrayfish.device.object.Game;
import com.mrcrayfish.device.object.tiles.Tile;
import com.mrcrayfish.device.util.Vec2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBoat;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class Player {
    private static final ResourceLocation boatTextures = new ResourceLocation("textures/entity/boat.png");
    private Game game;
    private double posX;
    private double posY;
    private double posXPrev;
    private double posYPrev;
    private double speed;
    private int rotation;
    private int rotationPrev;
    private Vec2d direction;
    private Vec2d velocity;
    private ModelBoat boatModel;
    private ModelDummyPlayer playerModel;
    boolean canMove = false;

    public Player(Game game) {
        this.game = game;
        this.direction = new Vec2d(0.0, 0.0);
        this.velocity = new Vec2d(0.0, 0.0);
        this.boatModel = new ModelBoat();
        boolean slim = Minecraft.func_71410_x().field_71439_g.func_175154_l().equals("slim");
        this.playerModel = new ModelDummyPlayer(0.0f, slim);
        this.playerModel.field_78093_q = true;
        this.playerModel.field_78091_s = false;
    }

    public void tick() {
        Tile tile;
        this.rotationPrev = this.rotation;
        this.posXPrev = this.posX;
        this.posYPrev = this.posY;
        if (Keyboard.isKeyDown((int)200)) {
            this.speed += 0.5;
            if (this.speed >= 3.0) {
                this.speed = 3.0;
            }
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.speed += 2.0;
            }
        } else {
            this.speed /= 1.1;
        }
        if (Keyboard.isKeyDown((int)203)) {
            this.rotation -= 8;
        }
        if (Keyboard.isKeyDown((int)205)) {
            this.rotation += 8;
        }
        if ((tile = this.game.getTile(Game.Layer.BACKGROUND, this.getPosX(), this.getPosY())) != null && tile.isSlow()) {
            this.speed *= 0.1;
        }
        this.direction.x = Math.cos(Math.toRadians(this.rotation));
        this.direction.y = Math.sin(Math.toRadians(this.rotation));
        this.direction.normalise();
        this.velocity.x = this.direction.x * this.speed;
        this.velocity.y = this.direction.y * this.speed;
        this.canMove = this.canMove();
        if (this.canMove) {
            this.posX += this.velocity.x;
            this.posY += this.velocity.y;
        } else {
            this.speed = 0.0;
        }
    }

    public boolean canMove() {
        if (this.posX + this.velocity.x <= 0.0) {
            return false;
        }
        if (this.posY + this.velocity.y <= 0.0) {
            return false;
        }
        if (this.posX + this.velocity.x >= (double)(this.game.mapWidth * 8)) {
            return false;
        }
        return !(this.posY + this.velocity.y >= (double)(this.game.mapHeight * 6));
    }

    public int getPosX() {
        return (int)(this.posX / 8.0);
    }

    public int getPosY() {
        return (int)(this.posY / 6.0);
    }

    public void render(int x, int y, float partialTicks) {
        float scale = 0.5f;
        double px = (double)x + this.posXPrev + (this.posX - this.posXPrev) * (double)partialTicks;
        double py = (double)y + this.posYPrev + (this.posY - this.posYPrev) * (double)partialTicks;
        float rot = (float)this.rotationPrev + (float)(this.rotation - this.rotationPrev) * partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)px), (float)((float)py), (float)3.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)(-scale));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-3.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(boatTextures);
        this.boatModel.func_78088_a((Entity)null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)px), (float)((float)py), (float)3.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)5.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(rot - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-12.0f, (float)5.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Minecraft.func_71410_x().field_71439_g.func_110306_p());
        this.playerModel.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.func_179121_F();
    }

    public static class ModelDummyPlayer
    extends ModelBiped {
        public ModelRenderer bipedLeftArmwear;
        public ModelRenderer bipedRightArmwear;
        public ModelRenderer bipedLeftLegwear;
        public ModelRenderer bipedRightLegwear;
        public ModelRenderer bipedBodyWear;
        private ModelRenderer bipedCape;
        private ModelRenderer bipedDeadmau5Head;
        private boolean smallArms;

        public ModelDummyPlayer(float scale, boolean slim) {
            super(scale, 0.0f, 64, 64);
            this.smallArms = slim;
            this.bipedDeadmau5Head = new ModelRenderer((ModelBase)this, 24, 0);
            this.bipedDeadmau5Head.func_78790_a(-3.0f, -6.0f, -1.0f, 6, 6, 1, scale);
            this.bipedCape = new ModelRenderer((ModelBase)this, 0, 0);
            this.bipedCape.func_78787_b(64, 32);
            this.bipedCape.func_78790_a(-5.0f, 0.0f, -1.0f, 10, 16, 1, scale);
            if (slim) {
                this.field_178724_i = new ModelRenderer((ModelBase)this, 32, 48);
                this.field_178724_i.func_78790_a(-1.0f, -2.0f, -2.0f, 3, 12, 4, scale);
                this.field_178724_i.func_78793_a(5.0f, 2.5f, 0.0f);
                this.field_178723_h = new ModelRenderer((ModelBase)this, 40, 16);
                this.field_178723_h.func_78790_a(-2.0f, -2.0f, -2.0f, 3, 12, 4, scale);
                this.field_178723_h.func_78793_a(-5.0f, 2.5f, 0.0f);
                this.bipedLeftArmwear = new ModelRenderer((ModelBase)this, 48, 48);
                this.bipedLeftArmwear.func_78790_a(-1.0f, -2.0f, -2.0f, 3, 12, 4, scale + 0.25f);
                this.bipedLeftArmwear.func_78793_a(5.0f, 2.5f, 0.0f);
                this.bipedRightArmwear = new ModelRenderer((ModelBase)this, 40, 32);
                this.bipedRightArmwear.func_78790_a(-2.0f, -2.0f, -2.0f, 3, 12, 4, scale + 0.25f);
                this.bipedRightArmwear.func_78793_a(-5.0f, 2.5f, 10.0f);
            } else {
                this.field_178724_i = new ModelRenderer((ModelBase)this, 32, 48);
                this.field_178724_i.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, scale);
                this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
                this.bipedLeftArmwear = new ModelRenderer((ModelBase)this, 48, 48);
                this.bipedLeftArmwear.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, scale + 0.25f);
                this.bipedLeftArmwear.func_78793_a(5.0f, 2.0f, 0.0f);
                this.bipedRightArmwear = new ModelRenderer((ModelBase)this, 40, 32);
                this.bipedRightArmwear.func_78790_a(-3.0f, -2.0f, -2.0f, 4, 12, 4, scale + 0.25f);
                this.bipedRightArmwear.func_78793_a(-5.0f, 2.0f, 10.0f);
            }
            this.field_178722_k = new ModelRenderer((ModelBase)this, 16, 48);
            this.field_178722_k.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, scale);
            this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
            this.bipedLeftLegwear = new ModelRenderer((ModelBase)this, 0, 48);
            this.bipedLeftLegwear.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, scale + 0.25f);
            this.bipedLeftLegwear.func_78793_a(1.9f, 12.0f, 0.0f);
            this.bipedRightLegwear = new ModelRenderer((ModelBase)this, 0, 32);
            this.bipedRightLegwear.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, scale + 0.25f);
            this.bipedRightLegwear.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.bipedBodyWear = new ModelRenderer((ModelBase)this, 16, 32);
            this.bipedBodyWear.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, scale + 0.25f);
            this.bipedBodyWear.func_78793_a(0.0f, 0.0f, 0.0f);
        }

        public void func_78088_a(Entity entityIn, float p_78088_2_, float p_78088_3_, float p_78088_4_, float p_78088_5_, float p_78088_6_, float scale) {
            this.func_78087_a(p_78088_2_, p_78088_3_, p_78088_4_, p_78088_5_, p_78088_6_, scale, entityIn);
            GlStateManager.func_179094_E();
            this.field_78116_c.func_78785_a(scale);
            this.field_78115_e.func_78785_a(scale);
            this.field_178723_h.func_78785_a(scale);
            this.field_178724_i.func_78785_a(scale);
            this.field_178721_j.func_78785_a(scale);
            this.field_178722_k.func_78785_a(scale);
            this.field_178720_f.func_78785_a(scale);
            this.bipedLeftLegwear.func_78785_a(scale);
            this.bipedRightLegwear.func_78785_a(scale);
            this.bipedLeftArmwear.func_78785_a(scale);
            this.bipedRightArmwear.func_78785_a(scale);
            this.bipedBodyWear.func_78785_a(scale);
            GlStateManager.func_179121_F();
        }

        public void func_78087_a(float p_78087_1_, float p_78087_2_, float p_78087_3_, float p_78087_4_, float p_78087_5_, float p_78087_6_, Entity entityIn) {
            super.func_78087_a(p_78087_1_, p_78087_2_, p_78087_3_, p_78087_4_, p_78087_5_, p_78087_6_, entityIn);
            ModelDummyPlayer.func_178685_a((ModelRenderer)this.field_178722_k, (ModelRenderer)this.bipedLeftLegwear);
            ModelDummyPlayer.func_178685_a((ModelRenderer)this.field_178721_j, (ModelRenderer)this.bipedRightLegwear);
            ModelDummyPlayer.func_178685_a((ModelRenderer)this.field_178724_i, (ModelRenderer)this.bipedLeftArmwear);
            ModelDummyPlayer.func_178685_a((ModelRenderer)this.field_178723_h, (ModelRenderer)this.bipedRightArmwear);
            ModelDummyPlayer.func_178685_a((ModelRenderer)this.field_78115_e, (ModelRenderer)this.bipedBodyWear);
            this.bipedCape.field_78797_d = 0.0f;
        }
    }
}

