/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.gitweb.module;

import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.io.File;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.programs.gitweb.component.GitWebFrame;
import com.mrcrayfish.device.programs.gitweb.module.Module;
import java.awt.Color;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class DownloadModule
extends Module {
    @Override
    public String[] getRequiredData() {
        return new String[]{"file-app", "file-data"};
    }

    @Override
    public String[] getOptionalData() {
        return new String[]{"file-name", "text"};
    }

    @Override
    public int calculateHeight(Map<String, String> data, int width) {
        return 45;
    }

    @Override
    public void generate(GitWebFrame frame, Layout layout, int width, Map<String, String> data) {
        int height = this.calculateHeight(data, width) - 5;
        AppInfo info = ApplicationManager.getApplication(data.get("file-app"));
        layout.setBackground((gui, mc, x, y, width1, height1, mouseX, mouseY, windowActive) -> {
            int section = layout.width / 6;
            int subWidth = section * 4;
            int posX = x + section;
            int posY = y + 5;
            Gui.func_73734_a((int)posX, (int)posY, (int)(posX + subWidth), (int)(posY + height - 5), (int)Color.BLACK.getRGB());
            Gui.func_73734_a((int)(posX + 1), (int)(posY + 1), (int)(posX + subWidth - 1), (int)(posY + height - 5 - 1), (int)Color.DARK_GRAY.getRGB());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Laptop.ICON_TEXTURES);
            int iconU = 0;
            int iconV = 0;
            if (info != null) {
                iconU = info.getIconU();
                iconV = info.getIconV();
            }
            RenderUtil.drawRectWithTexture(posX + 5, posY + 3, iconU, iconV, 28, 28, 14.0f, 14.0f, 224, 224);
            int textWidth = subWidth - 70 - 10 - 30 - 5;
            RenderUtil.drawStringClipped(data.getOrDefault("file-name", "File"), posX + 37, posY + 7, textWidth, Color.ORANGE.getRGB(), true);
            if (data.containsKey("text")) {
                RenderUtil.drawStringClipped((String)data.get("text"), posX + 37, posY + 19, textWidth, Color.LIGHT_GRAY.getRGB(), false);
            }
        });
        int section = layout.width / 6;
        Button button = new Button(0, 10, "Download", Icons.IMPORT);
        button.left = section * 5 - 70 - 5;
        button.setSize(70, height - 15);
        button.setClickListener((mouseX, mouseY, mouseButton) -> {
            try {
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)((String)data.get("file-data")));
                File file = new File(data.getOrDefault("file-name", ""), (String)data.get("file-app"), tag);
                Dialog.SaveFile dialog = new Dialog.SaveFile(frame.getApp(), file);
                frame.getApp().openDialog(dialog);
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        });
        layout.addComponent(button);
    }
}

