/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thedarkcolour.futuremc.asm.ASMUtil;
import thedarkcolour.futuremc.compat.Compat;
import vazkii.quark.api.ClassTransformer;

public final class CoreTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        try {
            switch (transformedName) {
                case "net.minecraft.client.renderer.EntityRenderer": {
                    return ASMUtil.patch(basicClass, CoreTransformer::patchEntityRenderer);
                }
                case "net.minecraft.world.gen.feature.WorldGenTrees": {
                    return ASMUtil.patch(basicClass, CoreTransformer::patchWorldGenTrees);
                }
                case "net.minecraft.world.gen.feature.WorldGenBigTree": {
                    return ASMUtil.patch(basicClass, CoreTransformer::patchWorldGenBigTree);
                }
                case "net.minecraft.entity.EntityLivingBase": {
                    return ASMUtil.patch(basicClass, CoreTransformer::patchEntityLivingBase, 1);
                }
                case "net.minecraft.item.Item": {
                    return ASMUtil.patch(basicClass, CoreTransformer::patchItem);
                }
                case "net.minecraft.entity.monster.EntitySnowman": {
                    return ASMUtil.patch(basicClass, CoreTransformer::patchEntitySnowman);
                }
                case "net.minecraft.server.management.PlayerInteractionManager": {
                    return ASMUtil.patch(basicClass, CoreTransformer::patchPlayerInteractionManager, 1);
                }
                case "net.minecraft.client.model.ModelBiped": {
                    return ASMUtil.patch(basicClass, CoreTransformer::patchModelBiped);
                }
                case "com.fuzs.gamblingstyle.handler.OpenContainerHandler": {
                    return ASMUtil.patch(basicClass, CoreTransformer::transformOpenContainerHandler);
                }
                case "net.minecraft.block.BlockPistonBase": {
                    try {
                        Class.forName("vazkii.quark.base.asm.LoadingPlugin");
                    }
                    catch (ClassNotFoundException e) {
                        return ClassTransformer.transformBlockPistonBase(basicClass);
                    }
                    return basicClass;
                }
                case "com.pg85.otg.customobjects.bo3.BO3Loader": {
                    return ASMUtil.patch(basicClass, CoreTransformer::transformBO3Loader);
                }
                case "biomesoplenty.common.world.generator.tree.GeneratorTreeBase": {
                    return ASMUtil.patch(basicClass, CoreTransformer::transformBOPTree);
                }
            }
        }
        catch (NoClassDefFoundError e) {
            return basicClass;
        }
        return basicClass;
    }

    private static void patchEntityPlayer(ClassNode classNode) {
        MethodNode canEat = ASMUtil.findMethod(classNode, "func_71043_e", "canEat", null);
        InsnList instructions = canEat.instructions;
        boolean labels = false;
        LabelNode l1 = null;
        VarInsnNode iload0 = null;
        for (int i2 = 0; i2 < instructions.size(); ++i2) {
            AbstractInsnNode node = instructions.get(i2);
            if (l1 == null && node.getClass() == LabelNode.class) {
                l1 = (LabelNode)node;
                continue;
            }
            if (iload0 != null || node.getClass() != VarInsnNode.class) continue;
            VarInsnNode n = (VarInsnNode)node;
            if (n.var != 1) continue;
            iload0 = n;
        }
        InsnList insertion = ASMUtil.createInsnList(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, "thedarkcolour/futuremc/asm/ASMHooks", "creativeEat", "(Lnet/minecraft/entity/player/EntityPlayer;Z)Z", false), new JumpInsnNode(153, l1), new LabelNode(new Label()), new InsnNode(4), new InsnNode(172)});
        instructions.insertBefore(instructions.getFirst(), insertion);
        instructions.insertBefore((AbstractInsnNode)iload0, (AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
    }

    private static void patchPlayerInteractionManager(ClassNode classNode) {
        MethodNode setGameType = ASMUtil.findMethod(classNode, "func_73076_a", "setGameType", null);
        ASMUtil.patchBeforeInsn(setGameType, ASMUtil.createInsnList(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, "thedarkcolour/futuremc/asm/ASMHooks", "setPrevGameType", "(Lnet/minecraft/server/management/PlayerInteractionManager;)V", false)}), 1, node -> node.getOpcode() == 25);
    }

    private static void patchItem(ClassNode classNode) {
        MethodNode method = ASMUtil.findMethod(classNode, "func_77613_e", "getRarity", null);
        method.instructions = ASMUtil.createInsnList(new AbstractInsnNode[]{new VarInsnNode(25, 0), new VarInsnNode(25, 1), new MethodInsnNode(184, "thedarkcolour/futuremc/asm/ASMHooks", "getEnchantmentRarity", "(Lnet/minecraft/item/Item;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/EnumRarity;", false), new InsnNode(176)});
    }

    private static void patchEntitySnowman(ClassNode classNode) {
        MethodNode method = ASMUtil.findMethod(classNode, "onSheared", "onSheared", null);
        method.instructions.insert(ASMUtil.createInsnList(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, "thedarkcolour/futuremc/asm/ASMHooks", "onSnowmanSheared", "(Lnet/minecraft/entity/monster/EntitySnowman;)V", false)}));
    }

    private static void patchEntityLivingBase(ClassNode classNode) {
        MethodNode travelNode = ASMUtil.findMethod(classNode, "func_191986_a", "travel", null);
        String collidedHorizontallyFieldName = ASMUtil.isObfuscated ? "field_70123_F" : "collidedHorizontally";
        String isJumpingFieldName = ASMUtil.isObfuscated ? "field_70703_bu" : "isJumping";
        for (AbstractInsnNode node : travelNode.instructions.toArray()) {
            int flagLoc;
            int n = flagLoc = ASMUtil.isObfuscated ? 21 : 9;
            if (node.getOpcode() != 54 || ((VarInsnNode)node).var != flagLoc) continue;
            travelNode.instructions.insert(node, ASMUtil.createInsnList(new AbstractInsnNode[]{new VarInsnNode(21, flagLoc), new VarInsnNode(25, 0), new MethodInsnNode(184, "thedarkcolour/futuremc/asm/ASMHooks", "scaffoldFallThrough", "(ZLnet/minecraft/entity/EntityLivingBase;)Z", false), new VarInsnNode(54, flagLoc)}));
            break;
        }
        int occurrence = 0;
        for (AbstractInsnNode node : travelNode.instructions.toArray()) {
            if (node.getOpcode() != 180 || !((FieldInsnNode)node).name.equals(collidedHorizontallyFieldName) || occurrence++ != 1) continue;
            LabelNode l74 = new LabelNode(new Label());
            travelNode.instructions.insert(node.getNext(), ASMUtil.createInsnList(new AbstractInsnNode[]{l74, new FrameNode(3, 0, null, 0, null)}));
            travelNode.instructions.insert(node, ASMUtil.createInsnList(new AbstractInsnNode[]{new JumpInsnNode(154, l74), new VarInsnNode(25, 0), new FieldInsnNode(180, "net/minecraft/entity/EntityLivingBase", isJumpingFieldName, "Z")}));
            break;
        }
    }

    private static void transformBOPTree(ClassNode classNode) {
        String fmcFieldName = "_fmc_has_placed_beehive";
        String className = "biomesoplenty/common/world/generator/tree/GeneratorTreeBase";
        classNode.visitField(2, fmcFieldName, "Z", null, (Object)false);
        InsnList toAddGetScatterY = ASMUtil.createInsnList(new AbstractInsnNode[]{new VarInsnNode(25, 0), new InsnNode(3), new FieldInsnNode(181, className, fmcFieldName, "Z")});
        ASMUtil.patchBeforeInsn(ASMUtil.findMethod(classNode, "getScatterY", "getScatterY", null), toAddGetScatterY, 1, node -> node.getOpcode() == 25);
        LabelNode l7 = new LabelNode(new Label());
        InsnList toAddSetLog = ASMUtil.createInsnList(new AbstractInsnNode[]{new VarInsnNode(25, 0), new FieldInsnNode(180, className, fmcFieldName, "Z"), new JumpInsnNode(154, l7), new VarInsnNode(25, 0), new VarInsnNode(25, 1), new VarInsnNode(25, 2), new MethodInsnNode(184, "thedarkcolour/futuremc/compat/biomesoplenty/BiomesOPlentyCompat", "placeBeehive", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false), new FieldInsnNode(181, className, fmcFieldName, "Z"), l7, new FrameNode(1, 1, new Object[]{"net/minecraft/block/state/IBlockState"}, 0, null)});
        ASMUtil.patchBeforeReturnTrue(ASMUtil.findMethod(classNode, "setLog", "setLog", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing$Axis;)Z"), toAddSetLog);
    }

    private static void transformBO3Loader(ClassNode classNode) {
        MethodNode mv = ASMUtil.findMethod(classNode, "loadFromFile", "loadFromFile", null);
        mv.instructions = new InsnList();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(58, l0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(184, "thedarkcolour/futuremc/compat/otg/OTGCompat", "patchBO3", "(Ljava/lang/String;Ljava/io/File;)Lcom/pg85/otg/customobjects/bo3/BO3;", false);
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "Lcom/pg85/otg/customobjects/bo3/BO3Loader;", null, l0, l1, 0);
        mv.visitLocalVariable("objectName", "Ljava/lang/String;", null, l0, l1, 1);
        mv.visitLocalVariable("file", "Ljava/io/File;", null, l0, l1, 2);
        mv.visitMaxs(2, 3);
    }

    private static void transformOpenContainerHandler(ClassNode classNode) {
        MethodNode mv = ASMUtil.findMethod(classNode, "onContainerOpen", "onContainerOpen", null);
        LabelNode label = null;
        try {
            label = (LabelNode)mv.instructions.getFirst();
        }
        catch (ClassCastException e) {
            for (int i2 = 0; i2 < 10; ++i2) {
                AbstractInsnNode insn = mv.instructions.get(i2);
                System.out.println(insn.getClass() + ": " + insn.getOpcode());
            }
        }
        InsnList list2 = new InsnList();
        list2.add((AbstractInsnNode)new LabelNode(new Label()));
        list2.add((AbstractInsnNode)new FieldInsnNode(178, "thedarkcolour/futuremc/config/FConfig", "INSTANCE", "Lthedarkcolour/futuremc/config/FConfig;"));
        list2.add((AbstractInsnNode)new MethodInsnNode(182, "thedarkcolour/futuremc/config/FConfig", "getVillageAndPillage", "()Lthedarkcolour/futuremc/config/FConfig$VillageAndPillage;", false));
        list2.add((AbstractInsnNode)new FieldInsnNode(180, "thedarkcolour/futuremc/config/FConfig$VillageAndPillage", "newVillagerGui", "Z"));
        list2.add((AbstractInsnNode)new JumpInsnNode(153, label));
        list2.add((AbstractInsnNode)new InsnNode(177));
        mv.instructions.insertBefore((AbstractInsnNode)label, list2);
    }

    private static void patchEntityRenderer(ClassNode classNode) {
        if (Compat.checkVivecraft()) {
            return;
        }
        MethodNode method = ASMUtil.findMethod(classNode, "func_175068_a", "renderWorldPass", null);
        MethodInsnNode target = ASMUtil.findMethodInsn(method, "func_70055_a", "isInsideOfMaterial", null);
        method.instructions.remove(target.getPrevious().getPrevious());
        method.instructions.remove(target.getPrevious());
        method.instructions.remove(method.instructions.get(method.instructions.indexOf((AbstractInsnNode)target) + 1));
        method.instructions.remove((AbstractInsnNode)target);
    }

    private static void patchWorldGenTrees(ClassNode classNode) {
        MethodNode method = ASMUtil.findMethod(classNode, "func_180709_b", "generate", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;)Z");
        InsnList toAdd = ASMUtil.createInsnList(new AbstractInsnNode[]{new VarInsnNode(25, 1), new VarInsnNode(25, 2), new VarInsnNode(25, 3), new VarInsnNode(21, 4), new MethodInsnNode(184, "thedarkcolour/futuremc/world/gen/feature/BeeNestGenerator", "generateBeeNestsForSmallTrees", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;I)V", false)});
        ASMUtil.patchBeforeReturnTrue(method, toAdd);
    }

    private static void patchWorldGenBigTree(ClassNode classNode) {
        MethodNode method = ASMUtil.findMethod(classNode, "func_180709_b", "generate", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;)Z");
        InsnList toAdd = ASMUtil.createInsnList(new AbstractInsnNode[]{new VarInsnNode(25, 1), new VarInsnNode(25, 2), new VarInsnNode(25, 3), new VarInsnNode(25, 0), new FieldInsnNode(180, "net/minecraft/world/gen/feature/WorldGenBigTree", ASMUtil.isObfuscated ? "field_76501_f" : "height", "I"), new VarInsnNode(25, 0), new MethodInsnNode(184, "thedarkcolour/futuremc/world/gen/feature/BeeNestGenerator", "generateBeeNestsForBigTrees", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/gen/feature/WorldGenAbstractTree;)V", false)});
        ASMUtil.patchBeforeReturnTrue(method, toAdd);
    }

    private static void patchModelBiped(ClassNode classNode) {
        MethodNode method = ASMUtil.findMethod(classNode, "func_78087_a", "setRotationAngles", "(FFFFFFLnet/minecraft/entity/Entity;)V");
        InsnList toAdd = ASMUtil.createInsnList(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, "thedarkcolour/futuremc/asm/ASMHooks", "rotateByPose", "(Lnet/minecraft/client/model/ModelBiped;)V", false)});
        ASMUtil.patchBeforeMcMethod(method, toAdd, "func_178685_a", "copyModelAngles", 1);
    }
}

