/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block.buzzybees;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.core.block.FBlock;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.compat.Compat;
import thedarkcolour.futuremc.compat.quark.QuarkCompat;
import thedarkcolour.futuremc.config.FConfig;
import thedarkcolour.futuremc.registry.FSounds;
import vazkii.quark.api.INonSticky;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J@\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J,\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010$\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020 H\u0016J(\u0010)\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020 2\u0006\u0010*\u001a\u00020+H\u0016J(\u0010,\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u0012H\u0016J\u0018\u0010/\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010(\u001a\u00020 H\u0002J\u0018\u00100\u001a\u00020'2\u0006\u0010(\u001a\u00020 2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020'2\u0006\u0010(\u001a\u00020 H\u0002\u00a8\u00065"}, d2={"Lthedarkcolour/futuremc/block/buzzybees/HoneyBlockBlock;", "Lthedarkcolour/core/block/FBlock;", "Lvazkii/quark/api/INonSticky;", "properties", "Lthedarkcolour/core/block/FBlock$Properties;", "(Lthedarkcolour/core/block/FBlock$Properties;)V", "canStickToBlock", "", "world", "Lnet/minecraft/world/World;", "pistonPos", "Lnet/minecraft/util/math/BlockPos;", "pos", "slimePos", "state", "Lnet/minecraft/block/state/IBlockState;", "slimeState", "direction", "Lnet/minecraft/util/EnumFacing;", "getAiPathNodeType", "Lnet/minecraft/pathfinding/PathNodeType;", "worldIn", "Lnet/minecraft/world/IBlockAccess;", "entityLiving", "Lnet/minecraft/entity/EntityLiving;", "getCollisionBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "blockState", "getRenderLayer", "Lnet/minecraft/util/BlockRenderLayer;", "hasSlideParticles", "entity", "Lnet/minecraft/entity/Entity;", "isFullBlock", "isFullCube", "isOpaqueCube", "isSliding", "isStickyBlock", "onEntityCollision", "", "entityIn", "onFallenUpon", "fallDistance", "", "shouldSideBeRendered", "blockAccess", "side", "slideParticles", "spawnParticles", "particleCount", "", "updateVelocity", "Companion", "Future-MC"})
public final class HoneyBlockBlock
extends FBlock
implements INonSticky {
    private static final AxisAlignedBB AABB;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public AxisAlignedBB func_180646_a(@NotNull IBlockState blockState, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return AABB;
    }

    public void func_180658_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull Entity entityIn, float fallDistance) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        entityIn.func_184185_a(FSounds.INSTANCE.getHONEY_BLOCK_SLIDE(), 1.0f, 1.0f);
        if (worldIn.field_72995_K) {
            this.spawnParticles(entityIn, 10);
        }
        entityIn.func_180430_e(fallDistance, 0.2f);
    }

    public void func_180634_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entityIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        if (this.isSliding(pos, entityIn)) {
            this.updateVelocity(entityIn);
            this.slideParticles(worldIn, entityIn);
        } else {
            entityIn.field_70159_w *= 0.4;
            entityIn.field_70179_y *= 0.4;
        }
    }

    private final void updateVelocity(Entity entityIn) {
        if (entityIn.field_70181_x < -0.13) {
            double a = -0.05 / entityIn.field_70181_x;
            entityIn.field_70159_w *= a;
            entityIn.field_70181_x = -0.05;
            entityIn.field_70179_y *= a;
        }
        entityIn.field_70143_R = 0.0f;
    }

    private final boolean isSliding(BlockPos pos, Entity entity) {
        boolean bl;
        if (entity.field_70122_E) {
            bl = false;
        } else if (entity.field_70163_u > (double)pos.func_177956_o() + 0.9375 - 1.0E-7) {
            bl = false;
        } else if (entity.field_70181_x >= 0.0) {
            bl = false;
        } else {
            double d = (double)pos.func_177958_n() + 0.5 - entity.field_70165_t;
            double x = Math.abs(d);
            double d2 = (double)pos.func_177952_p() + 0.5 - entity.field_70161_v;
            double y = Math.abs(d2);
            double width = 0.4375 + (double)(entity.field_70130_N / 2.0f);
            bl = x + 1.0E-7 > width || y + 1.0E-7 > width;
        }
        return bl;
    }

    private final void slideParticles(World worldIn, Entity entityIn) {
        if (this.hasSlideParticles(entityIn)) {
            if (worldIn.field_73012_v.nextInt(5) == 0) {
                entityIn.func_184185_a(FSounds.INSTANCE.getHONEY_BLOCK_SLIDE(), 1.0f, 1.0f);
            }
            if (worldIn.field_72995_K && worldIn.field_73012_v.nextInt(5) == 0) {
                this.spawnParticles(entityIn, 5);
            }
        }
    }

    private final boolean hasSlideParticles(Entity entity) {
        return entity instanceof EntityLivingBase || entity instanceof EntityMinecart || entity instanceof EntityTNTPrimed || entity instanceof EntityBoat;
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnParticles(Entity entityIn, int particleCount) {
        int n = 0;
        int n2 = particleCount;
        while (n < n2) {
            void i2;
            entityIn.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)this.func_176223_P())});
            ++i2;
        }
    }

    public boolean func_176225_a(@NotNull IBlockState blockState, @NotNull IBlockAccess blockAccess, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockAccess, (String)"blockAccess");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        IBlockState iBlockState = blockAccess.func_180495_p(pos.func_177972_a(side));
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"blockAccess.getBlockState(pos.offset(side))");
        return Intrinsics.areEqual((Object)iBlockState.func_177230_c(), (Object)this) || super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149662_c(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return false;
    }

    public boolean func_149730_j(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return false;
    }

    public boolean func_149686_d(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return false;
    }

    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean isStickyBlock(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(@NotNull IBlockState state, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos, @Nullable EntityLiving entityLiving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return PathNodeType.WATER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canStickToBlock(@NotNull World world, @NotNull BlockPos pistonPos, @NotNull BlockPos pos, @NotNull BlockPos slimePos, @NotNull IBlockState state, @NotNull IBlockState slimeState, @NotNull EnumFacing direction) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pistonPos, (String)"pistonPos");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)slimePos, (String)"slimePos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)slimeState, (String)"slimeState");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        if (slimeState.func_177230_c() instanceof BlockSlime) return false;
        QuarkCompat quarkCompat = Compat.checkQuark();
        if (quarkCompat == null) return true;
        if (quarkCompat.isColoredSlime(slimeState)) return false;
        return true;
    }

    public HoneyBlockBlock(@NotNull FBlock.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.field_149782_v = 0.0f;
        this.func_149647_a(FConfig.INSTANCE.getUseVanillaCreativeTabs() ? CreativeTabs.field_78031_c : FutureMC.INSTANCE.getGROUP());
    }

    static {
        Companion = new Companion(null);
        AABB = FBlock.Companion.cube(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lthedarkcolour/futuremc/block/buzzybees/HoneyBlockBlock$Companion;", "", "()V", "AABB", "Lnet/minecraft/util/math/AxisAlignedBB;", "Future-MC"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

