/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.item;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.core.item.ModeledItem;
import thedarkcolour.core.util.UtilKt;
import thedarkcolour.futuremc.entity.fish.EntityFish;
import thedarkcolour.futuremc.entity.fish.tropical.EntityTropicalFish;
import thedarkcolour.futuremc.item.ExtensionsKt;
import thedarkcolour.futuremc.registry.FSounds;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\tJ0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lthedarkcolour/futuremc/item/FishBucketItem;", "E", "Lthedarkcolour/futuremc/entity/fish/EntityFish;", "Lthedarkcolour/core/item/ModeledItem;", "regName", "", "fishType", "Lkotlin/Function1;", "Lnet/minecraft/world/World;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "tooltip", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "handIn", "Lnet/minecraft/util/EnumHand;", "tryPlaceContainedLiquid", "", "player", "pos", "Lnet/minecraft/util/math/BlockPos;", "Future-MC"})
public final class FishBucketItem<E extends EntityFish>
extends ModeledItem {
    private final String regName;
    private final Function1<World, E> fishType;

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull EntityPlayer playerIn, @NotNull EnumHand handIn) {
        BlockPos pos;
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Intrinsics.checkNotNullParameter((Object)handIn, (String)"handIn");
        ItemStack stack = playerIn.func_184586_b(handIn);
        RayTraceResult result = this.func_77621_a(worldIn, playerIn, false);
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)playerIn, (World)worldIn, (ItemStack)stack, (RayTraceResult)result);
        if (ret != null) {
            return ret;
        }
        if (result == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos2 = result.func_178782_a();
        if (!worldIn.func_175660_a(playerIn, pos2)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        IBlockState iBlockState = worldIn.func_180495_p(pos2);
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"worldIn.getBlockState(pos)");
        boolean flag = iBlockState.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos2);
        BlockPos blockPos = pos = flag && result.field_178784_b == EnumFacing.UP ? pos2 : pos2.func_177972_a(result.field_178784_b);
        if (!playerIn.func_175151_a(pos, result.field_178784_b, stack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        BlockPos blockPos2 = pos;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"pos");
        if (this.tryPlaceContainedLiquid(playerIn, worldIn, blockPos2)) {
            if (!worldIn.field_72995_K) {
                EntityFish fish = (EntityFish)this.fishType.invoke((Object)worldIn);
                fish.setFromBucket(true);
                fish.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                if (fish instanceof EntityTropicalFish) {
                    ItemStack itemStack = stack;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack");
                    if (UtilKt.getOrCreateTag(itemStack).func_150297_b("BucketVariantTag", 3)) {
                        EntityTropicalFish entityTropicalFish = (EntityTropicalFish)fish;
                        NBTTagCompound nBTTagCompound = stack.func_77978_p();
                        Intrinsics.checkNotNull((Object)nBTTagCompound);
                        entityTropicalFish.setVariant(nBTTagCompound.func_74762_e("BucketVariantTag"));
                    } else {
                        ((EntityTropicalFish)fish).generateVariant();
                    }
                }
                worldIn.func_72838_d((Entity)fish);
            }
            if (playerIn instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)playerIn, pos, stack);
            }
            return !playerIn.func_184812_l_() ? new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(Items.field_151133_ar)) : new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryPlaceContainedLiquid(EntityPlayer player, World worldIn, BlockPos pos) {
        Material material;
        IBlockState state;
        IBlockState iBlockState = state = worldIn.func_180495_p(pos);
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"state");
        Material material2 = material = iBlockState.func_185904_a();
        Intrinsics.checkNotNullExpressionValue((Object)material2, (String)"material");
        boolean flag = !material2.func_76220_a();
        boolean flag1 = state.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
        if (!(worldIn.func_175623_d(pos) || flag || flag1)) {
            return false;
        }
        if (worldIn.field_73011_w.func_177500_n()) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            worldIn.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
            int n = 0;
            int n2 = 7;
            while (n <= n2) {
                void k;
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                ++k;
            }
        } else {
            if (!worldIn.field_72995_K && (flag || flag1) && !material.func_76224_d()) {
                worldIn.func_175655_b(pos, true);
            }
            worldIn.func_184133_a(player, pos, FSounds.INSTANCE.getBUCKET_EMPTY_FISH(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            BlockDynamicLiquid blockDynamicLiquid = Blocks.field_150358_i;
            Intrinsics.checkNotNullExpressionValue((Object)blockDynamicLiquid, (String)"Blocks.FLOWING_WATER");
            worldIn.func_180501_a(pos, blockDynamicLiquid.func_176223_P(), 11);
        }
        return true;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
            Intrinsics.checkNotNullParameter((Object)flagIn, (String)"flagIn");
            if (!Intrinsics.areEqual((Object)this.regName, (Object)"tropical_fish_bucket")) break block4;
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound != null) {
                NBTTagCompound nBTTagCompound2;
                NBTTagCompound tag = nBTTagCompound2 = nBTTagCompound;
                boolean bl = false;
                if (tag.func_150297_b("BucketVariantTag", 3)) {
                    int i2 = tag.func_74762_e("BucketVariantTag");
                    TextFormatting[] formatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
                    String s = "color.minecraft." + EntityTropicalFish.Companion.getBodyDyeColor(i2);
                    String s1 = "color.minecraft." + EntityTropicalFish.Companion.getPatternDyeColor(i2);
                    for (int variant : EntityTropicalFish.Companion.getSPECIAL_VARIANTS()) {
                        if (i2 != variant) continue;
                        String string = ExtensionsKt.applyTextFormatting((ITextComponent)new TextComponentTranslation(EntityTropicalFish.Companion.getTranslationPrefixSpecial(variant), new Object[0]), Arrays.copyOf(formatting, formatting.length)).func_150254_d();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TextComponentTranslation\u2026          ).formattedText");
                        tooltip.add(string);
                        return;
                    }
                    String string = ExtensionsKt.applyTextFormatting((ITextComponent)new TextComponentTranslation(EntityTropicalFish.Companion.getTranslationPrefix(i2), new Object[0]), Arrays.copyOf(formatting, formatting.length)).func_150254_d();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TextComponentTranslation\u2026formatting).formattedText");
                    tooltip.add(string);
                    TextComponentTranslation component = new TextComponentTranslation(s, new Object[0]);
                    if (Intrinsics.areEqual((Object)s, (Object)s1) ^ true) {
                        component.func_150258_a(", ").func_150257_a((ITextComponent)new TextComponentTranslation(s1, new Object[0]));
                    }
                    ExtensionsKt.applyTextFormatting((ITextComponent)component, Arrays.copyOf(formatting, formatting.length));
                    String string2 = component.func_150254_d();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"component.formattedText");
                    tooltip.add(string2);
                }
            }
        }
    }

    public FishBucketItem(@NotNull String regName, @NotNull Function1<? super World, ? extends E> fishType) {
        Intrinsics.checkNotNullParameter((Object)regName, (String)"regName");
        Intrinsics.checkNotNullParameter(fishType, (String)"fishType");
        super(regName);
        this.regName = regName;
        this.fishType = fishType;
        CreativeTabs creativeTabs = CreativeTabs.field_78026_f;
        Intrinsics.checkNotNullExpressionValue((Object)creativeTabs, (String)"CreativeTabs.MISC");
        this.setCreativeTab(creativeTabs);
    }
}

