#!/bin/bash

GAME_PACK_JAR=gamepack-v2.1.139171.jar
#GAME_PACK_JAR=./../CGSTools/gamepack/build/libs/gamepack.jar
JAVA_HOME="/cygdrive/c/Tools/Java/TencentKona-17.0.3.b1"
PATH=$PATH:$JAVA_HOME/bin

function usage() {
	echo "Usage: ./GamePack.sh [--ids=./data/game_folder_id.txt] [--host=nfs://9.136.191.199/f4bm68sy/] <game1 folderPath or folderId> <game2 folderPath or folderId> ..."
	echo "Example:"
	echo "    ./GamePack.sh --ids=./data/game_folder_id.txt --host=nfs://9.136.191.199/f4bm68sy/ \"D:\\gamedata\\Genshin Impact\" \"D:\\gamedata\\NBA 2K19\""
	echo "    ./GamePack.sh \"D:\\gamedata\\Genshin Impact\" \"D:\\gamedata\\NBA 2K19\""
	echo "    ./GamePack.sh GenshinImpact NBA2K19"
}

if [ "$#" -lt 1 ]; then
	usage
	exit 1
fi

declare -A FOLDER_ID_MAP
declare -A FOLDER_PATH_MAP

packing=false
nfsHost=nfs://9.136.191.199/f4bm68sy/
#Install-WindowsFeature NFS-Client
#mount \\9.136.191.199\f4bm68sy Z:
#nfsHost=Z:
folderIdFile=./data/game_folder_id.txt

function loadFolderIdsFile() {
	if [ ! -x "$1" ]; then
		echo "File not exists: $1"
		exit 2
	fi
	while read -r line; do
		FolderId="${line##*=}"		
		FolderPath=${line:0:-1-${#FolderId}}
		FOLDER_ID_MAP[${FolderId}]=${FolderPath}
		FOLDER_PATH_MAP[${FolderPath}]=${FolderId}
		#echo "${FOLDER_PATH_MAP[${FolderPath}]} -> ${FOLDER_ID_MAP[${FolderId}]}"
	done < "$1"
}

function packGame() {
	game=$1
	lcase=${game,,}
	folderId=""
	if [ "${lcase:0:12}" == "d:\\gamedata\\" ]; then
		game=${game:3}
		folderId=${FOLDER_PATH_MAP["${game}"]}
	elif [ "${FOLDER_ID_MAP["${game}"]}" != "" ]; then
		folderId=${game}
	fi
	if [ "${folderId}" == "" ]; then
		echo "Error: unkonw game folder path or folder id: \"${game}\""
		echo ""
		usage
		exit 3
	fi
	echo "`date +'%Y-%m-%d %H:%M:%S'` Packing \"D:\\${FOLDER_ID_MAP["${folderId}"]}\" to \"${nfsHost}/gamedata/zpk2/${folderId}/\" ..."
	java -jar "${GAME_PACK_JAR}" zpk -i "D:\\${FOLDER_ID_MAP["${folderId}"]}" -o "${nfsHost}/gamedata/zpk/${folderId}/${folderId}_`date +'%Y%m%d_%H%M%S'`.zpk"
	echo "`date +'%Y-%m-%d %H:%M:%S'` Done!"
	echo ""
}


for arg in "$@"; do
	#echo "arg=$arg"
	if [ "$packing" == "false" ]; then
		if [ "${arg:0:6}" == "--ids=" ]; then
			folderIdFile=${arg:6}
			continue
		elif [ "${arg:0:7}" == "--host=" ]; then
			nfsHost=${arg:7}
			continue
		else
			if [ "${nfsHost: -1}" == "/" ]; then
				nfsHost=${nfsHost:0:-1}
			fi
			echo "nfsHost=$nfsHost, folderIdFile=$folderIdFile"
			loadFolderIdsFile "${folderIdFile}"
			packing=true
		fi
	fi
	packGame "$arg"
done