/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.app;

import com.jediterm.app.PlatformUtilKt;
import com.jediterm.app.UrlFilter;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.LoggingTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.LinesStorageKt;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.jediterm.ui.AbstractTerminalFrame;
import com.jediterm.ui.debug.TerminalDebugUtil;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jediterm/app/JediTerm;", "Lcom/jediterm/ui/AbstractTerminalFrame;", "<init>", "()V", "createTtyConnector", "Lcom/jediterm/terminal/TtyConnector;", "configureEnvironmentVariables", "", "", "createTerminalWidget", "Lcom/jediterm/terminal/ui/JediTermWidget;", "settingsProvider", "Lcom/jediterm/terminal/ui/settings/SettingsProvider;", "LoggingPtyProcessTtyConnector", "JediTerm"})
public final class JediTerm
extends AbstractTerminalFrame {
    @Override
    @NotNull
    public TtyConnector createTtyConnector() {
        try {
            Object[] objectArray;
            Map<String, String> envs = this.configureEnvironmentVariables();
            if (PlatformUtilKt.isWindows()) {
                Object[] objectArray2 = new String[]{"powershell.exe"};
                objectArray = objectArray2;
            } else {
                String shell;
                String string = envs.get("SHELL");
                if (string == null) {
                    string = shell = "/bin/bash";
                }
                if (PlatformUtilKt.isMacOS()) {
                    var4_3 = new String[]{shell, "--login"};
                    objectArray = var4_3;
                } else {
                    var4_3 = new String[]{shell};
                    objectArray = var4_3;
                }
            }
            Object[] command = objectArray;
            Path path = Path.of(".", new String[0]).toAbsolutePath().normalize();
            Intrinsics.checkNotNullExpressionValue(path, "normalize(...)");
            String workingDirectory = ((Object)path).toString();
            AbstractTerminalFrame.LOG.info("Starting " + ArraysKt.joinToString$default(command, null, null, null, 0, null, null, 63, null) + " in " + workingDirectory);
            PtyProcess ptyProcess = new PtyProcessBuilder().setDirectory(workingDirectory).setInitialColumns(120).setInitialRows(20).setCommand((String[])command).setEnvironment(envs).setConsole(false).setUseWinConPty(true).start();
            Intrinsics.checkNotNullExpressionValue(ptyProcess, "start(...)");
            PtyProcess process = ptyProcess;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            return new LoggingPtyProcessTtyConnector(process, charset, ArraysKt.toList(command));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private final Map<String, String> configureEnvironmentVariables() {
        HashMap<String, String> envs = new HashMap<String, String>(System.getenv());
        if (PlatformUtilKt.isMacOS()) {
            ((Map)envs).put("LC_CTYPE", Charsets.UTF_8.name());
        }
        if (!PlatformUtilKt.isWindows()) {
            ((Map)envs).put("TERM", "xterm-256color");
        }
        return envs;
    }

    @Override
    @NotNull
    protected JediTermWidget createTerminalWidget(@NotNull SettingsProvider settingsProvider) {
        Intrinsics.checkNotNullParameter(settingsProvider, "settingsProvider");
        JediTermWidget widget = super.createTerminalWidget(settingsProvider);
        widget.addHyperlinkFilter(new UrlFilter());
        Intrinsics.checkNotNull(widget);
        return widget;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\bH\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jediterm/app/JediTerm$LoggingPtyProcessTtyConnector;", "Lcom/jediterm/pty/PtyProcessTtyConnector;", "Lcom/jediterm/terminal/LoggingTtyConnector;", "process", "Lcom/pty4j/PtyProcess;", "charset", "Ljava/nio/charset/Charset;", "command", "", "", "<init>", "(Lcom/pty4j/PtyProcess;Ljava/nio/charset/Charset;Ljava/util/List;)V", "MAX_LOG_SIZE", "", "myDataChunks", "Ljava/util/LinkedList;", "", "myStates", "Lcom/jediterm/terminal/LoggingTtyConnector$TerminalState;", "myWidget", "Lcom/jediterm/terminal/ui/JediTermWidget;", "logStart", "read", "buf", "offset", "length", "getChunks", "getStates", "getLogStart", "write", "", "string", "bytes", "", "setWidget", "widget", "JediTerm"})
    public static final class LoggingPtyProcessTtyConnector
    extends PtyProcessTtyConnector
    implements LoggingTtyConnector {
        private final int MAX_LOG_SIZE;
        @NotNull
        private final LinkedList<char[]> myDataChunks;
        @NotNull
        private final LinkedList<LoggingTtyConnector.TerminalState> myStates;
        @Nullable
        private JediTermWidget myWidget;
        private int logStart;

        public LoggingPtyProcessTtyConnector(@NotNull PtyProcess process, @NotNull Charset charset, @NotNull List<String> command) {
            Intrinsics.checkNotNullParameter(process, "process");
            Intrinsics.checkNotNullParameter(charset, "charset");
            Intrinsics.checkNotNullParameter(command, "command");
            super(process, charset, command);
            this.MAX_LOG_SIZE = 200;
            this.myDataChunks = new LinkedList();
            this.myStates = new LinkedList();
        }

        @Override
        public int read(@NotNull char[] buf, int offset, int length) throws IOException {
            Intrinsics.checkNotNullParameter(buf, "buf");
            int len = super.read(buf, offset, length);
            if (len > 0) {
                char[] arr = ArraysKt.copyOfRange(buf, offset, len);
                this.myDataChunks.add(arr);
                JediTermWidget jediTermWidget = this.myWidget;
                Intrinsics.checkNotNull(jediTermWidget);
                TerminalTextBuffer terminalTextBuffer = jediTermWidget.getTerminalTextBuffer();
                String string = terminalTextBuffer.getScreenLines();
                Intrinsics.checkNotNull(terminalTextBuffer);
                LoggingTtyConnector.TerminalState terminalState = new LoggingTtyConnector.TerminalState(string, TerminalDebugUtil.getStyleLines(terminalTextBuffer), LinesStorageKt.getLinesAsString(terminalTextBuffer.getHistoryLinesStorage()));
                this.myStates.add(terminalState);
                if (this.myDataChunks.size() > this.MAX_LOG_SIZE) {
                    this.myDataChunks.removeFirst();
                    this.myStates.removeFirst();
                    int n = this.logStart;
                    this.logStart = n + 1;
                }
            }
            return len;
        }

        @Override
        @NotNull
        public List<char[]> getChunks() {
            return new ArrayList(this.myDataChunks);
        }

        @Override
        @NotNull
        public List<LoggingTtyConnector.TerminalState> getStates() {
            return new ArrayList(this.myStates);
        }

        @Override
        public int getLogStart() {
            return this.logStart;
        }

        @Override
        public void write(@NotNull String string) throws IOException {
            Intrinsics.checkNotNullParameter(string, "string");
            AbstractTerminalFrame.LOG.debug("Writing in OutputStream : " + string);
            super.write(string);
        }

        @Override
        public void write(@NotNull byte[] bytes) throws IOException {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            String string = Arrays.toString(bytes);
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            AbstractTerminalFrame.LOG.debug("Writing in OutputStream : " + string + " " + new String(bytes, Charsets.UTF_8));
            super.write(bytes);
        }

        public final void setWidget(@NotNull JediTermWidget widget) {
            Intrinsics.checkNotNullParameter(widget, "widget");
            this.myWidget = widget;
        }
    }
}

