/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.emulator;

import com.jediterm.core.Color;
import com.jediterm.terminal.TerminalColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColorPalette {
    private static final TerminalColor[] COL_RES_256 = new TerminalColor[240];

    @NotNull
    public Color getForeground(@NotNull TerminalColor color) {
        if (color.isIndexed()) {
            int colorIndex = color.getColorIndex();
            this.assertColorIndexIsLessThan16(colorIndex);
            return this.getForegroundByColorIndex(colorIndex);
        }
        return color.toColor();
    }

    @NotNull
    protected abstract Color getForegroundByColorIndex(int var1);

    @NotNull
    public Color getBackground(@NotNull TerminalColor color) {
        if (color.isIndexed()) {
            int colorIndex = color.getColorIndex();
            this.assertColorIndexIsLessThan16(colorIndex);
            return this.getBackgroundByColorIndex(colorIndex);
        }
        return color.toColor();
    }

    @NotNull
    protected abstract Color getBackgroundByColorIndex(int var1);

    private void assertColorIndexIsLessThan16(int colorIndex) {
        if (colorIndex < 0 || colorIndex >= 16) {
            throw new AssertionError((Object)("Color index is out of bounds [0,15]: " + colorIndex));
        }
    }

    @Nullable
    public static TerminalColor getIndexedTerminalColor(int colorIndex) {
        return colorIndex < 16 ? TerminalColor.index(colorIndex) : ColorPalette.getXTerm256(colorIndex);
    }

    @Nullable
    private static TerminalColor getXTerm256(int colorIndex) {
        return colorIndex < 256 ? COL_RES_256[colorIndex - 16] : null;
    }

    private static int getCubeColorValue(int value) {
        return value == 0 ? 0 : 40 * value + 55;
    }

    static {
        for (int red = 0; red < 6; ++red) {
            for (int green = 0; green < 6; ++green) {
                for (int blue = 0; blue < 6; ++blue) {
                    ColorPalette.COL_RES_256[36 * red + 6 * green + blue] = new TerminalColor(ColorPalette.getCubeColorValue(red), ColorPalette.getCubeColorValue(green), ColorPalette.getCubeColorValue(blue));
                }
            }
        }
        for (int gray = 0; gray < 24; ++gray) {
            int level = 10 * gray + 8;
            ColorPalette.COL_RES_256[216 + gray] = new TerminalColor(level, level, level);
        }
    }
}

