/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.ui;

import com.jediterm.app.JediTerm;
import com.jediterm.app.TtyConnectorWaitFor;
import com.jediterm.core.compatibility.Point;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.SelectionUtil;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.TerminalWidget;
import com.jediterm.terminal.ui.settings.DefaultSettingsProvider;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.jediterm.ui.debug.TerminalDebugView;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.function.IntConsumer;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTerminalFrame {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractTerminalFrame.class);
    private JFrame myBufferFrame;
    private final JediTermWidget myWidget;
    private final AbstractAction myShowBuffersAction = new AbstractAction("Show buffers"){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractTerminalFrame.this.showBuffers();
        }
    };
    private final AbstractAction myDumpDimension = new AbstractAction("Dump terminal dimension"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Terminal terminal = AbstractTerminalFrame.this.myWidget.getTerminal();
            LOG.info(terminal.getTerminalWidth() + "x" + terminal.getTerminalHeight());
        }
    };
    private final AbstractAction myDumpSelection = new AbstractAction("Dump selection"){

        @Override
        public void actionPerformed(ActionEvent e) {
            JediTermWidget widget = AbstractTerminalFrame.this.myWidget;
            TerminalPanel terminalPanel = widget.getTerminalPanel();
            TerminalSelection selection = terminalPanel.getSelection();
            if (selection != null) {
                Pair<Point, Point> points = selection.pointsForRun(widget.getTerminal().getTerminalWidth());
                LOG.info(String.valueOf(selection) + " : '" + SelectionUtil.getSelectionText(points.getFirst(), points.getSecond(), terminalPanel.getTerminalTextBuffer()) + "'");
            } else {
                LOG.info("No selection");
            }
        }
    };
    private final AbstractAction myDumpCursorPosition = new AbstractAction("Dump cursor position"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LOG.info(AbstractTerminalFrame.this.myWidget.getTerminal().getCursorX() + "x" + AbstractTerminalFrame.this.myWidget.getTerminal().getCursorY());
        }
    };
    private final AbstractAction myCursor0x0 = new AbstractAction("1x1"){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractTerminalFrame.this.myWidget.getTerminal().cursorPosition(1, 1);
        }
    };
    private final AbstractAction myCursor10x10 = new AbstractAction("10x10"){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractTerminalFrame.this.myWidget.getTerminal().cursorPosition(10, 10);
        }
    };
    private final AbstractAction myCursor80x24 = new AbstractAction("80x24"){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractTerminalFrame.this.myWidget.getTerminal().cursorPosition(80, 24);
        }
    };

    private JMenuBar getJMenuBar() {
        Level[] levels;
        JMenuBar mb = new JMenuBar();
        JMenu dm = new JMenu("Debug");
        JMenu logLevel = new JMenu("Set log level ...");
        for (final Level l : levels = new Level[]{Level.ALL, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF}) {
            logLevel.add(new AbstractAction(l.toString()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    java.util.logging.Logger.getLogger("").setLevel(l);
                }
            });
        }
        dm.add(logLevel);
        dm.addSeparator();
        dm.add(this.myShowBuffersAction);
        dm.addSeparator();
        dm.add(this.myDumpDimension);
        dm.add(this.myDumpSelection);
        dm.add(this.myDumpCursorPosition);
        JMenu cursorPosition = new JMenu("Set cursor position ...");
        cursorPosition.add(this.myCursor0x0);
        cursorPosition.add(this.myCursor10x10);
        cursorPosition.add(this.myCursor80x24);
        dm.add(cursorPosition);
        mb.add(dm);
        return mb;
    }

    protected void openSession(TerminalWidget terminal) {
        if (terminal.canOpenSession()) {
            this.openSession(terminal, this.createTtyConnector());
        }
    }

    public void openSession(TerminalWidget terminal, TtyConnector ttyConnector) {
        JediTermWidget session = terminal.createTerminalSession(ttyConnector);
        if (ttyConnector instanceof JediTerm.LoggingPtyProcessTtyConnector) {
            ((JediTerm.LoggingPtyProcessTtyConnector)ttyConnector).setWidget(session);
        }
        session.start();
    }

    public abstract TtyConnector createTtyConnector();

    protected AbstractTerminalFrame() {
        this.myWidget = this.createTerminalWidget(new DefaultSettingsProvider());
        JFrame frame = new JFrame("JediTerm");
        frame.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JMenuBar mb = this.getJMenuBar();
        frame.setJMenuBar(mb);
        this.sizeFrameForTerm(frame);
        frame.getContentPane().add("Center", this.myWidget.getComponent());
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
        frame.setResizable(true);
        this.myWidget.getTerminal().addApplicationTitleListener(frame::setTitle);
        this.openSession(this.myWidget);
        AbstractTerminalFrame.onTermination(this.myWidget, exitCode -> {
            this.myWidget.close();
            frame.dispose();
            System.exit(exitCode);
        });
    }

    private static void onTermination(@NotNull JediTermWidget widget, @NotNull IntConsumer terminationCallback) {
        new TtyConnectorWaitFor(widget.getTtyConnector(), widget.getExecutorServiceManager().getUnboundedExecutorService(), terminationCallback);
    }

    protected JediTermWidget createTerminalWidget(@NotNull SettingsProvider settingsProvider) {
        JediTermWidget widget = new JediTermWidget(settingsProvider);
        widget.getTerminalPanel().setDefaultCursorShape(CursorShape.BLINK_VERTICAL_BAR);
        return widget;
    }

    private void sizeFrameForTerm(JFrame frame) {
        SwingUtilities.invokeLater(() -> {
            Dimension d = this.myWidget.getPreferredSize();
            d.width += frame.getWidth() - frame.getContentPane().getWidth();
            d.height += frame.getHeight() - frame.getContentPane().getHeight();
            frame.setSize(d);
        });
    }

    private void showBuffers() {
        if (this.myBufferFrame != null) {
            this.myBufferFrame.requestFocus();
            return;
        }
        this.myBufferFrame = new JFrame("buffers");
        final TerminalDebugView debugView = new TerminalDebugView(this.myWidget);
        this.myBufferFrame.getContentPane().add(debugView.getComponent());
        this.myBufferFrame.pack();
        this.myBufferFrame.setLocationByPlatform(true);
        this.myBufferFrame.setVisible(true);
        this.myBufferFrame.setSize(1600, 800);
        this.closeOnEscape(this.myBufferFrame);
        this.myBufferFrame.setDefaultCloseOperation(2);
        this.myBufferFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                AbstractTerminalFrame.this.myBufferFrame = null;
                debugView.stop();
            }
        });
    }

    private void closeOnEscape(final JFrame frame) {
        frame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        frame.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
    }
}

